/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.file.def;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.bytes.ByteArray;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.util.IoUtil;

public class FileDefinition
extends ModuleDefinition {
    private static final long serialVersionUID = 1L;
    String dir;
    Map processFiles;
    private static final Log log = LogFactory.getLog((Class)FileDefinition.class);

    static String getRootDir() {
        String rootDir = null;
        if (JbpmConfiguration.Configs.hasObject("jbpm.files.dir")) {
            rootDir = JbpmConfiguration.Configs.getString("jbpm.files.dir");
        }
        return rootDir;
    }

    public ModuleInstance createInstance() {
        return null;
    }

    public void addFile(String name, byte[] bytes) {
        try {
            if (this.isStoredOnFileSystem()) {
                this.storeFileInFileSystem(name, bytes);
            } else {
                this.storeFileInDb(name, bytes);
            }
        }
        catch (IOException e) {
            throw new JbpmException("file '" + name + "' could not be stored", e);
        }
    }

    void storeFileInFileSystem(String name, byte[] bytes) throws IOException {
        File filePath = this.getFilePath(name);
        log.trace((Object)("storing '" + name + "' to file '" + filePath + "'"));
        FileOutputStream fos = new FileOutputStream(filePath);
        fos.write(bytes);
        fos.close();
    }

    void storeFileInDb(String name, byte[] bytes) {
        if (this.processFiles == null) {
            this.processFiles = new HashMap();
        }
        log.trace((Object)("preparing '" + name + "' for storage in the database"));
        this.processFiles.put(name, new ByteArray(name, bytes));
    }

    public void addFile(String name, InputStream is) {
        try {
            if (this.isStoredOnFileSystem()) {
                this.storeFileInFileSystem(name, is);
            } else {
                this.storeFileInDb(name, is);
            }
        }
        catch (IOException e) {
            throw new JbpmException("file '" + name + "' could not be stored", e);
        }
    }

    void storeFileInFileSystem(String name, InputStream is) throws IOException {
        File filePath = this.getFilePath(name);
        log.trace((Object)("storing '" + name + "' to file '" + filePath + "'"));
        FileOutputStream fos = new FileOutputStream(filePath);
        IoUtil.transfer(is, fos);
        fos.close();
    }

    void storeFileInDb(String name, InputStream is) throws IOException {
        if (this.processFiles == null) {
            this.processFiles = new HashMap();
        }
        log.trace((Object)("preparing '" + name + "' for storage in the database"));
        this.processFiles.put(name, new ByteArray(name, IoUtil.readBytes(is)));
    }

    public InputStream getInputStream(String name) {
        InputStream inputStream = this.isStoredOnFileSystem() ? this.getInputStreamFromFileSystem(name) : this.getInputStreamFromDb(name);
        return inputStream;
    }

    public boolean hasFile(String name) {
        if (this.isStoredOnFileSystem()) {
            return this.getFilePath(name).exists();
        }
        return this.processFiles != null ? this.processFiles.containsKey(name) : false;
    }

    public Map getInputStreamMap() {
        HashMap<String, InputStream> result = new HashMap<String, InputStream>();
        if (this.processFiles != null) {
            Iterator iter = this.processFiles.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                result.put(name, this.getInputStream(name));
            }
        }
        return result;
    }

    public Map getBytesMap() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        if (this.processFiles != null) {
            Iterator iter = this.processFiles.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                result.put(name, this.getBytes(name));
            }
        }
        return result;
    }

    private InputStream getInputStreamFromFileSystem(String name) {
        try {
            File filePath = this.getFilePath(name);
            if (log.isTraceEnabled()) {
                log.trace((Object)("loading '" + name + "' from file '" + filePath + "'"));
            }
            return filePath.canRead() ? new FileInputStream(filePath) : null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private InputStream getInputStreamFromDb(String name) {
        byte[] bytes;
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading '" + name + "' from database"));
        }
        return (bytes = this.getBytesFromDb(name)) != null ? new ByteArrayInputStream(bytes) : null;
    }

    public byte[] getBytes(String name) {
        byte[] bytes = this.isStoredOnFileSystem() ? this.getBytesFromFileSystem(name) : this.getBytesFromDb(name);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytesFromFileSystem(String name) {
        InputStream in = this.getInputStreamFromFileSystem(name);
        if (in == null) {
            return null;
        }
        try {
            byte[] byArray = IoUtil.readBytes(in);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    byte[] getBytesFromDb(String name) {
        ByteArray byteArray;
        if (this.processFiles != null && (byteArray = (ByteArray)this.processFiles.get(name)) != null) {
            return byteArray.getBytes();
        }
        return null;
    }

    boolean isStoredOnFileSystem() {
        boolean isStoredOnFileSystem;
        String rootDir = FileDefinition.getRootDir();
        boolean bl = isStoredOnFileSystem = rootDir != null;
        if (isStoredOnFileSystem && this.dir == null) {
            this.dir = this.findNewDirName();
            new File(rootDir, this.dir).mkdirs();
        }
        return isStoredOnFileSystem;
    }

    String findNewDirName() {
        String newDirName = "files-1";
        File parentFile = new File(FileDefinition.getRootDir());
        if (parentFile.exists()) {
            String[] children = parentFile.list();
            ArrayList<Object> fileNames = new ArrayList();
            if (children != null) {
                fileNames = new ArrayList<String>(Arrays.asList(children));
            }
            int seqNr = 1;
            while (fileNames.contains(newDirName)) {
                newDirName = "files-" + ++seqNr;
            }
        }
        return newDirName;
    }

    File getFilePath(String name) {
        File filePath = new File(FileDefinition.getRootDir() + File.separatorChar + this.dir + File.separatorChar + name);
        filePath.getParentFile().mkdirs();
        return filePath;
    }
}

