/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.client.Closeable;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.DummyJoinConnectionStrategy;
import org.jboss.remoting.samples.chat.client.JoinConnectionStrategy;
import org.jboss.remoting.samples.chat.client.JoinFrame_CancelButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.JoinFrame_OKButton_actionAdapter;
import org.jboss.remoting.samples.chat.exceptions.JoinConnectionException;

public class JoinFrame
extends CloseableFrame {
    JLabel jLabel1 = new JLabel();
    JTextField IDField = new JTextField();
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    private ChatInfo chatInfo;
    private JoinConnectionStrategy jcs;
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public JoinFrame(ChatInfo chatInfo, JoinConnectionStrategy jcs, Closeable parent) {
        super(parent);
        this.chatInfo = chatInfo;
        this.jcs = jcs;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jLabel1.setFont(new Font("SansSerif", 1, 12));
        this.jLabel1.setText("Your ID:");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.IDField.setText("");
        this.OKButton.setFont(new Font("SansSerif", 1, 12));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new JoinFrame_OKButton_actionAdapter(this));
        this.CancelButton.setFont(new Font("SansSerif", 1, 12));
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new JoinFrame_CancelButton_actionAdapter(this));
        this.setTitle("Join a Chat Room");
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(96, 82, 0, 0), 22, 5));
        this.getContentPane().add((Component)this.IDField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(96, 0, 0, 39), 215, 0));
        this.getContentPane().add((Component)this.CancelButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(47, 16, 43, 139), 0, 0));
        this.getContentPane().add((Component)this.OKButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(49, 108, 43, 0), 22, 0));
        this.pack();
        this.center();
    }

    public static void main(String[] args) {
        try {
            ChatMember chatMember = new ChatMember();
            chatMember.set_name("xyz");
            ChatInfo chatInfo = new ChatInfo();
            chatInfo.set_currentMembers(3);
            chatInfo.set_description("abc");
            chatInfo.set_origin(new Date());
            JoinFrame joinFrame = new JoinFrame(chatInfo, new DummyJoinConnectionStrategy(), null);
            joinFrame.show();
        }
        catch (JoinConnectionException ce) {
            System.out.println("unable to create chat frame");
        }
    }

    void OKButton_actionPerformed(ActionEvent e) {
        try {
            this.notifyOnClose(this);
            ChatMember chatMember = new ChatMember();
            chatMember.set_name(this.IDField.getText());
            this.jcs.join(this.chatInfo, chatMember);
        }
        catch (JoinConnectionException jce) {
            System.out.println("OK button catches exception:");
            System.out.println(jce);
        }
    }

    void CancelButton_actionPerformed(ActionEvent e) {
        this.notifyOnClose(this);
    }
}

