/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.auth.login.XMLLoginConfigMBean;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.system.ServiceMBeanSupport;

@JMX(name="jboss.security:service=XMLLoginConfig", exposedInterface=XMLLoginConfigMBean.class)
@ManagementObject(name="XMLLoginConfig", componentType=@ManagementComponent(type="MCBean", subtype="Security"), properties=ManagementProperties.EXPLICIT)
public class XMLLoginConfig
extends ServiceMBeanSupport
implements XMLLoginConfigMBean {
    XMLLoginConfigImpl config = XMLLoginConfigImpl.getInstance();

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The URL of the login configuration file")
    public URL getConfigURL() {
        return this.config.getConfigURL();
    }

    public void setConfigURL(URL configURL) {
        this.config.setConfigURL(configURL);
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Validate or not the login configuration file")
    public boolean getValidateDTD() {
        return this.config.getValidateDTD();
    }

    public void setValidateDTD(boolean flag) {
        this.config.setValidateDTD(flag);
    }

    @ManagementOperation(description="Set the resource name of the login config file", impact=ManagedOperation.Impact.WriteOnly)
    public void setConfigResource(String resourceName) throws IOException {
        this.config.setConfigResource(resourceName);
    }

    @ManagementOperation(description="Add an application policy for the specified domain", impact=ManagedOperation.Impact.WriteOnly)
    public void addApplicationPolicy(String appName, ApplicationPolicy aPolicy) {
        this.config.addApplicationPolicy(appName, aPolicy);
    }

    public void addAppConfig(String appName, AppConfigurationEntry[] entries) {
        this.config.addAppConfig(appName, entries);
    }

    public void removeAppConfig(String appName) {
        this.config.removeAppConfig(appName);
    }

    @ManagementOperation(description="Get the application policy for the specified domain", impact=ManagedOperation.Impact.ReadOnly)
    public ApplicationPolicy getApplicationPolicy(String domainName) {
        return this.config.getApplicationPolicy(domainName);
    }

    @ManagementOperation(description="Get the javax.security.auth.login.Configuration instance", impact=ManagedOperation.Impact.ReadOnly)
    public Configuration getConfiguration(Configuration prevConfig) {
        this.config.setParentConfig(prevConfig);
        return this.config;
    }

    @ManagementOperation(description="Load (parse) the login config file", impact=ManagedOperation.Impact.ReadWrite)
    public String[] loadConfig(URL configURL) throws Exception {
        return this.config.loadConfig(configURL);
    }

    @ManagementOperation(description="Remove the configuration of the specified domains", impact=ManagedOperation.Impact.WriteOnly)
    public void removeConfigs(String[] appNames) {
        int count = appNames == null ? 0 : appNames.length;
        for (int a = 0; a < count; ++a) {
            this.removeAppConfig(appNames[a]);
        }
    }

    @ManagementOperation(description="Display the configuration for the specified domain", impact=ManagedOperation.Impact.ReadOnly)
    public String displayAppConfig(String appName) {
        StringBuffer buffer = new StringBuffer("<h2>" + appName + " LoginConfiguration</h2>\n");
        AppConfigurationEntry[] appEntry = this.config.getAppConfigurationEntry(appName);
        if (appEntry == null) {
            buffer.append("No Entry\n");
        } else {
            for (int c = 0; c < appEntry.length; ++c) {
                AppConfigurationEntry entry = appEntry[c];
                buffer.append("LoginModule Class: " + entry.getLoginModuleName());
                buffer.append("\n<br>ControlFlag: " + entry.getControlFlag());
                buffer.append("\n<br>Options:<ul>");
                Map<String, ?> options = entry.getOptions();
                for (Map.Entry<String, ?> e : options.entrySet()) {
                    buffer.append("<li>");
                    buffer.append("name=" + e.getKey());
                    buffer.append(", value=" + e.getValue());
                    buffer.append("</li>\n");
                }
                buffer.append("</ul>\n");
            }
        }
        return buffer.toString();
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    protected void startService() throws Exception {
        this.config.loadConfig();
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    protected void destroyService() {
        this.config.clear();
    }
}

