/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.selector;

import java.util.HashMap;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import org.jboss.jms.server.selector.ISelectorParser;
import org.jboss.jms.server.selector.Identifier;
import org.jboss.jms.server.selector.Operator;
import org.jboss.jms.server.selector.SelectorParser;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Filter;

public class Selector
implements Filter {
    static Logger cat = Logger.getLogger(Selector.class);
    private static Class parserClass = SelectorParser.class;
    private static final Logger log = Logger.getLogger(Selector.class);
    public String selector;
    public HashMap identifiers;
    public Object result;
    private Class resultType;

    public String getFilterString() {
        return this.selector;
    }

    public static Class getSelectorParserClass() {
        return parserClass;
    }

    public static void setSelectorParserClass(Class parserClass) {
        Selector.parserClass = parserClass;
    }

    public Selector(String sel) throws InvalidSelectorException {
        this.selector = sel;
        this.identifiers = new HashMap();
        try {
            ISelectorParser bob = (ISelectorParser)parserClass.newInstance();
            this.result = bob.parse(sel, this.identifiers);
            this.resultType = this.result.getClass();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Invalid selector:" + sel));
            }
            throw new InvalidSelectorException("The selector is invalid: " + sel);
        }
    }

    public String getExpression() {
        return this.selector;
    }

    public synchronized boolean accept(org.jboss.messaging.core.contract.Message message) {
        try {
            Object res;
            if (!(message instanceof Message)) {
                return false;
            }
            Message mess = (Message)message;
            for (Identifier id : this.identifiers.values()) {
                Object find = mess.getObjectProperty(id.name);
                if (find == null) {
                    find = this.getHeaderFieldReferences(mess, id.name);
                }
                if (find == null) {
                    id.value = null;
                    continue;
                }
                Class<?> type = find.getClass();
                if (type.equals(Boolean.class) || type.equals(String.class) || type.equals(Double.class) || type.equals(Float.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Short.class) || type.equals(Byte.class)) {
                    id.value = find;
                    continue;
                }
                throw new Exception("Bad property '" + id.name + "' type: " + type);
            }
            if (this.resultType.equals(Identifier.class)) {
                res = ((Identifier)this.result).value;
            } else if (this.resultType.equals(Operator.class)) {
                Operator op = (Operator)this.result;
                res = op.apply();
            } else {
                res = this.result;
            }
            if (res == null) {
                return false;
            }
            if (!res.getClass().equals(Boolean.class)) {
                throw new Exception("Bad object type: " + res);
            }
            return (Boolean)res;
        }
        catch (Exception e) {
            cat.warn((Object)("Invalid selector: " + this.selector), (Throwable)e);
            return false;
        }
    }

    private Object getHeaderFieldReferences(Message mess, String idName) throws JMSException {
        if (idName.equals("JMSDeliveryMode")) {
            return mess.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT";
        }
        if (idName.equals("JMSPriority")) {
            return new Integer(mess.getJMSPriority());
        }
        if (idName.equals("JMSMessageID")) {
            return mess.getJMSMessageID();
        }
        if (idName.equals("JMSTimestamp")) {
            return new Long(mess.getJMSTimestamp());
        }
        if (idName.equals("JMSCorrelationID")) {
            return mess.getJMSCorrelationID();
        }
        if (idName.equals("JMSType")) {
            return mess.getJMSType();
        }
        return null;
    }
}

