/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.commands.remote.ClusteredGetCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.interceptors.InterceptorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicateCommand
implements ReplicableCommand {
    public static final int SINGLE_METHOD_ID = 13;
    public static final int MULTIPLE_METHOD_ID = 14;
    private InterceptorChain invoker;
    private static final Log log = LogFactory.getLog(ReplicateCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private ReplicableCommand singleModification;
    private List<ReplicableCommand> modifications;

    public ReplicateCommand(List<ReplicableCommand> modifications) {
        if (modifications != null && modifications.size() == 1) {
            this.singleModification = modifications.get(0);
        } else {
            this.modifications = modifications;
        }
    }

    public ReplicateCommand(ReplicableCommand command) {
        this.singleModification = command;
    }

    public ReplicateCommand() {
    }

    public void initialize(InterceptorChain interceptorChain) {
        this.invoker = interceptorChain;
    }

    public void setSingleModification(ReplicableCommand singleModification) {
        this.singleModification = singleModification;
    }

    public void setModifications(List<ReplicableCommand> modifications) {
        if (modifications != null && modifications.size() == 1) {
            this.singleModification = modifications.get(0);
        } else {
            this.modifications = modifications;
        }
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.isSingleCommand()) {
            Object retVal = this.processSingleCommand(this.singleModification);
            if (this.singleModification instanceof GravitateDataCommand) {
                return retVal;
            }
            return null;
        }
        for (ReplicableCommand command : this.modifications) {
            this.processSingleCommand(command);
        }
        return null;
    }

    private Object processSingleCommand(ReplicableCommand cacheCommand) throws Throwable {
        Object result;
        try {
            if (trace) {
                log.trace((Object)("Invoking command " + cacheCommand + ", with originLocal flag set to false."));
            }
            if (cacheCommand instanceof VisitableCommand) {
                Object retVal = this.invoker.invokeRemote((VisitableCommand)cacheCommand);
                result = this.returnValueForRemoteCall(cacheCommand) ? retVal : null;
            } else {
                result = cacheCommand.perform(null);
            }
        }
        catch (Throwable ex) {
            if (!(cacheCommand instanceof PutForExternalReadCommand)) {
                throw ex;
            }
            if (trace) {
                log.trace((Object)"Caught an exception, but since this is a putForExternalRead() call, suppressing the exception.  Exception is:", ex);
            }
            result = null;
        }
        return result;
    }

    private boolean returnValueForRemoteCall(ReplicableCommand cacheCommand) {
        return cacheCommand instanceof GravitateDataCommand || cacheCommand instanceof ClusteredGetCommand;
    }

    @Override
    public int getCommandId() {
        return this.isSingleCommand() ? 13 : 14;
    }

    public List<ReplicableCommand> getModifications() {
        return this.modifications;
    }

    public ReplicableCommand getSingleModification() {
        return this.singleModification;
    }

    @Override
    public Object[] getParameters() {
        if (this.isSingleCommand()) {
            return new Object[]{this.singleModification};
        }
        return new Object[]{this.modifications};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId == 13) {
            this.singleModification = (ReplicableCommand)args[0];
        } else {
            this.modifications = (List)args[0];
        }
    }

    public boolean isSingleCommand() {
        return this.singleModification != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicateCommand that = (ReplicateCommand)o;
        if (this.modifications != null ? !((Object)this.modifications).equals(that.modifications) : that.modifications != null) {
            return false;
        }
        return !(this.singleModification != null ? !this.singleModification.equals(that.singleModification) : that.singleModification != null);
    }

    public int hashCode() {
        int result = this.singleModification != null ? this.singleModification.hashCode() : 0;
        result = 31 * result + (this.modifications != null ? ((Object)this.modifications).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ReplicateCommand{cmds=" + (this.isSingleCommand() ? this.singleModification : this.modifications) + '}';
    }

    public ReplicateCommand copy() {
        ReplicateCommand clone = new ReplicateCommand();
        clone.invoker = this.invoker;
        clone.modifications = this.modifications == null ? null : new ArrayList<ReplicableCommand>(this.modifications);
        clone.singleModification = this.singleModification;
        return clone;
    }

    public boolean containsCommandType(Class<? extends ReplicableCommand> aClass) {
        if (this.isSingleCommand()) {
            return this.isCommandWithType(this.getSingleModification(), aClass);
        }
        for (ReplicableCommand command : this.getModifications()) {
            if (!this.isCommandWithType(command, aClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isCommandWithType(ReplicableCommand command, Class<? extends ReplicableCommand> aClass) {
        if (command.getClass().equals(aClass)) {
            return true;
        }
        if (command instanceof ReplicateCommand) {
            return ((ReplicateCommand)command).containsCommandType(aClass);
        }
        return false;
    }

    public boolean removeCommands(List<Class<? extends ReplicableCommand>> whereFrom) {
        boolean foundMods = false;
        List<ReplicableCommand> modifications = this.isSingleCommand() ? Collections.singletonList(this.singleModification) : this.modifications;
        for (ReplicableCommand command : modifications) {
            if (command instanceof ReplicateCommand) {
                foundMods |= ((ReplicateCommand)command).removeCommands(whereFrom);
                continue;
            }
            foundMods |= whereFrom.remove(command.getClass());
        }
        return foundMods;
    }
}

