/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.views.TemplateBean;
import org.exoplatform.ecm.webui.component.admin.views.UITemplateContainer;
import org.exoplatform.ecm.webui.component.admin.views.UITemplateForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIECMTemplateList.msg.confirm-delete"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={AddActionListener.class})})
public class UIECMTemplateList
extends UIGrid {
    private static String[] VIEW_BEAN_FIELD = new String[]{"name", "path", "baseVersion"};
    private static String[] VIEW_ACTION = new String[]{"EditInfo", "Delete"};
    public static String ST_ECMTempForm = "ECMTempForm";
    public static String ST_ECMTemp = "ECMTemplate";

    public UIECMTemplateList() throws Exception {
        this.getUIPageIterator().setId("UIECMTemplateGrid");
        this.configure("path", VIEW_BEAN_FIELD, VIEW_ACTION);
    }

    public String[] getActions() {
        return new String[]{"Add"};
    }

    public String getBaseVersion(Node node) throws Exception {
        if (!node.isNodeType("mix:versionable") || node.isNodeType(Utils.NT_FROZEN)) {
            return "";
        }
        return node.getBaseVersion().getName();
    }

    public void updateTempListGrid(int currentPage) throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        List nodes = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllTemplates("ecmExplorerTemplates", repository, SessionProviderFactory.createSessionProvider());
        ArrayList<TemplateBean> tempBeans = new ArrayList<TemplateBean>();
        for (Node node : nodes) {
            tempBeans.add(new TemplateBean(node.getName(), node.getPath(), this.getBaseVersion(node)));
        }
        Collections.sort(tempBeans, new ECMViewComparator());
        this.getUIPageIterator().setPageList((PageList)new ObjectPageList(tempBeans, 10));
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(currentPage - 1);
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public String getRepository() {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInfoActionListener
    extends EventListener<UIECMTemplateList> {
        public void execute(Event<UIECMTemplateList> event) throws Exception {
            UIECMTemplateList uiECMTemp = (UIECMTemplateList)((Object)event.getSource());
            String tempPath = event.getRequestContext().getRequestParameter("objectId");
            UITemplateContainer uiTempContainer = (UITemplateContainer)uiECMTemp.getParent();
            UIViewManager uiViewManager = (UIViewManager)uiECMTemp.getAncestorOfType(UIViewManager.class);
            uiTempContainer.removeChildById(ST_ECMTempForm + "Add");
            uiTempContainer.initPopup(ST_ECMTempForm, "Edit");
            UITemplateForm uiTempForm = (UITemplateForm)uiTempContainer.findComponentById(ST_ECMTempForm);
            uiTempForm.update(tempPath, null);
            uiViewManager.setRenderedChild(ST_ECMTemp);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTempContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIECMTemplateList> {
        public void execute(Event<UIECMTemplateList> event) throws Exception {
            UIECMTemplateList uiECMTemp = (UIECMTemplateList)((Object)event.getSource());
            String repository = ((UIECMAdminPortlet)uiECMTemp.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            ManageViewService vservice = (ManageViewService)uiECMTemp.getApplicationComponent(ManageViewService.class);
            UIViewManager uiViewManager = (UIViewManager)uiECMTemp.getAncestorOfType(UIViewManager.class);
            uiViewManager.setRenderedChild(ST_ECMTemp);
            String templatePath = event.getRequestContext().getRequestParameter("objectId");
            String templateName = templatePath.substring(templatePath.lastIndexOf("/") + 1);
            if (((ManageDriveService)uiECMTemp.getApplicationComponent(ManageDriveService.class)).isUsedView(templateName, repository)) {
                UIApplication app = (UIApplication)uiECMTemp.getAncestorOfType(UIApplication.class);
                Object[] args = new Object[]{templateName};
                app.addMessage(new ApplicationMessage("UIECMTemplateList.msg.template-in-use", args));
                return;
            }
            vservice.removeTemplate(templatePath, repository);
            uiECMTemp.updateTempListGrid(uiECMTemp.getUIPageIterator().getCurrentPage());
            UITemplateContainer uiTempContainer = (UITemplateContainer)uiECMTemp.getParent();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTempContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIECMTemplateList> {
        public void execute(Event<UIECMTemplateList> event) throws Exception {
            UIECMTemplateList uiECMTempList = (UIECMTemplateList)((Object)event.getSource());
            SessionProvider provider = SessionProviderFactory.createSessionProvider();
            Node ecmTemplateHome = ((ManageViewService)uiECMTempList.getApplicationComponent(ManageViewService.class)).getTemplateHome("ecmExplorerTemplates", uiECMTempList.getRepository(), provider);
            if (ecmTemplateHome == null) {
                UIApplication uiApp = (UIApplication)((UIECMTemplateList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIECMTemplateList.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UIViewManager uiViewManager = (UIViewManager)uiECMTempList.getAncestorOfType(UIViewManager.class);
            UITemplateContainer uiECMTempContainer = (UITemplateContainer)uiViewManager.getChildById(ST_ECMTemp);
            uiECMTempContainer.removeChildById(ST_ECMTempForm + "Edit");
            uiECMTempContainer.initPopup(ST_ECMTempForm, "Add");
            uiViewManager.setRenderedChild(ST_ECMTemp);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiECMTempContainer);
        }
    }

    public static class ECMViewComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((TemplateBean)o1).getName();
            String name2 = ((TemplateBean)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

