/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.navigation.TreeNode;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPortalNavigation
extends UIComponent {
    private boolean useAJAX = true;
    private boolean showUserNavigation = true;
    protected PageNode selectedNode_;
    protected Object selectedParent_;
    private TreeNode treeNode_;
    private String cssClassName = "";
    private String template;
    private static final String PORTAL_NAV = "portal";
    private static final String GROUP_NAV = "group";
    private static final String USER_NAV = "user";

    public String getTemplate() {
        return this.template != null ? this.template : super.getTemplate();
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public UIComponent getViewModeUIComponent() {
        return null;
    }

    public void setUseAjax(boolean bl) {
        this.useAJAX = bl;
    }

    public boolean isUseAjax() {
        return this.useAJAX;
    }

    public boolean isShowUserNavigation() {
        return this.showUserNavigation;
    }

    public void setShowUserNavigation(boolean showUserNavigation) {
        this.showUserNavigation = showUserNavigation;
    }

    public void setCssClassName(String cssClassName) {
        this.cssClassName = cssClassName;
    }

    public String getCssClassName() {
        return this.cssClassName;
    }

    public List<PageNavigation> getNavigations() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ArrayList<PageNavigation> result = new ArrayList<PageNavigation>();
        if (context.getRemoteUser() != null) {
            result.add(PageNavigationUtils.filter(this.getSelectedNavigation(), context.getRemoteUser()));
        } else {
            for (PageNavigation nav : Util.getUIPortalApplication().getNavigations()) {
                if (!this.showUserNavigation && nav.getOwnerType().equals(USER_NAV)) continue;
                result.add(PageNavigationUtils.filter(nav, null));
            }
        }
        return result;
    }

    public void loadTreeNodes() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.treeNode_ = new TreeNode(new PageNode(), new PageNavigation(), true);
        List<PageNavigation> listNavigations = Util.getUIPortalApplication().getNavigations();
        for (PageNavigation nav : this.rearrangeNavigations(listNavigations)) {
            if (!this.showUserNavigation && nav.getOwnerType().equals(USER_NAV)) continue;
            PageNavigation filterNav = PageNavigationUtils.filter(nav, context.getRemoteUser());
            this.treeNode_.setChildren(filterNav.getNodes(), filterNav);
        }
    }

    private List<PageNavigation> rearrangeNavigations(List<PageNavigation> listNavigation) {
        ArrayList<PageNavigation> returnNavs = new ArrayList<PageNavigation>();
        ArrayList<PageNavigation> portalNavs = new ArrayList<PageNavigation>();
        ArrayList<PageNavigation> groupNavs = new ArrayList<PageNavigation>();
        ArrayList<PageNavigation> userNavs = new ArrayList<PageNavigation>();
        for (PageNavigation nav : listNavigation) {
            String ownerType = nav.getOwnerType();
            if (PORTAL_NAV.equals(ownerType)) {
                portalNavs.add(nav);
                continue;
            }
            if (GROUP_NAV.equals(ownerType)) {
                groupNavs.add(nav);
                continue;
            }
            if (!USER_NAV.equals(ownerType)) continue;
            userNavs.add(nav);
        }
        returnNavs.addAll(portalNavs);
        returnNavs.addAll(groupNavs);
        returnNavs.addAll(userNavs);
        return returnNavs;
    }

    public TreeNode getTreeNodes() {
        return this.treeNode_;
    }

    public PageNavigation getSelectedNavigation() throws Exception {
        PageNavigation nav = Util.getUIPortal().getSelectedNavigation();
        if (nav != null) {
            return nav;
        }
        if (Util.getUIPortal().getNavigations().size() < 1) {
            return null;
        }
        return Util.getUIPortal().getNavigations().get(0);
    }

    public Object getSelectedParent() {
        return this.selectedParent_;
    }

    public PageNode getSelectedPageNode() throws Exception {
        if (this.selectedNode_ != null) {
            return this.selectedNode_;
        }
        this.selectedNode_ = Util.getUIPortal().getSelectedNode();
        return this.selectedNode_;
    }

    public boolean isSelectedNode(PageNode node) {
        if (this.selectedNode_ != null && node.getUri().equals(this.selectedNode_.getUri())) {
            return true;
        }
        if (this.selectedParent_ == null || this.selectedParent_ instanceof PageNavigation) {
            return false;
        }
        PageNode pageNode = (PageNode)this.selectedParent_;
        return node.getUri().equals(pageNode.getUri());
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        if (uiPortal.getSelectedNode() != null && uiPortal.getSelectedNode() != this.selectedNode_) {
            this.setSelectedPageNode(uiPortal.getSelectedNode());
        }
        super.processRender(context);
    }

    private void setSelectedPageNode(PageNode selectedNode) throws Exception {
        this.selectedNode_ = selectedNode;
        this.selectedParent_ = null;
        String seletctUri = selectedNode.getUri();
        int index = seletctUri.lastIndexOf("/");
        String parentUri = null;
        if (index > 0) {
            parentUri = seletctUri.substring(0, seletctUri.lastIndexOf("/"));
        }
        List<PageNavigation> pageNavs = this.getNavigations();
        for (PageNavigation pageNav : pageNavs) {
            if (PageNavigationUtils.searchPageNodeByUri(pageNav, selectedNode.getUri()) == null) continue;
            if (parentUri == null || parentUri.length() < 1) {
                this.selectedParent_ = pageNav;
                break;
            }
            this.selectedParent_ = PageNavigationUtils.searchPageNodeByUri(pageNav, parentUri);
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpandAllNodeActionListener
    extends EventListener<UIPortalNavigation> {
        public void execute(Event<UIPortalNavigation> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalNavigation uiNavigation = (UIPortalNavigation)((Object)event.getSource());
            uiNavigation.loadTreeNodes();
            TreeNode treeNode = uiNavigation.getTreeNodes();
            this.expandAllNode(treeNode);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNavigation);
        }

        public void expandAllNode(TreeNode treeNode) throws Exception {
            if (treeNode.getChildren().size() > 0) {
                for (TreeNode child : treeNode.getChildren()) {
                    PageNode expandNode = child.getNode();
                    PageNavigation selectNav = child.getNavigation();
                    if (expandNode.getChildren().size() > 0) {
                        child.setChildren(expandNode.getChildren(), selectNav);
                    }
                    this.expandAllNode(child);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollapseAllNodeActionListener
    extends EventListener<UIPortalNavigation> {
        public void execute(Event<UIPortalNavigation> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalNavigation uiNavigation = (UIPortalNavigation)((Object)event.getSource());
            uiNavigation.loadTreeNodes();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNavigation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollapseNodeActionListener
    extends EventListener<UIPortalNavigation> {
        public void execute(Event<UIPortalNavigation> event) throws Exception {
            UIPortalNavigation uiNavigation = (UIPortalNavigation)((Object)event.getSource());
            TreeNode treeNode = uiNavigation.getTreeNodes();
            UIPortal uiPortal = Util.getUIPortal();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            int index = uri.lastIndexOf("::");
            String id = uri.substring(index + 2);
            PageNavigation selectNav = null;
            String navId = uri.substring(0, index);
            selectNav = uiPortal.getSelectedNavigation();
            PageNode expandNode = PageNavigationUtils.searchPageNodeByUri(selectNav, id);
            TreeNode expandTree = null;
            if (treeNode.getChildren() != null) {
                expandTree = treeNode.getChildByPath(uri, treeNode);
            }
            if (expandTree != null) {
                expandTree.setExpanded(false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNavigation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpandNodeActionListener
    extends EventListener<UIPortalNavigation> {
        public void execute(Event<UIPortalNavigation> event) throws Exception {
            UIPortalNavigation uiNavigation = (UIPortalNavigation)((Object)event.getSource());
            TreeNode treeNode = uiNavigation.getTreeNodes();
            List<PageNavigation> all_Navigations = Util.getUIPortalApplication().getNavigations();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            int index = uri.lastIndexOf("::");
            String id = uri.substring(index + 2);
            PageNavigation selectNav = null;
            String navId = uri.substring(0, index);
            selectNav = PageNavigationUtils.findNavigationByID(all_Navigations, Integer.parseInt(navId));
            if (selectNav == null) {
                return;
            }
            PageNode expandNode = PageNavigationUtils.searchPageNodeByUri(selectNav, id);
            TreeNode expandTree = null;
            if (treeNode.getChildren() != null) {
                expandTree = treeNode.getChildByPath(uri, treeNode);
            }
            if (expandTree != null) {
                expandTree.setChildren(expandNode.getChildren(), selectNav);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNavigation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectNodeActionListener
    extends EventListener<UIPortalNavigation> {
        public void execute(Event<UIPortalNavigation> event) throws Exception {
            PageNode selectNode;
            UIPortalNavigation uiNavigation = (UIPortalNavigation)((Object)event.getSource());
            UIPortal uiPortal = Util.getUIPortal();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            int index = uri.lastIndexOf("::");
            String id = uri.substring(index + 2);
            PageNavigation selectNav = null;
            if (index <= 0) {
                selectNav = uiPortal.getSelectedNavigation();
            } else {
                String navId = uri.substring(0, index);
                selectNav = uiPortal.getSelectedNavigation();
            }
            uiNavigation.selectedNode_ = selectNode = PageNavigationUtils.searchPageNodeByUri(selectNav, id);
            String parentUri = null;
            index = uri.lastIndexOf("/");
            if (index > 0) {
                parentUri = uri.substring(0, index);
            }
            uiNavigation.selectedParent_ = parentUri == null || parentUri.length() < 1 ? selectNav : PageNavigationUtils.searchPageNodeByUri(selectNav, parentUri);
            PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", uri);
            uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
        }
    }
}

