/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.security.EncryptionDictionary;
import org.icepdf.core.util.Utils;

class StandardEncryption {
    private static final Logger logger = Logger.getLogger(StandardEncryption.class.toString());
    private static final byte[] PADDING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private EncryptionDictionary encryptionDictionary;
    private byte[] encryptionKey;
    private Reference objectReference;
    private byte[] rc4Key = null;
    private String userPassword = "";
    private String ownerPassword = "";

    public StandardEncryption(EncryptionDictionary encryptionDictionary) {
        this.encryptionDictionary = encryptionDictionary;
    }

    public byte[] generalEncryptionAlgorithm(Reference objectReference, byte[] encryptionKey, byte[] inputData) {
        if (objectReference == null || encryptionKey == null || inputData == null) {
            // empty if block
        }
        if (this.rc4Key == null || this.encryptionKey != encryptionKey || this.objectReference != objectReference) {
            this.objectReference = objectReference;
            byte[] step3Bytes = this.resetObjectReference(objectReference);
            int n = encryptionKey.length;
            this.rc4Key = new byte[Math.min(n + 5, 16)];
            System.arraycopy(step3Bytes, 0, this.rc4Key, 0, this.rc4Key.length);
        }
        byte[] finalData = null;
        try {
            SecretKeySpec key = new SecretKeySpec(this.rc4Key, "RC4");
            Cipher rc4 = Cipher.getInstance("RC4");
            rc4.init(2, key);
            finalData = rc4.doFinal(inputData);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
        }
        catch (IllegalBlockSizeException ex) {
            logger.log(Level.FINE, "IllegalBlockSizeException.", ex);
        }
        catch (BadPaddingException ex) {
            logger.log(Level.FINE, "BadPaddingException.", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.FINE, "NoSuchPaddingException.", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.FINE, "InvalidKeyException.", ex);
        }
        return finalData;
    }

    public InputStream generalEncryptionInputStream(Reference objectReference, byte[] encryptionKey, InputStream input) {
        if (objectReference == null || encryptionKey == null || input == null) {
            return null;
        }
        if (this.rc4Key == null || this.encryptionKey != encryptionKey || this.objectReference != objectReference) {
            this.objectReference = objectReference;
            byte[] step3Bytes = this.resetObjectReference(objectReference);
            int n = encryptionKey.length;
            this.rc4Key = new byte[Math.min(n + 5, 16)];
            System.arraycopy(step3Bytes, 0, this.rc4Key, 0, this.rc4Key.length);
        }
        try {
            SecretKeySpec key = new SecretKeySpec(this.rc4Key, "RC4");
            Cipher rc4 = Cipher.getInstance("RC4");
            rc4.init(2, key);
            CipherInputStream cin = new CipherInputStream(input, rc4);
            return cin;
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.FINE, "NoSuchPaddingException.", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.FINE, "InvalidKeyException.", ex);
        }
        return null;
    }

    public byte[] resetObjectReference(Reference objectReference) {
        int objectNumber = objectReference.getObjectNumber();
        int generationNumber = objectReference.getGenerationNumber();
        int n = this.encryptionKey.length;
        byte[] step2Bytes = new byte[n + 5];
        System.arraycopy(this.encryptionKey, 0, step2Bytes, 0, n);
        step2Bytes[n] = (byte)(objectNumber & 0xFF);
        step2Bytes[n + 1] = (byte)(objectNumber >> 8 & 0xFF);
        step2Bytes[n + 2] = (byte)(objectNumber >> 16 & 0xFF);
        step2Bytes[n + 3] = (byte)(generationNumber & 0xFF);
        step2Bytes[n + 4] = (byte)(generationNumber >> 8 & 0xFF);
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException builtin) {
            // empty catch block
        }
        md5.update(step2Bytes);
        return md5.digest();
    }

    public byte[] encryptionKeyAlgorithm(String password, int keyLength) {
        byte[] paddedPassword = StandardEncryption.padPassword(password);
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
        }
        md5.update(paddedPassword);
        byte[] bigO = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigO());
        md5.update(bigO);
        int i = 0;
        int p = this.encryptionDictionary.getPermissions();
        while (i < 4) {
            md5.update((byte)(p & 0xFF));
            ++i;
            p >>= 8;
        }
        String firstFileID = ((StringObject)this.encryptionDictionary.getFileID().elementAt(0)).getLiteralString();
        byte[] fileID = Utils.convertByteCharSequenceToByteArray(firstFileID);
        paddedPassword = md5.digest(fileID);
        if (this.encryptionDictionary.getRevisionNumber() == 3) {
            for (int i2 = 0; i2 < 50; ++i2) {
                paddedPassword = md5.digest(paddedPassword);
            }
        }
        byte[] out = null;
        int n = 5;
        if (this.encryptionDictionary.getRevisionNumber() == 2) {
            out = new byte[n];
        } else if (this.encryptionDictionary.getRevisionNumber() == 3) {
            n = keyLength / 8;
            out = new byte[n];
        }
        System.arraycopy(paddedPassword, 0, out, 0, n);
        this.encryptionKey = out;
        return out;
    }

    protected static byte[] padPassword(String password) {
        byte[] paddedPassword = new byte[32];
        if (password == null || "".equals(password)) {
            return PADDING;
        }
        int passwordLength = Math.min(password.length(), 32);
        byte[] bytePassword = Utils.convertByteCharSequenceToByteArray(password);
        System.arraycopy(bytePassword, 0, paddedPassword, 0, passwordLength);
        System.arraycopy(PADDING, 0, paddedPassword, passwordLength, 32 - passwordLength);
        return paddedPassword;
    }

    public byte[] calculateOwnerPassword(String ownerPassword, String userPassword, boolean isAuthentication) {
        if ("".equals(ownerPassword) && !"".equals(userPassword)) {
            ownerPassword = userPassword;
        }
        byte[] paddedOwnerPassword = StandardEncryption.padPassword(ownerPassword);
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.FINE, "Could not fint MD5 Digest", e);
        }
        paddedOwnerPassword = md5.digest(paddedOwnerPassword);
        if (this.encryptionDictionary.getRevisionNumber() == 3) {
            for (int i = 0; i < 50; ++i) {
                paddedOwnerPassword = md5.digest(paddedOwnerPassword);
            }
        }
        int dataSize = 5;
        if (this.encryptionDictionary.getRevisionNumber() == 3) {
            dataSize = this.encryptionDictionary.getKeyLength() / 8;
        }
        byte[] encryptionKey = new byte[dataSize];
        System.arraycopy(paddedOwnerPassword, 0, encryptionKey, 0, dataSize);
        if (isAuthentication) {
            return encryptionKey;
        }
        byte[] paddedUserPassword = StandardEncryption.padPassword(userPassword);
        byte[] finalData = null;
        try {
            SecretKeySpec key = new SecretKeySpec(encryptionKey, "RC4");
            Cipher rc4 = Cipher.getInstance("RC4");
            rc4.init(1, key);
            finalData = rc4.update(paddedUserPassword);
            if (this.encryptionDictionary.getRevisionNumber() == 3) {
                byte[] indexedKey = new byte[encryptionKey.length];
                for (int i = 1; i <= 19; ++i) {
                    for (int j = 0; j < encryptionKey.length; ++j) {
                        indexedKey[j] = (byte)(encryptionKey[j] ^ i);
                    }
                    key = new SecretKeySpec(indexedKey, "RC4");
                    rc4.init(1, key);
                    finalData = rc4.update(finalData);
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.FINE, "NoSuchPaddingException.", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.FINE, "InvalidKeyException.", ex);
        }
        return finalData;
    }

    public byte[] calculateUserPassword(String userPassword) {
        byte[] encryptionKey = this.encryptionKeyAlgorithm(userPassword, this.encryptionDictionary.getKeyLength());
        if (this.encryptionDictionary.getRevisionNumber() == 2) {
            byte[] paddedUserPassword = (byte[])PADDING.clone();
            byte[] finalData = null;
            try {
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "RC4");
                Cipher rc4 = Cipher.getInstance("RC4");
                rc4.init(1, key);
                finalData = rc4.doFinal(paddedUserPassword);
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            catch (IllegalBlockSizeException ex) {
                logger.log(Level.FINE, "IllegalBlockSizeException.", ex);
            }
            catch (BadPaddingException ex) {
                logger.log(Level.FINE, "BadPaddingException.", ex);
            }
            catch (NoSuchPaddingException ex) {
                logger.log(Level.FINE, "NoSuchPaddingException.", ex);
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.FINE, "InvalidKeyException.", ex);
            }
            return finalData;
        }
        if (this.encryptionDictionary.getRevisionNumber() == 3) {
            byte[] paddedUserPassword = (byte[])PADDING.clone();
            MessageDigest md5 = null;
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.FINE, "MD5 digester could not be found", e);
            }
            md5.update(paddedUserPassword);
            String firstFileID = ((StringObject)this.encryptionDictionary.getFileID().elementAt(0)).getLiteralString();
            byte[] fileID = Utils.convertByteCharSequenceToByteArray(firstFileID);
            byte[] encryptData = md5.digest(fileID);
            try {
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "RC4");
                Cipher rc4 = Cipher.getInstance("RC4");
                rc4.init(1, key);
                encryptData = rc4.update(encryptData);
                byte[] indexedKey = new byte[encryptionKey.length];
                for (int i = 1; i <= 19; ++i) {
                    for (int j = 0; j < encryptionKey.length; ++j) {
                        indexedKey[j] = (byte)(encryptionKey[j] ^ (byte)i);
                    }
                    key = new SecretKeySpec(indexedKey, "RC4");
                    rc4.init(1, key);
                    encryptData = rc4.update(encryptData);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            catch (NoSuchPaddingException ex) {
                logger.log(Level.FINE, "NoSuchPaddingException.", ex);
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.FINE, "InvalidKeyException.", ex);
            }
            byte[] finalData = new byte[32];
            System.arraycopy(encryptData, 0, finalData, 0, 16);
            System.arraycopy(PADDING, 0, finalData, 16, 16);
            return finalData;
        }
        return null;
    }

    public boolean authenticateUserPassword(String userPassword) {
        byte[] trunkUValue;
        byte[] tmpUValue = this.calculateUserPassword(userPassword);
        byte[] bigU = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigU());
        if (this.encryptionDictionary.getRevisionNumber() == 2) {
            trunkUValue = new byte[32];
            System.arraycopy(tmpUValue, 0, trunkUValue, 0, trunkUValue.length);
        } else {
            trunkUValue = new byte[16];
            System.arraycopy(tmpUValue, 0, trunkUValue, 0, trunkUValue.length);
        }
        boolean found = true;
        for (int i = 0; i < trunkUValue.length; ++i) {
            if (trunkUValue[i] == bigU[i]) continue;
            found = false;
            break;
        }
        return found;
    }

    public boolean authenticateOwnerPassword(String ownerPassword) {
        byte[] encryptionKey = this.calculateOwnerPassword(ownerPassword, "", true);
        byte[] decryptedO = null;
        try {
            byte[] bigO = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigO());
            if (this.encryptionDictionary.getRevisionNumber() == 2) {
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "RC4");
                Cipher rc4 = Cipher.getInstance("RC4");
                rc4.init(2, key);
                decryptedO = rc4.doFinal(bigO);
            } else {
                byte[] indexedKey = new byte[encryptionKey.length];
                decryptedO = bigO;
                for (int i = 19; i >= 0; --i) {
                    for (int j = 0; j < indexedKey.length; ++j) {
                        indexedKey[j] = (byte)(encryptionKey[j] ^ (byte)i);
                    }
                    SecretKeySpec key = new SecretKeySpec(indexedKey, "RC4");
                    Cipher rc4 = Cipher.getInstance("RC4");
                    rc4.init(1, key);
                    decryptedO = rc4.update(decryptedO);
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
        }
        catch (IllegalBlockSizeException ex) {
            logger.log(Level.FINE, "IllegalBlockSizeException.", ex);
        }
        catch (BadPaddingException ex) {
            logger.log(Level.FINE, "BadPaddingException.", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.FINE, "NoSuchPaddingException.", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.FINE, "InvalidKeyException.", ex);
        }
        String tmpUserPassword = Utils.convertByteArrayToByteString(decryptedO);
        boolean isValid = this.authenticateUserPassword(tmpUserPassword);
        if (isValid) {
            this.userPassword = tmpUserPassword;
            this.ownerPassword = ownerPassword;
        }
        return isValid;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }
}

