/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrashServiceImpl
implements TrashService {
    public static final String EXO_TOTAL = "exo:total".intern();
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String TAXONOMY_LINK = "exo:taxonomyLink";
    public static final String UUID = "exo:uuid";
    public static final String SYMLINK = "exo:symlink";
    private RepositoryService repositoryService;
    private LinkManager linkManager;

    public TrashServiceImpl(RepositoryService repositoryService, LinkManager linkManager) throws Exception {
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
    }

    @Override
    public void moveToTrash(Node node, String trashPath, String trashWorkspace, String repository, SessionProvider sessionProvider) throws Exception {
        this.moveToTrash(node, trashPath, trashWorkspace, repository, sessionProvider, 0);
    }

    public void moveToTrash(Node node, String trashPath, String trashWorkspace, String repository, SessionProvider sessionProvider, int deep) throws Exception {
        String nodeUUID;
        String nodeName = node.getName();
        Session nodeSession = node.getSession();
        String nodeWorkspaceName = nodeSession.getWorkspace().getName();
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        TaxonomyService taxonomyService = (TaxonomyService)myContainer.getComponentInstanceOfType(TaxonomyService.class);
        List<Node> categories = taxonomyService.getAllCategories(node);
        String string = nodeUUID = node.isNodeType(MIX_REFERENCEABLE) ? node.getUUID() : null;
        if (node.isNodeType(SYMLINK)) {
            nodeUUID = null;
        }
        if (!node.isNodeType("exo:restoreLocation")) {
            node.addMixin("exo:restoreLocation");
            node.setProperty("exo:restorePath", this.fixRestorePath(node.getPath()));
            node.setProperty("exo:restoreWorkspace", nodeWorkspaceName);
            nodeSession.save();
            ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
            Session trashSession = sessionProvider.getSession(trashWorkspace, manageableRepository);
            String actualTrashPath = trashPath + (trashPath.endsWith("/") ? "" : "/") + this.fixRestorePath(nodeName);
            if (trashSession.getWorkspace().getName().equals(nodeSession.getWorkspace().getName())) {
                trashSession.getWorkspace().move(node.getPath(), actualTrashPath);
            } else {
                trashSession.getWorkspace().clone(nodeWorkspaceName, node.getPath(), actualTrashPath, true);
                if (node.isNodeType(MIX_REFERENCEABLE)) {
                    Node clonedNode = trashSession.getNodeByUUID(node.getUUID());
                    NewFolksonomyService newFolksonomyService = (NewFolksonomyService)myContainer.getComponentInstanceOfType(NewFolksonomyService.class);
                    String tagWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
                    List<Node> tags = newFolksonomyService.getLinkedTagsOfDocument(node, repository, tagWorkspace);
                    for (Node tag : tags) {
                        newFolksonomyService.removeTagOfDocument(tag.getPath(), node, repository, tagWorkspace);
                        this.linkManager.createLink(tag, clonedNode);
                        long total = tag.hasProperty(EXO_TOTAL) ? tag.getProperty(EXO_TOTAL).getLong() : 0L;
                        tag.setProperty(EXO_TOTAL, total + 1L);
                        tag.getSession().save();
                    }
                }
                node.remove();
            }
            nodeSession.save();
            trashSession.save();
            if (deep == 0 && nodeUUID != null) {
                for (Node category : categories) {
                    NodeIterator iter = category.getNodes();
                    while (iter.hasNext()) {
                        Node categoryChild = iter.nextNode();
                        if (!categoryChild.isNodeType(TAXONOMY_LINK) || !categoryChild.hasProperty(UUID) || !nodeUUID.equals(categoryChild.getProperty(UUID).getString())) continue;
                        this.moveToTrash(categoryChild, trashPath, trashWorkspace, repository, sessionProvider, deep + 1);
                    }
                }
            }
            trashSession.save();
            trashSession.logout();
        }
        nodeSession.save();
        if (deep == 0) {
            nodeSession.logout();
        }
    }

    @Override
    public void restoreFromTrash(Node trashHomeNode, String trashNodePath, String repository, SessionProvider sessionProvider) throws Exception {
        this.restoreFromTrash(trashHomeNode, trashNodePath, repository, sessionProvider, 0);
    }

    private void restoreFromTrash(Node trashHomeNode, String trashNodePath, String repository, SessionProvider sessionProvider, int deep) throws Exception {
        Node trashChild;
        NodeIterator iter;
        String nodeUUID;
        Session trashNodeSession = trashHomeNode.getSession();
        Node trashNode = (Node)trashNodeSession.getItem(trashNodePath);
        String trashWorkspace = trashNodeSession.getWorkspace().getName();
        String restoreWorkspace = trashNode.getProperty("exo:restoreWorkspace").getString();
        String restorePath = trashNode.getProperty("exo:restorePath").getString();
        String string = nodeUUID = trashNode.isNodeType(MIX_REFERENCEABLE) ? trashNode.getUUID() : null;
        if (trashNode.isNodeType(SYMLINK)) {
            nodeUUID = null;
        }
        String taxonomyLinkUUID = trashNode.isNodeType(TAXONOMY_LINK) ? trashNode.getProperty(UUID).getString() : null;
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        Session restoreSession = sessionProvider.getSession(restoreWorkspace, manageableRepository);
        if (restoreWorkspace.equals(trashWorkspace)) {
            trashNodeSession.getWorkspace().move(trashNodePath, restorePath);
        } else {
            restoreSession.getWorkspace().clone(trashWorkspace, trashNodePath, restorePath, true);
            if (trashNode.isNodeType(MIX_REFERENCEABLE)) {
                Node restoredNode = restoreSession.getNodeByUUID(trashNode.getUUID());
                ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
                NewFolksonomyService newFolksonomyService = (NewFolksonomyService)myContainer.getComponentInstanceOfType(NewFolksonomyService.class);
                String tagWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
                List<Node> tags = newFolksonomyService.getLinkedTagsOfDocument(trashNode, repository, tagWorkspace);
                for (Node tag : tags) {
                    newFolksonomyService.removeTagOfDocument(tag.getPath(), trashNode, repository, tagWorkspace);
                    this.linkManager.createLink(tag, restoredNode);
                    long total = tag.hasProperty(EXO_TOTAL) ? tag.getProperty(EXO_TOTAL).getLong() : 0L;
                    tag.setProperty(EXO_TOTAL, total + 1L);
                    tag.getSession().save();
                }
            }
            trashNodeSession.getItem(trashNodePath).remove();
        }
        this.removeMixinEXO_RESTORE_LOCATION(restoreSession, restorePath);
        trashNodeSession.save();
        restoreSession.save();
        if (deep == 0 && nodeUUID != null) {
            boolean found;
            block1: do {
                found = false;
                iter = trashHomeNode.getNodes();
                while (iter.hasNext()) {
                    trashChild = iter.nextNode();
                    if (!trashChild.isNodeType(TAXONOMY_LINK) || !trashChild.hasProperty(UUID) || !nodeUUID.equals(trashChild.getProperty(UUID).getString())) continue;
                    this.restoreFromTrash(trashHomeNode, trashChild.getPath(), repository, sessionProvider, deep + 1);
                    found = true;
                    continue block1;
                }
            } while (found);
        }
        trashNodeSession.save();
        restoreSession.save();
        if (deep == 0 && taxonomyLinkUUID != null) {
            boolean found;
            block3: do {
                found = false;
                iter = trashHomeNode.getNodes();
                while (iter.hasNext()) {
                    trashChild = iter.nextNode();
                    if (!trashChild.isNodeType(MIX_REFERENCEABLE) || !taxonomyLinkUUID.equals(trashChild.getUUID())) continue;
                    this.restoreFromTrash(trashHomeNode, trashChild.getPath(), repository, sessionProvider, deep + 1);
                    found = true;
                    continue block3;
                }
            } while (found);
        }
        trashNodeSession.save();
        restoreSession.save();
        if (deep == 0) {
            trashNodeSession.logout();
        }
        if (!restoreWorkspace.equals(trashWorkspace)) {
            restoreSession.logout();
        }
    }

    @Override
    public List<Node> getAllNodeInTrash(String trashWorkspace, String repository, SessionProvider sessionProvider) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM nt:base WHERE exo:restorePath IS NOT NULL");
        return this.selectNodesByQuery(trashWorkspace, repository, sessionProvider, query.toString(), "sql");
    }

    @Override
    public List<Node> getAllNodeInTrashByUser(String trashWorkspace, String repository, SessionProvider sessionProvider, String userName) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM nt:base WHERE exo:restorePath IS NOT NULL AND exo:lastModifier='").append(userName).append("'");
        return this.selectNodesByQuery(trashWorkspace, repository, sessionProvider, query.toString(), "sql");
    }

    @Override
    public void removeRelations(Node node, SessionProvider sessionProvider, String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        String[] workspaces = manageableRepository.getWorkspaceNames();
        String queryString = "SELECT * FROM exo:relationable WHERE exo:relation IS NOT NULL";
        boolean error = false;
        for (String ws : workspaces) {
            Session session = sessionProvider.getSession(ws, manageableRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                try {
                    iter.nextNode().removeMixin("exo:relationable");
                    session.save();
                }
                catch (Exception e) {
                    error = true;
                }
            }
        }
        if (error) {
            throw new Exception("Can't remove exo:relationable of all related nodes");
        }
    }

    private List<Node> selectNodesByQuery(String trashWorkspace, String repository, SessionProvider sessionProvider, String queryString, String language) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        Session session = sessionProvider.getSession(trashWorkspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString, language);
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        while (iter.hasNext()) {
            ret.add(iter.nextNode());
        }
        return ret;
    }

    private String fixRestorePath(String path) {
        int leftBracket = path.lastIndexOf(91);
        int rightBracket = path.lastIndexOf(93);
        if (leftBracket == -1 || rightBracket == -1 || leftBracket >= rightBracket) {
            return path;
        }
        try {
            Integer.parseInt(path.substring(leftBracket + 1, rightBracket));
        }
        catch (Exception ex) {
            return path;
        }
        return path.substring(0, leftBracket);
    }

    private void removeMixinEXO_RESTORE_LOCATION(Session session, String restorePath) throws Exception {
        Node sameNameNode = (Node)session.getItem(restorePath);
        Node parent = sameNameNode.getParent();
        String name = sameNameNode.getName();
        NodeIterator nodeIter = parent.getNodes(name);
        while (nodeIter.hasNext()) {
            Node node = nodeIter.nextNode();
            if (!node.isNodeType("exo:restoreLocation")) continue;
            node.removeMixin("exo:restoreLocation");
        }
    }
}

