/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkUtils {
    private static final String EXO_SYMLINK = "exo:symlink";

    public static String evaluatePath(String path) {
        int index;
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        path = LinkUtils.cleanPath(path);
        while ((index = path.indexOf("/..")) != -1) {
            if (index == 0) {
                path = path.substring(3);
                continue;
            }
            path = LinkUtils.createPath(LinkUtils.getParentPath(path.substring(0, index)), path.substring(index + 3));
        }
        while ((index = path.indexOf("/.")) != -1) {
            if (index == 0) {
                path = path.substring(2);
                continue;
            }
            path = LinkUtils.createPath(path.substring(0, index), path.substring(index + 2));
        }
        return path.length() == 0 ? "/" : path;
    }

    public static String getItemName(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        path = LinkUtils.cleanPath(path);
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    public static String createPath(String parentPath, String relativePath) {
        if (!parentPath.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + parentPath + "' must be an absolute path");
        }
        parentPath = LinkUtils.cleanPath(parentPath);
        if ((relativePath = LinkUtils.cleanPath(relativePath)).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        StringBuilder path = new StringBuilder(128);
        path.append(parentPath);
        if (relativePath.length() > 0) {
            if (!parentPath.equals("/")) {
                path.append('/');
            }
            path.append(relativePath);
        }
        return path.toString();
    }

    public static int getDepth(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        if ((path = LinkUtils.cleanPath(path)).equals("/")) {
            return 0;
        }
        return path.substring(1).split("/").length;
    }

    public static String getAncestorPath(String path, int depth) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        path = LinkUtils.cleanPath(path);
        if (depth == 0) {
            return "/";
        }
        String[] subpath = path.substring(1).split("/");
        StringBuilder result = new StringBuilder(128);
        for (int i = 0; i < depth; ++i) {
            result.append('/');
            result.append(subpath[i]);
        }
        return result.toString();
    }

    public static String getParentPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        if ((path = LinkUtils.cleanPath(path)).equals("/")) {
            return "/";
        }
        int index = path.lastIndexOf(47);
        if (index == 0) {
            return "/";
        }
        return path.substring(0, index);
    }

    public static NodeFinder getNodeFinder() {
        ExoContainer context = ExoContainerContext.getCurrentContainer();
        return (NodeFinder)context.getComponentInstance(NodeFinder.class);
    }

    public static LinkManager getLinkManager() {
        ExoContainer context = ExoContainerContext.getCurrentContainer();
        return (LinkManager)context.getComponentInstance(LinkManager.class);
    }

    public static String getExistPath(Node node, String path) throws RepositoryException {
        int deep = LinkUtils.getDepth(path);
        if (deep == 0) {
            path = LinkUtils.getAncestorPath(path, 0);
        } else {
            Session session = node.getSession();
            for (int i = deep; i > 0 && !session.itemExists(path); --i) {
                path = LinkUtils.getParentPath(path);
            }
        }
        return path;
    }

    private static String cleanPath(String path) {
        if ((path = path.replaceAll("/+", "/")).length() > 1 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static List<Node> getAllSymlinks(Node targetNode, String repoName) throws Exception {
        ArrayList<Node> result = new ArrayList<Node>();
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)myContainer.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository repository = repositoryService.getRepository(repoName);
        String[] workspaces = repository.getWorkspaceNames();
        String systemWS = repository.getConfiguration().getSystemWorkspaceName();
        String queryString = "SELECT * FROM " + EXO_SYMLINK + " WHERE exo:uuid='" + targetNode.getUUID() + "'" + " AND exo:workspace='" + targetNode.getSession().getWorkspace().getName() + "'";
        for (String workspace : workspaces) {
            SessionProvider sessionProvider = workspace.equals(systemWS) ? SessionProviderFactory.createSystemProvider() : SessionProviderFactory.createSessionProvider();
            Session session = sessionProvider.getSession(workspace, repository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                result.add(iter.nextNode());
            }
        }
        return result;
    }
}

