/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.util;

import java.net.URL;
import org.exoplatform.services.common.ServiceConfig;

@ServiceConfig(type=ServiceConfig.ServiceType.SINGLE_FINAL)
public class URLCreator {
    public synchronized String createURL(URL url, String link) {
        link = this.createURL(url.getFile(), link);
        return this.createURL(url.getHost(), url.getPort(), url.getProtocol(), link);
    }

    public synchronized String createURL(String host, int port, String protocol, String link) {
        if (link.startsWith("http") || link.startsWith("https") || link.startsWith("ftp")) {
            return link;
        }
        String url = protocol + "://" + host;
        if (port >= 0) {
            url = url + ":" + String.valueOf(port);
        }
        url = url + link;
        return url;
    }

    public synchronized String createURL(String address, String link) {
        if (link.startsWith("http") || link.startsWith("https") || link.startsWith("ftp") || link.startsWith("/")) {
            return link;
        }
        String file = "";
        try {
            file = new URL(address).getFile();
        }
        catch (Exception exp) {
            file = address;
        }
        if (file.trim().length() < 1) {
            return '/' + link;
        }
        String value = file.endsWith("/") ? file + link : (file.endsWith("?") || link.startsWith("?") ? file + link : file.trim().substring(0, file.lastIndexOf("/") + 1) + link);
        if ((value = value.trim()).charAt(0) != '/') {
            value = '/' + value;
        }
        return value;
    }
}

