/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.api.workspace;

import java.util.HashSet;
import java.util.Set;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.api.workspace.link.PageLink;
import org.gatein.mop.api.workspace.link.URLLink;
import org.gatein.mop.api.workspace.ui.UIBody;
import org.gatein.mop.api.workspace.ui.UIComponent;
import org.gatein.mop.api.workspace.ui.UIContainer;
import org.gatein.mop.api.workspace.ui.UIWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectType<O extends WorkspaceObject> {
    public static final ObjectType<WorkspaceObject> ANY = new ObjectType<WorkspaceObject>(WorkspaceObject.class, new ObjectType[0]);
    public static final ObjectType<Workspace> WORKSPACE = new ObjectType<Workspace>(Workspace.class, new ObjectType[0]);
    public static final ObjectType<Site> SITE = new ObjectType<Site>(Site.class, new ObjectType[0]);
    public static final ObjectType<Site> PORTAL_SITE = new ObjectType<Site>(Site.class, SITE);
    public static final ObjectType<Site> GROUP_SITE = new ObjectType<Site>(Site.class, SITE);
    public static final ObjectType<Site> USER_SITE = new ObjectType<Site>(Site.class, SITE);
    public static final ObjectType<Page> PAGE = new ObjectType<Page>(Page.class, new ObjectType[0]);
    public static final ObjectType<Navigation> NAVIGATION = new ObjectType<Navigation>(Navigation.class, new ObjectType[0]);
    public static final ObjectType<UIComponent> COMPONENT = new ObjectType<UIComponent>(UIComponent.class, new ObjectType[0]);
    public static final ObjectType<UIBody> BODY = new ObjectType<UIBody>(UIBody.class, COMPONENT);
    public static final ObjectType<UIContainer> CONTAINER = new ObjectType<UIContainer>(UIContainer.class, COMPONENT);
    public static final ObjectType<UIWindow> WINDOW = new ObjectType<UIWindow>(UIWindow.class, COMPONENT);
    public static final ObjectType<PageLink> PAGE_LINK = new ObjectType<PageLink>(PageLink.class, new ObjectType[0]);
    public static final ObjectType<URLLink> URL_LINK = new ObjectType<URLLink>(URLLink.class, new ObjectType[0]);
    private final Class<O> javaType;
    private final Set<ObjectType<?>> superTypes;

    private ObjectType(Class<O> javaType, ObjectType<?> ... superTypes) {
        for (ObjectType<?> superType : superTypes) {
            if (!superType.javaType.isAssignableFrom(javaType)) {
                throw new AssertionError();
            }
        }
        HashSet tmp = new HashSet();
        for (ObjectType<?> superType : superTypes) {
            tmp.add(superType);
        }
        this.javaType = javaType;
        this.superTypes = tmp;
    }

    public Class<O> getJavaType() {
        return this.javaType;
    }

    public boolean isAssignableFrom(ObjectType<?> other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this == ANY) {
            return true;
        }
        return other == this || other.superTypes.contains(this);
    }

    public O cast(Object o) {
        if (o == null) {
            return null;
        }
        if (this.javaType.isInstance(o)) {
            return (O)((WorkspaceObject)this.javaType.cast(o));
        }
        throw new ClassCastException();
    }

    public String toString() {
        return "ObjectType[" + this.javaType + "]";
    }
}

