/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class MimeTypeResolver {
    private Properties mimeTypes = new Properties();
    private String defaultMimeType = "application/octet-stream";

    public MimeTypeResolver() {
        try {
            this.mimeTypes.load(this.getClass().getResourceAsStream("mimetypes.properties"));
        }
        catch (IOException e) {
            throw new InternalError("Unable to load mimetypes: " + e.toString());
        }
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public void setDefaultMimeType(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    public String getMimeType(String filename) {
        String ext = filename.substring(filename.lastIndexOf(".") + 1);
        if (ext.equals("")) {
            ext = filename;
        }
        return this.mimeTypes.getProperty(ext.toLowerCase(), this.defaultMimeType);
    }

    public String getExtension(String mimeType) {
        if (mimeType.equals("") || mimeType.equals(this.defaultMimeType)) {
            return "";
        }
        Iterator<Object> iterator = this.mimeTypes.keySet().iterator();
        String ext = "";
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)this.mimeTypes.get(key);
            if (value.equals(mimeType) && mimeType.endsWith(key)) {
                return key;
            }
            if (value.equals(mimeType) && ext.equals("")) {
                ext = new String(key);
                continue;
            }
            if (!value.equals(mimeType) || ext.equals("")) continue;
            return ext;
        }
        return ext;
    }
}

