/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.filter;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.webui.ext.filter.UIExtensionAbstractFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsVersionableOrAncestorFilter
extends UIExtensionAbstractFilter {
    public IsVersionableOrAncestorFilter() {
        this(null);
    }

    public IsVersionableOrAncestorFilter(String messageKey) {
        super(messageKey, UIExtensionFilterType.MANDATORY);
    }

    public static boolean isAncestorVersionable(Node node) throws RepositoryException {
        int depth = node.getDepth() - 1;
        if (depth < 1) {
            return false;
        }
        Node parent = null;
        try {
            parent = (Node)node.getAncestor(depth);
        }
        catch (ClassCastException ex) {
            parent = (Node)node.getAncestor(--depth);
        }
        do {
            if (parent.isNodeType("mix:versionable")) {
                return true;
            }
            if (--depth != 0) continue;
            return false;
        } while ((parent = (Node)node.getAncestor(depth)) != null);
        return false;
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        if (context == null) {
            return true;
        }
        Node currentNode = (Node)context.get(Node.class.getName());
        return Utils.isVersionable((Node)currentNode) || IsVersionableOrAncestorFilter.isAncestorVersionable(currentNode);
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

