/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.UINodeTreeBuilder;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/webui/form/UIFormWithoutAction.gtmpl", events={@EventConfig(listeners={ChangeWorkspaceActionListener.class}), @EventConfig(listeners={AddRootNodeActionListener.class})})
public class UIWorkspaceList
extends UIForm {
    private static String WORKSPACE_NAME = "workspaceName";
    private static String ROOT_NODE_INFO = "rootNodeInfo";
    private static String ROOT_NODE_PATH = "rootNodePath";
    private List<String> wsList_;
    private boolean isShowSystem_ = true;

    public UIWorkspaceList() throws Exception {
        ArrayList wsList = new ArrayList();
        UIFormSelectBox uiWorkspaceList = new UIFormSelectBox(WORKSPACE_NAME, WORKSPACE_NAME, wsList);
        uiWorkspaceList.setOnChange("ChangeWorkspace");
        this.addUIFormInput((UIFormInput)uiWorkspaceList);
        UIFormInputSetWithAction rootNodeInfo = new UIFormInputSetWithAction(ROOT_NODE_INFO);
        rootNodeInfo.addUIFormInput((UIFormInput)new UIFormInputInfo(ROOT_NODE_PATH, ROOT_NODE_PATH, null));
        String[] actionInfor = new String[]{"AddRootNode"};
        rootNodeInfo.setActionInfo(ROOT_NODE_PATH, actionInfor);
        rootNodeInfo.showActionInfo(true);
        rootNodeInfo.setRendered(false);
        this.addUIComponentInput((UIComponent)rootNodeInfo);
    }

    public void setIsShowSystem(boolean isShowSystem) {
        this.isShowSystem_ = isShowSystem;
    }

    public boolean isShowSystemWorkspace() {
        return this.isShowSystem_;
    }

    public void setShowRootPathSelect(boolean isRender) {
        UIFormInputSetWithAction uiInputAction = (UIFormInputSetWithAction)this.getChildById(ROOT_NODE_INFO);
        uiInputAction.setRendered(isRender);
    }

    public void setWorkspaceList(String repository) throws Exception {
        this.wsList_ = new ArrayList<String>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String[] wsNames = repositoryService.getRepository(repository).getWorkspaceNames();
        String systemWsName = repositoryService.getRepository(repository).getConfiguration().getSystemWorkspaceName();
        ArrayList<SelectItemOption> workspace = new ArrayList<SelectItemOption>();
        for (String wsName : wsNames) {
            if (!this.isShowSystem_) {
                if (wsName.equals(systemWsName)) continue;
                workspace.add(new SelectItemOption(wsName, (Object)wsName));
                this.wsList_.add(wsName);
                continue;
            }
            workspace.add(new SelectItemOption(wsName, (Object)wsName));
            this.wsList_.add(wsName);
        }
        UIFormSelectBox uiWorkspaceList = this.getUIFormSelectBox(WORKSPACE_NAME);
        uiWorkspaceList.setOptions(workspace);
        UIOneNodePathSelector uiBrowser = (UIOneNodePathSelector)this.getParent();
        if (uiBrowser.getWorkspaceName() != null && this.wsList_.contains(uiBrowser.getWorkspaceName())) {
            uiWorkspaceList.setValue(uiBrowser.getWorkspaceName());
        }
    }

    public void setIsDisable(String wsName, boolean isDisable) {
        if (this.wsList_.contains(wsName)) {
            this.getUIFormSelectBox(WORKSPACE_NAME).setValue(wsName);
        }
        this.getUIFormSelectBox(WORKSPACE_NAME).setDisabled(isDisable);
    }

    private Node getRootNode(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Session session = sessionProvider.getSession(workspaceName, manageableRepository);
        return session.getRootNode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRootNodeActionListener
    extends EventListener<UIWorkspaceList> {
        public void execute(Event<UIWorkspaceList> event) throws Exception {
            UIWorkspaceList uiWorkspaceList = (UIWorkspaceList)((Object)event.getSource());
            UIOneNodePathSelector uiJBrowser = (UIOneNodePathSelector)uiWorkspaceList.getParent();
            String returnField = uiJBrowser.getReturnFieldName();
            String workspaceName = uiJBrowser.getWorkspaceName();
            String repositoryName = uiJBrowser.getRepositoryName();
            RepositoryService repositoryService = (RepositoryService)uiWorkspaceList.getApplicationComponent(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = Utils.getSessionProvider();
            Session session = sessionProvider.getSession(workspaceName, manageableRepository);
            String value = session.getRootNode().getPath();
            if (!uiJBrowser.isDisable()) {
                value = uiJBrowser.getWorkspaceName() + ":" + value;
            }
            ((UISelectable)uiJBrowser.getSourceComponent()).doSelect(returnField, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeWorkspaceActionListener
    extends EventListener<UIWorkspaceList> {
        public void execute(Event<UIWorkspaceList> event) throws Exception {
            UIWorkspaceList uiWorkspaceList = (UIWorkspaceList)((Object)event.getSource());
            UIOneNodePathSelector uiJBrowser = (UIOneNodePathSelector)uiWorkspaceList.getParent();
            String wsName = (String)uiWorkspaceList.getUIFormSelectBox(WORKSPACE_NAME).getValue();
            uiJBrowser.setWorkspaceName(wsName);
            UINodeTreeBuilder uiTreeJCRExplorer = (UINodeTreeBuilder)uiJBrowser.getChild(UINodeTreeBuilder.class);
            UIApplication uiApp = (UIApplication)uiWorkspaceList.getAncestorOfType(UIApplication.class);
            try {
                uiTreeJCRExplorer.setRootTreeNode(uiWorkspaceList.getRootNode(uiJBrowser.getRepositoryName(), wsName));
            }
            catch (AccessDeniedException ade) {
                uiWorkspaceList.getUIFormSelectBox(WORKSPACE_NAME).setValue("collaboration");
                uiApp.addMessage(new ApplicationMessage("UIWorkspaceList.msg.AccessDeniedException", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                return;
            }
            uiTreeJCRExplorer.buildTree();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiJBrowser);
        }
    }
}

