/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.model.SelectItemOption;

@ComponentConfig(template="app:/groovy/webui/component/explorer/UIJCRExplorerContainer.gtmpl")
public class UIJcrExplorerContainer
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIJcrExplorerContainer");

    public UIJcrExplorerContainer() throws Exception {
        this.addChild(UIJCRExplorer.class, null, null);
    }

    public String getUserAgent() {
        PortletRequestContext requestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        PortletRequest portletRequest = requestContext.getRequest();
        return portletRequest.getProperty("User-Agent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initExplorer() throws Exception {
        try {
            UIJCRExplorerPortlet uiFEPortlet = (UIJCRExplorerPortlet)this.getParent();
            PortletPreferences preference = uiFEPortlet.getPortletPreferences();
            this.initExplorerPreference(preference);
            String driveName = preference.getValue("driveName", "");
            String nodePath = preference.getValue("nodePath", "");
            RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            String repoName = rservice.getCurrentRepository().getConfiguration().getName();
            ManageDriveService dservice = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
            DriveData drive = dservice.getDriveByName(driveName, repoName);
            String userId = Util.getPortalRequestContext().getRemoteUser();
            List userRoles = Utils.getMemberships();
            if (!uiFEPortlet.canUseConfigDrive(repoName, driveName)) {
                drive = ((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).getUserDrive(repoName, "private");
            }
            UIApplication uiApp = (UIApplication)this.getApplicationComponent(UIApplication.class);
            ArrayList<String> viewList = new ArrayList<String>();
            for (String role : userRoles) {
                for (String viewName : drive.getViews().split(",")) {
                    if (viewList.contains(viewName.trim())) continue;
                    Node viewNode = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(viewName.trim(), repoName, SessionProviderFactory.createSystemProvider());
                    String permiss = viewNode.getProperty("exo:accessPermissions").getString();
                    if (permiss.contains("${userId}")) {
                        permiss = permiss.replace("${userId}", userId);
                    }
                    String[] viewPermissions = permiss.split(",");
                    if (permiss.equals("*")) {
                        viewList.add(viewName.trim());
                    }
                    if (!drive.hasPermission(viewPermissions, role)) continue;
                    viewList.add(viewName.trim());
                }
            }
            if (viewList.isEmpty()) {
                return;
            }
            String viewListStr = "";
            ArrayList<SelectItemOption> viewOptions = new ArrayList<SelectItemOption>();
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            String viewLabel = null;
            for (String viewName : viewList) {
                try {
                    viewLabel = res.getString("Views.label." + viewName);
                }
                catch (MissingResourceException e) {
                    viewLabel = viewName;
                }
                viewOptions.add(new SelectItemOption(viewLabel, (Object)viewName));
                if (viewListStr.length() > 0) {
                    viewListStr = viewListStr + "," + viewName;
                    continue;
                }
                viewListStr = viewName;
            }
            drive.setViews(viewListStr);
            String homePath = drive.getHomePath();
            if (homePath.contains("${userId}")) {
                homePath = homePath.replace("${userId}", userId);
            }
            if (nodePath != null && nodePath.length() > 0 && !nodePath.equals("/")) {
                homePath = homePath + "/" + nodePath;
            }
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getChild(UIJCRExplorer.class);
            uiJCRExplorer.setDriveData(drive);
            uiJCRExplorer.setIsReferenceNode(false);
            SessionProvider provider = SessionProviderFactory.createSessionProvider();
            ManageableRepository repository = rservice.getCurrentRepository();
            Session session = provider.getSession(drive.getWorkspace(), repository);
            try {
                session.getItem(homePath);
            }
            catch (AccessDeniedException ace) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.access-denied", args, 1));
                context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (NoSuchWorkspaceException nosuchWS) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.workspace-not-exist", args, 1));
                context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            uiJCRExplorer.getAllClipBoard().clear();
            uiJCRExplorer.setRepositoryName(repoName);
            uiJCRExplorer.setWorkspaceName(drive.getWorkspace());
            uiJCRExplorer.setRootPath(homePath);
            uiJCRExplorer.setSelectNode(drive.getWorkspace(), homePath);
            Preference pref = uiJCRExplorer.getPreference();
            pref.setShowSideBar(drive.getViewSideBar());
            pref.setShowNonDocumentType(drive.getViewNonDocument());
            pref.setShowPreferenceDocuments(drive.getViewPreferences());
            pref.setAllowCreateFoder(drive.getAllowCreateFolders());
            pref.setShowHiddenNode(drive.getShowHiddenNode());
            uiJCRExplorer.refreshExplorer();
            UIControl uiControl = (UIControl)uiJCRExplorer.getChild(UIControl.class);
            UIAddressBar uiAddressBar = (UIAddressBar)uiControl.getChild(UIAddressBar.class);
            uiAddressBar.setViewList(viewList);
            uiAddressBar.setSelectedViewName((String)viewList.get(0));
            uiAddressBar.setRendered(uiFEPortlet.isShowTopBar());
            UIActionBar uiActionbar = (UIActionBar)uiControl.getChild(UIActionBar.class);
            boolean isShowActionBar = uiFEPortlet.isShowActionBar();
            uiActionbar.setTabOptions((String)viewList.get(0));
            uiActionbar.setRendered(isShowActionBar);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiJCRExplorer.getChild(UIWorkingArea.class);
            String usecase = preference.getValue("usecase", "").trim();
            if (usecase != null && "selection".equals(usecase)) {
                uiWorkingArea.setRenderedChild(UIDrivesArea.class);
            } else {
                uiWorkingArea.setRenderedChild(UIDocumentWorkspace.class);
                uiJCRExplorer.refreshExplorer();
            }
            UIRightClickPopupMenu uiRightClickPopupMenu = (UIRightClickPopupMenu)uiWorkingArea.findFirstComponentOfType(UIRightClickPopupMenu.class);
            if (uiRightClickPopupMenu != null && !uiRightClickPopupMenu.isRendered()) {
                uiRightClickPopupMenu.setRendered(true);
            }
            UISideBar uiSideBar = (UISideBar)uiWorkingArea.findFirstComponentOfType(UISideBar.class);
            uiSideBar.setRendered(true);
            uiSideBar.initialize();
            if (uiSideBar.isRendered()) {
                uiSideBar.updateSideBarView();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
    }

    private void initExplorerPreference(PortletPreferences portletPref) {
        Preference pref;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getChild(UIJCRExplorer.class);
        if (uiExplorer != null && (pref = uiExplorer.getPreference()) == null) {
            pref = new Preference();
            pref.setNodesPerPage(Integer.parseInt(portletPref.getValue(Preference.NODES_PER_PAGE, "20")));
            uiExplorer.setPreferences(pref);
        }
    }
}

