/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIEditingTagList;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIEditingTagsForm;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={UpdateTagActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITagForm
extends UIForm {
    public static final String TAG_NAME = "tagName";
    public static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    private Node selectedTag_;
    private String oldTagPath_;
    private String oldName_;

    public UITagForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(TAG_NAME, TAG_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
    }

    public Node getTag() {
        return this.selectedTag_;
    }

    public void setTag(Node selectedTag) throws Exception {
        this.selectedTag_ = selectedTag;
        if (selectedTag != null) {
            this.oldTagPath_ = this.selectedTag_.getPath();
            this.oldName_ = this.selectedTag_.getName();
            this.getUIStringInput(TAG_NAME).setValue((Object)this.oldName_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITagForm> {
        public void execute(Event<UITagForm> event) throws Exception {
            UITagForm uiForm = (UITagForm)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopup.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateTagActionListener
    extends EventListener<UITagForm> {
        public void execute(Event<UITagForm> event) throws Exception {
            String[] arrFilterChar;
            UITagForm uiForm = (UITagForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String workspace = ((UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class)).getRepository().getConfiguration().getDefaultWorkspaceName();
            String userName = uiExplorer.getSession().getUserID();
            int scope = uiExplorer.getTagScope();
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            String tagName = ((String)uiForm.getUIStringInput(UITagForm.TAG_NAME).getValue()).trim();
            if (tagName.trim().length() > 20) {
                uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tagName-too-long", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            for (String filterChar : arrFilterChar = new String[]{"&", "'", "$", "@", ":", "]", "[", "*", "%", "!", "/", "\\"}) {
                if (tagName.indexOf(filterChar) <= -1) continue;
                uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tagName-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            try {
                UIEditingTagsForm uiEdit;
                if (uiForm.getTag() == null) {
                    if (scope == 1) {
                        newFolksonomyService.addPrivateTag(new String[]{tagName}, null, null, workspace, userName);
                    }
                    if (scope == 0) {
                        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
                        String publicTagNodePath = nodeHierarchyCreator.getJcrPath(UITagForm.PUBLIC_TAG_NODE_PATH);
                        newFolksonomyService.addPublicTag(publicTagNodePath, new String[]{tagName}, null, null, workspace);
                    }
                } else if (!this.existTag(tagName, null, workspace, scope, uiForm, userName)) {
                    newFolksonomyService.modifyTagName(uiForm.oldTagPath_, tagName, null, workspace);
                } else if (!tagName.equals(uiForm.oldName_)) {
                    uiApp.addMessage(new ApplicationMessage("UITagForm.msg.NameAlreadyExist", null, 1));
                }
                if ((uiEdit = (UIEditingTagsForm)uiForm.getAncestorOfType(UIEditingTagsForm.class)) != null) {
                    ((UIEditingTagList)uiEdit.getChild(UIEditingTagList.class)).updateGrid();
                }
            }
            catch (Exception e) {
                String key = "UITagStyleForm.msg.error-update";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShow(false);
            Preference preferences = uiExplorer.getPreference();
            if (preferences.isShowSideBar()) {
                UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopup.getParent());
        }

        private boolean existTag(String tagName, String repo, String workspace, int scope, UITagForm uiForm, String userName) throws Exception {
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            String publicTagNodePath = nodeHierarchyCreator.getJcrPath(UITagForm.PUBLIC_TAG_NODE_PATH);
            List tagList = scope == 0 ? newFolksonomyService.getAllPublicTags(publicTagNodePath, repo, workspace) : newFolksonomyService.getAllPrivateTags(userName, repo, workspace);
            for (Node tag : tagList) {
                if (!tag.getName().equals(tagName)) continue;
                return true;
            }
            return false;
        }
    }
}

