/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives.impl;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    private ManageDriveService driveService_;
    private RepositoryService jcrService_;
    private InitParams initParams_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String userPath_;
    static final String PRIVATE_ALIAS = "userPrivate";
    static final String PUBLIC_ALIAS = "userPublic";

    public NewUserListener(RepositoryService jcrService, ManageDriveService driveService, NodeHierarchyCreator nodeHierarchyCreatorService, InitParams params) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreatorService;
        this.jcrService_ = jcrService;
        this.driveService_ = driveService;
        this.initParams_ = params;
        this.userPath_ = nodeHierarchyCreatorService.getJcrPath("usersPath");
    }

    public void preSave(User user, boolean isNew) throws Exception {
        String workspace = this.initParams_.getValueParam("workspace").getValue();
        String permissions = this.initParams_.getValueParam("permissions").getValue();
        permissions = permissions.concat("," + user.getUserName());
        String homePath = this.userPath_ + "/" + user.getUserName();
        String views = this.initParams_.getValueParam("views").getValue();
        String icon = this.initParams_.getValueParam("icon").getValue();
        boolean viewPreferences = Boolean.parseBoolean(this.initParams_.getValueParam("viewPreferences").getValue());
        boolean viewNonDocument = Boolean.parseBoolean(this.initParams_.getValueParam("viewNonDocument").getValue());
        boolean viewSideBar = Boolean.parseBoolean(this.initParams_.getValueParam("viewSideBar").getValue());
        boolean showHiddenNode = Boolean.parseBoolean(this.initParams_.getValueParam("showHiddenNode").getValue());
        String allowCreateFolder = this.initParams_.getValueParam("allowCreateFolder").getValue();
        String allowNodeTypesOnTree = this.initParams_.getValueParam("allowNodeTypesOnTree").getValue();
        String publicPath = this.nodeHierarchyCreator_.getJcrPath(PUBLIC_ALIAS);
        String privatePath = this.nodeHierarchyCreator_.getJcrPath(PRIVATE_ALIAS);
        this.driveService_.addDrive(user.getUserName() + "|" + privatePath, workspace, user.getUserName(), homePath + "/" + privatePath, views, icon, viewPreferences, viewNonDocument, viewSideBar, showHiddenNode, allowCreateFolder, allowNodeTypesOnTree);
        this.driveService_.addDrive(user.getUserName() + "|" + publicPath, workspace, permissions, homePath + "/" + publicPath, views, icon, viewPreferences, viewNonDocument, viewSideBar, showHiddenNode, allowCreateFolder, allowNodeTypesOnTree);
    }

    public void preDelete(User user) throws Exception {
        ManageableRepository repository = this.jcrService_.getCurrentRepository();
        this.driveService_.removeDrive(user.getUserName() + "|" + this.nodeHierarchyCreator_.getJcrPath(PRIVATE_ALIAS), repository.getConfiguration().getName());
        this.driveService_.removeDrive(user.getUserName() + "|" + this.nodeHierarchyCreator_.getJcrPath(PUBLIC_ALIAS), repository.getConfiguration().getName());
    }
}

