/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.backup.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectZipWriterImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.BackupException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.Backupable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupTables {
    public static final String CONTENT_FILE_SUFFIX = ".dump";
    public static final String CONTENT_LEN_FILE_SUFFIX = ".len";
    public static final int DB_DIALECT_MYSQL = DBConstants.DB_DIALECT_MYSQL.hashCode();
    public static final int DB_DIALECT_MYSQL_UTF8 = DBConstants.DB_DIALECT_MYSQL_UTF8.hashCode();
    public static final int DB_DIALECT_DB2 = DBConstants.DB_DIALECT_DB2.hashCode();
    public static final int DB_DIALECT_DB2V8 = DBConstants.DB_DIALECT_DB2V8.hashCode();
    public static final int DB_DIALECT_PGSQL = DBConstants.DB_DIALECT_PGSQL.hashCode();
    public static final int DB_DIALECT_SYBASE = DBConstants.DB_DIALECT_SYBASE.hashCode();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void backup(File storageDir, String dsName, Map<String, String> scripts) throws BackupException {
        Connection jdbcConn = null;
        try {
            try {
                final DataSource ds = (DataSource)new InitialContext().lookup(dsName);
                if (ds == null) {
                    throw new NameNotFoundException("Data source " + dsName + " not found");
                }
                jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws Exception {
                        return ds.getConnection();
                    }
                });
                for (Map.Entry<String, String> entry : scripts.entrySet()) {
                    BackupTables.dumpTable(jdbcConn, entry.getKey(), entry.getValue(), storageDir);
                }
                Object var10_12 = null;
                if (jdbcConn == null) return;
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
            catch (SQLException e) {
                String errorTrace = "";
                for (SQLException next = e.getNextException(); next != null; next = next.getNextException()) {
                    errorTrace = errorTrace + next.getMessage() + "; ";
                }
                Throwable cause = e.getCause();
                String msg = "SQL Exception: " + errorTrace + (cause != null ? " (Cause: " + cause.getMessage() + ")" : "");
                throw new BackupException(msg, e);
            }
            catch (NamingException e) {
                throw new BackupException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (jdbcConn == null) throw throwable;
            try {
                jdbcConn.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BackupException(e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new BackupException(e);
        }
        jdbcConn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpTable(Connection jdbcConn, String tableName, String script, File storageDir) throws IOException, SQLException {
        ResultSet rs;
        Statement stmt;
        ObjectZipWriterImpl contentLenWriter;
        block17: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(Backupable.BACKUP_RESTORE_PERMISSION);
            }
            int dialect = DialectDetecter.detect(jdbcConn.getMetaData()).hashCode();
            ObjectZipWriterImpl contentWriter = null;
            contentLenWriter = null;
            stmt = null;
            rs = null;
            try {
                int i;
                File contentFile = new File(storageDir, tableName + CONTENT_FILE_SUFFIX);
                contentWriter = new ObjectZipWriterImpl(PrivilegedFileHelper.zipOutputStream((File)contentFile));
                contentWriter.putNextEntry(new ZipEntry(tableName));
                File contentLenFile = new File(storageDir, tableName + CONTENT_LEN_FILE_SUFFIX);
                contentLenWriter = new ObjectZipWriterImpl(PrivilegedFileHelper.zipOutputStream((File)contentLenFile));
                contentLenWriter.putNextEntry(new ZipEntry(tableName));
                stmt = jdbcConn.prepareStatement(script);
                rs = stmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                int[] columnType = new int[columnCount];
                contentWriter.writeInt(columnCount);
                for (i = 0; i < columnCount; ++i) {
                    columnType[i] = metaData.getColumnType(i + 1);
                    contentWriter.writeInt(columnType[i]);
                    contentWriter.writeString(metaData.getColumnName(i + 1));
                }
                while (rs.next()) {
                    for (i = 0; i < columnCount; ++i) {
                        InputStream value;
                        if (columnType[i] == -3 || columnType[i] == -4 || columnType[i] == 2004 || columnType[i] == -2) {
                            value = rs.getBinaryStream(i + 1);
                        } else {
                            String str = rs.getString(i + 1);
                            InputStream inputStream = value = str == null ? null : new ByteArrayInputStream(str.getBytes("UTF-8"));
                        }
                        if (value == null) {
                            contentLenWriter.writeLong(-1L);
                            continue;
                        }
                        long len = 0L;
                        int read = 0;
                        byte[] tmpBuff = new byte[2048];
                        while ((read = value.read(tmpBuff)) >= 0) {
                            contentWriter.write(tmpBuff, 0, read);
                            len += (long)read;
                        }
                        contentLenWriter.writeLong(len);
                    }
                }
                Object var22_21 = null;
                if (contentWriter == null) break block17;
            }
            catch (Throwable throwable) {
                Object var22_22 = null;
                if (contentWriter != null) {
                    contentWriter.closeEntry();
                    contentWriter.close();
                }
                if (contentLenWriter != null) {
                    contentLenWriter.closeEntry();
                    contentLenWriter.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            contentWriter.closeEntry();
            contentWriter.close();
        }
        if (contentLenWriter != null) {
            contentLenWriter.closeEntry();
            contentLenWriter.close();
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
    }
}

