/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterConstant {
    private static Log log = ExoLogger.getLogger((String)"wcm.NewsletterConstant");
    public static final String CATEGORIES_PROPERTY_ADDMINISTRATOR = "exo:newsletteraddministrator";
    public static final String CATEGORY_NODETYPE = "exo:newsletterCategory";
    public static final String CATEGORY_PROPERTY_TITLE = "exo:newsletterCategoryTitle";
    public static final String CATEGORY_PROPERTY_DESCRIPTION = "exo:newsletterCategoryDescription";
    public static final String SUBSCRIPTION_NODETYPE = "exo:newsletterSubscription";
    public static final String SUBSCRIPTION_PROPERTY_USER = "exo:newsletterSubscribedUser";
    public static final String SUBSCRIPTION_PROPERTY_TITLE = "exo:newsletterSubscriptionTitle";
    public static final String SUBSCRIPTION_PROPERTY_DECRIPTION = "exo:newsletterSubscriptionDecription";
    public static final String SUBSCRIPTION_PROPERTY_CATEGORY_NAME = "exo:newsletterSubscriptionCategoryName";
    public static final String ENTRY_NODETYPE = "exo:newsletterEntry";
    public static final String ENTRY_PROPERTY_TYPE = "exo:newsletterEntryType";
    public static final String ENTRY_PROPERTY_DATE = "exo:newsletterEntryDate";
    public static final String ENTRY_PROPERTY_STATUS = "exo:newsletterEntryStatus";
    public static final String ENTRY_PROPERTY_SUBSCRIPTION_NAME = "exo:newsletterEntrySubscriptionName";
    public static final String ENTRY_PROPERTY_CATEGORY_NAME = "exo:newsletterEntryCategoryName";
    public static final String ENTRY_PROPERTY_CONTENT_MAIN = "exo:newsletterEntryContentMain";
    public static final String ENTRY_PROPERTY_NAME = "exo:newsletterEntryName";
    public static final String ENTRY_PROPERTY_TITLE = "exo:newsletterEntryTitle";
    public static final String USER_NODETYPE = "exo:newsletterUser";
    public static final String USER_PROPERTY_MAIL = "exo:newsletterUserMail";
    public static final String USER_PROPERTY_BANNED = "exo:newsletterUserBanned";
    public static final String USER_PROPERTY_VALIDATION_CODE = "exo:newsletterUserValidationCode";
    public static final String USER_PROPERTY_IS_CONFIRM = "exo:newsletterUserConfirm";
    public static final String STATUS_DRAFT = "draft";
    public static final String STATUS_AWAITING = "awaiting";
    public static final String STATUS_SENT = "sent";
    public static final String PORTAL_NAME = "portalName";
    public static String TEMPLATE_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/DefaultTemplates";
    public static String CATEGORY_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/Categories";
    public static String USER_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/Users";
    private static PortalContainer manager;

    public static String generateDefaultTemplatePath(String portalName) {
        return TEMPLATE_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateCategoryTemplateBasePath(String portalName, String categoryName) {
        return NewsletterConstant.generateCategoryPath(portalName).concat("/" + categoryName).concat("/Templates");
    }

    public static String generateCategoryPath(String portalName) {
        return CATEGORY_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateUserPath(String portalName) {
        return USER_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateSubscriptionPath(String portalName, String categoryName, String subscriptionName) {
        return NewsletterConstant.generateCategoryPath(portalName).concat("/" + categoryName).concat("/" + subscriptionName);
    }

    public static String generateNewsletterPath(String portalName, String categoryName, String subscriptionName, String newsletterName) {
        return NewsletterConstant.generateSubscriptionPath(portalName, categoryName, subscriptionName).concat("/" + newsletterName);
    }

    public static List<String> getAllPermissionOfNode(Node node) throws Exception {
        ExtendedNode webContent = (ExtendedNode)node;
        Iterator permissionIterator = webContent.getACL().getPermissionEntries().iterator();
        HashMap<String, Integer> mapPermission = new HashMap<String, Integer>();
        while (permissionIterator.hasNext()) {
            AccessControlEntry accessControlEntry = (AccessControlEntry)permissionIterator.next();
            String currentIdentity = accessControlEntry.getIdentity();
            if (mapPermission.containsKey(currentIdentity)) {
                mapPermission.put(currentIdentity, (Integer)mapPermission.get(currentIdentity) + 1);
                continue;
            }
            mapPermission.put(currentIdentity, 1);
        }
        int size = PermissionType.ALL.length;
        ArrayList<String> listPermission = new ArrayList<String>();
        for (String key : mapPermission.keySet().toArray(new String[0])) {
            if ((Integer)mapPermission.get(key) != size) continue;
            listPermission.add(key);
        }
        return listPermission;
    }

    public static boolean havePermission(List<String> list1, List<String> list2) {
        for (String str : list1) {
            if (!list2.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static void addPermissionsFromCateToSubs(Node categoryNode, String[] userIds, String[] permissions) throws Exception {
        NodeIterator ni = categoryNode.getNodes();
        while (ni.hasNext()) {
            ExtendedNode extendSubscriptionNode;
            Node subscriptionNode = ni.nextNode();
            if (!subscriptionNode.isNodeType(SUBSCRIPTION_NODETYPE) || !(extendSubscriptionNode = (ExtendedNode)ExtendedNode.class.cast(subscriptionNode)).canAddMixin("exo:privilegeable") && !extendSubscriptionNode.isNodeType("exo:privilegeable")) continue;
            if (extendSubscriptionNode.canAddMixin("exo:privilegeable")) {
                extendSubscriptionNode.addMixin("exo:privilegeable");
            }
            for (String userId : userIds) {
                extendSubscriptionNode.setPermission(userId, permissions);
            }
        }
    }

    public static void updateAccessPermission(String[] accessPermissions) throws Exception {
        OrganizationService organizationService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)manager);
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)WCMCoreUtils.getService(WCMConfigurationService.class);
        String membership = wcmConfigurationService.getRuntimeContextParam("newsletterManageMembership");
        MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(membership.split(":")[0]);
        Group group = organizationService.getGroupHandler().findGroupById(membership.split(":")[1]);
        ArrayList<User> users = new ArrayList<User>();
        DataStorage dataStorage = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        Page page = dataStorage.getPage(Util.getUIPortal().getSelectedUserNode().getPageRef());
        ArrayList<String> pageAccessPermissions = new ArrayList<String>(Arrays.asList(page.getAccessPermissions()));
        UserHandler userHandler = organizationService.getUserHandler();
        MembershipHandler membershipHandler = organizationService.getMembershipHandler();
        for (String newAccessPermission : accessPermissions) {
            if (pageAccessPermissions.contains(newAccessPermission)) continue;
            User currentUser = userHandler.findUserByName(newAccessPermission);
            if (currentUser == null) {
                PageList listUsers = userHandler.findUsersByGroup(newAccessPermission.split(":")[1]);
                List usersTmp = listUsers.getAll();
                for (User userTmp : usersTmp) {
                    users.add(userTmp);
                }
            } else {
                users.add(currentUser);
            }
            for (User user : users) {
                membershipHandler.linkMembership(userHandler.findUserByName(user.getUserName()), group, membershipType, true);
            }
            pageAccessPermissions.add(newAccessPermission);
        }
        ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)manager);
        page.setAccessPermissions(pageAccessPermissions.toArray(new String[0]));
        dataStorage.save(page);
    }

    public static void removeAccessPermission(String[] removedPermissions) throws Exception {
        OrganizationService organizationService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)manager);
        MembershipHandler memberShipHandler = organizationService.getMembershipHandler();
        DataStorage dataStorage = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        Page page = dataStorage.getPage(Util.getUIPortal().getSelectedUserNode().getPageRef());
        ArrayList<String> pageAccessPermissions = new ArrayList<String>(Arrays.asList(page.getAccessPermissions()));
        for (String removedPermission : removedPermissions) {
            if (!pageAccessPermissions.contains(removedPermission)) continue;
            pageAccessPermissions.remove(removedPermission);
            memberShipHandler.removeMembershipByUser(removedPermission, true);
        }
        ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)manager);
        page.setAccessPermissions(pageAccessPermissions.toArray(new String[0]));
        dataStorage.save(page);
    }

    public static NodeIterator getAllCategories(Session session) throws Exception {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "Select * from exo:newsletterCategory";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        return queryResult.getNodes();
    }

    public static List<String> getAllRedactor(String portalName, Session session) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String path = NewsletterConstant.generateCategoryPath(portalName);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "select * from exo:newsletterSubscription where jcr:path LIKE '" + path + "[%]/%'";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        while (nodeIterator.hasNext()) {
            Node subNode = nodeIterator.nextNode();
            for (String str : NewsletterConstant.getAllPermissionOfNode(subNode)) {
                if (list.contains(str)) continue;
                list.add(str);
            }
        }
        return list;
    }

    public static List<String> removePermission(Node subscriptionNode, Node categoryNode, List<String> candidateRemove, boolean isAddNew, String portalName, Session session) {
        if (candidateRemove == null) {
            candidateRemove = new ArrayList<String>();
        }
        try {
            NodeIterator categoriesIterator = NewsletterConstant.getAllCategories(session);
            List<String> allRedactor = NewsletterConstant.getAllRedactor(portalName, session);
            List<String> allpermissions = null;
            block2: while (categoriesIterator.hasNext()) {
                allpermissions = NewsletterConstant.getAllPermissionOfNode(categoriesIterator.nextNode());
                for (String permission : allpermissions) {
                    if (candidateRemove.isEmpty()) continue block2;
                    if (!candidateRemove.contains(permission)) continue;
                    candidateRemove.remove(permission);
                }
            }
            for (String redactor : allRedactor) {
                if (!candidateRemove.isEmpty()) {
                    if (!candidateRemove.contains(redactor)) continue;
                    candidateRemove.remove(redactor);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
        return candidateRemove;
    }

    public static List<String> convertValuesToArray(Value[] values) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Value value : values) {
            try {
                listString.add(value.getString());
            }
            catch (Exception e) {
                return null;
            }
        }
        return listString;
    }

    public static boolean hasPermission(String userId, Node node) {
        try {
            ExtendedNode categoryNode = (ExtendedNode)node;
            AccessControlEntry accessControlEntry = null;
            Iterator permissionIterator = categoryNode.getACL().getPermissionEntries().iterator();
            ArrayList<String> permissions = new ArrayList<String>();
            while (permissionIterator.hasNext()) {
                accessControlEntry = (AccessControlEntry)permissionIterator.next();
                permissions.add(accessControlEntry.getIdentity());
            }
            return WCMCoreUtils.hasPermission((String)userId, permissions, (boolean)true);
        }
        catch (Exception e) {
            log.error((Object)"Exception when call NewsletterConstant.hasPermission()", (Throwable)e);
            return false;
        }
    }
}

