/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache.jdbc;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.jdbc.LockJDBCConnection;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializer;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LockJDBCContainer {
    private final Log log;
    private DataSource dataSource;
    private String wsName;

    /*
     * Loose catch block
     */
    public LockJDBCContainer(String dataSourceName, String wsName) throws RepositoryException {
        block13: {
            this.log = ExoLogger.getLogger((String)"exo.jcr.component.core.LockJDBCContainer");
            this.wsName = wsName;
            try {
                this.dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
                if (this.dataSource != null) {
                    Connection jdbcConn = null;
                    try {
                        this.log.info((Object)"Creating LockManager DB tables.");
                        jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                            @Override
                            public Connection run() throws Exception {
                                return LockJDBCContainer.this.dataSource.getConnection();
                            }
                        });
                        this.initDatabase(dataSourceName, jdbcConn);
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (jdbcConn != null && !jdbcConn.isClosed()) {
                            try {
                                jdbcConn.close();
                            }
                            catch (SQLException e) {
                                this.log.error((Object)"Error of connection close", (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (jdbcConn != null && !jdbcConn.isClosed()) {
                        try {
                            jdbcConn.close();
                        }
                        catch (SQLException e) {
                            this.log.error((Object)"Error of connection close", (Throwable)e);
                        }
                    }
                    break block13;
                    {
                        catch (SQLException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        catch (IOException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                    }
                }
                throw new RepositoryException("Datasource '" + dataSourceName + "' is not bound in this context.");
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    public LockJDBCConnection openConnection() throws RepositoryException {
        try {
            return new LockJDBCConnection(this.getJDBCConnection(), this.wsName);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Connection getJDBCConnection() throws LockException {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            String err = "Error of JDBC connection open. SQLException: " + e.getMessage() + ", SQLState: " + e.getSQLState() + ", VendorError: " + e.getErrorCode();
            throw new LockException(err, (Throwable)e);
        }
    }

    protected void initDatabase(String dataSource, Connection jdbcConn) throws IOException, DBInitializerException {
        DBInitializer dbInitializer = new DBInitializer(dataSource, jdbcConn, "/conf/storage/jcr-lock-jdbc.sql");
        dbInitializer.init();
    }
}

