/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.views.TemplateBean;
import org.exoplatform.ecm.webui.component.admin.views.UITemplateContainer;
import org.exoplatform.ecm.webui.component.admin.views.UITemplateForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewManager;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UICBTemplateList.msg.confirm-delete"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={AddActionListener.class})})
public class UICBTemplateList
extends UIPagingGrid {
    private static String[] VIEW_BEAN_FIELD = new String[]{"name", "path", "baseVersion"};
    private static String[] VIEW_ACTION = new String[]{"EditInfo", "Delete"};
    public static String ST_CBTempForm = "CBTempForm";
    public static String ST_CBTemp = "CBTemplate";

    public UICBTemplateList() throws Exception {
        this.getUIPageIterator().setId("UICBTemplateGrid");
        this.configure("path", VIEW_BEAN_FIELD, VIEW_ACTION);
    }

    public String[] getActions() {
        return new String[]{"Add"};
    }

    public String getBaseVersion(Node node) throws Exception {
        if (!node.isNodeType("mix:versionable") || node.isNodeType(Utils.NT_FROZEN)) {
            return "";
        }
        return node.getBaseVersion().getName();
    }

    public List<Node> getAllTemplates() throws Exception {
        ManageViewService viewService = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        ArrayList<Node> templateList = new ArrayList<Node>();
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        templateList.addAll(viewService.getAllTemplates("cbDetaiViewTemplates", provider));
        templateList.addAll(viewService.getAllTemplates("cbPathTemplates", provider));
        templateList.addAll(viewService.getAllTemplates("cbQueryTemplates", provider));
        templateList.addAll(viewService.getAllTemplates("cbScriptTemplates", provider));
        return templateList;
    }

    public String getRepository() {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }

    public void refresh(int currentPage) throws Exception {
        List<Node> nodes = this.getAllTemplates();
        ArrayList<TemplateBean> tempBeans = new ArrayList<TemplateBean>();
        for (Node node : nodes) {
            tempBeans.add(new TemplateBean(node.getName(), node.getPath(), this.getBaseVersion(node)));
        }
        Collections.sort(tempBeans, new CBViewComparator());
        ListAccessImpl tmplBeanList = new ListAccessImpl(TemplateBean.class, tempBeans);
        this.getUIPageIterator().setPageList((PageList)new LazyPageList((ListAccess)tmplBeanList, this.getUIPageIterator().getItemsPerPage()));
        this.getUIPageIterator().setTotalItems(tempBeans.size());
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInfoActionListener
    extends EventListener<UICBTemplateList> {
        public void execute(Event<UICBTemplateList> event) throws Exception {
            UICBTemplateList uiCBTemp = (UICBTemplateList)((Object)event.getSource());
            String tempPath = event.getRequestContext().getRequestParameter("objectId");
            UIViewManager uiViewManager = (UIViewManager)uiCBTemp.getAncestorOfType(UIViewManager.class);
            UITemplateContainer uiTempContainer = (UITemplateContainer)uiViewManager.getChildById(ST_CBTemp);
            uiTempContainer.removeChildById(ST_CBTempForm + "Add");
            uiTempContainer.initPopup(ST_CBTempForm, "Edit");
            UITemplateForm uiTempForm = (UITemplateForm)uiTempContainer.findComponentById(ST_CBTempForm);
            uiTempForm.isAddNew_ = false;
            uiTempForm.update(tempPath, null);
            uiViewManager.setRenderedChild(ST_CBTemp);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTempContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UICBTemplateList> {
        public void execute(Event<UICBTemplateList> event) throws Exception {
            UICBTemplateList uiCBTemp = (UICBTemplateList)((Object)event.getSource());
            String templatePath = event.getRequestContext().getRequestParameter("objectId");
            ((ManageViewService)uiCBTemp.getApplicationComponent(ManageViewService.class)).removeTemplate(templatePath);
            uiCBTemp.refresh(uiCBTemp.getUIPageIterator().getCurrentPage());
            uiCBTemp.setRenderSibling(UICBTemplateList.class);
            UIViewManager uiViewManager = (UIViewManager)uiCBTemp.getAncestorOfType(UIViewManager.class);
            uiViewManager.setRenderedChild(ST_CBTemp);
            UITemplateContainer uiTempContainer = (UITemplateContainer)uiViewManager.getChildById(ST_CBTemp);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTempContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UICBTemplateList> {
        public void execute(Event<UICBTemplateList> event) throws Exception {
            UICBTemplateList uiCBTemp = (UICBTemplateList)((Object)event.getSource());
            SessionProvider provider = SessionProviderFactory.createSessionProvider();
            Node cbTemplateHome = ((ManageViewService)uiCBTemp.getApplicationComponent(ManageViewService.class)).getTemplateHome("contentBrowserTemplates", provider);
            if (cbTemplateHome == null) {
                UIApplication uiApp = (UIApplication)((UICBTemplateList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UICBTemplateList.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UIViewManager uiViewManager = (UIViewManager)uiCBTemp.getAncestorOfType(UIViewManager.class);
            UITemplateContainer uiECMTempContainer = (UITemplateContainer)uiViewManager.getChildById(ST_CBTemp);
            uiECMTempContainer.removeChildById(ST_CBTempForm + "Edit");
            uiECMTempContainer.initPopup(ST_CBTempForm, "Add");
            uiViewManager.setRenderedChild(ST_CBTemp);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiECMTempContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CBViewComparator
    implements Comparator<TemplateBean> {
        @Override
        public int compare(TemplateBean t1, TemplateBean t2) throws ClassCastException {
            String name1 = t1.getName();
            String name2 = t2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

