/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.admin.script.UICBScripts;
import org.exoplatform.ecm.webui.component.admin.script.UIECMScripts;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptList;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptManager;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RestoreActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RefreshActionListener.class})})
public class UIScriptForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_SELECT_VERSION = "selectVersion";
    public static final String FIELD_SCRIPT_CONTENT = "scriptContent";
    public static final String FIELD_SCRIPT_NAME = "scriptName";
    public static final String FIELD_ENABLE_VERSION = "enableVersion";
    public static final String SCRIPT_FILE_TYPE = ".groovy";
    private List<String> listVersion = new ArrayList<String>();
    private boolean isAddNew_ = true;
    private ScriptService scriptService = (ScriptService)WCMCoreUtils.getService(ScriptService.class);

    public UIScriptForm() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_SELECT_VERSION, FIELD_SELECT_VERSION, options);
        UIFormTextAreaInput contents = new UIFormTextAreaInput(FIELD_SCRIPT_CONTENT, FIELD_SCRIPT_CONTENT, null);
        contents.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormCheckBoxInput isVersion = new UIFormCheckBoxInput(FIELD_ENABLE_VERSION, FIELD_ENABLE_VERSION, null);
        UIFormStringInput scriptName = new UIFormStringInput(FIELD_SCRIPT_NAME, FIELD_SCRIPT_NAME, null);
        scriptName.addValidator(MandatoryValidator.class, new Object[0]);
        versions.setOnChange("Change");
        versions.setRendered(false);
        isVersion.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)contents);
        this.addUIFormInput((UIFormInput)isVersion);
        this.addUIFormInput((UIFormInput)scriptName);
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        return vH == null ? null : new VersionNode(vH.getRootVersion(), node.getSession());
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List<VersionNode> child = new ArrayList();
        for (int i = 0; i < children.size(); ++i) {
            this.listVersion.add(children.get(i).getName());
            child = children.get(i).getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion.clear();
        List<String> versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt(versionList.get(j)) >= Integer.parseInt(versionList.get(i))) continue;
                String temp = versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(versionList.get(i), (Object)versionList.get(i)));
        }
        return options;
    }

    public void update(Node script, boolean isAddNew) throws Exception {
        this.isAddNew_ = isAddNew;
        if (script != null) {
            String scriptContent = this.scriptService.getScriptAsText(script);
            this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setRendered(true);
            boolean isVersioned = script.isNodeType("mix:versionable");
            if (isVersioned) {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(true);
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setOptions(this.getVersionValues(script));
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setValue(script.getBaseVersion().getName());
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setEnable(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(true);
                this.setActions(new String[]{"Save", "Restore", "Refresh", "Cancel"});
            } else {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setEnable(true);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(false);
                this.setActions(new String[]{"Save", "Refresh", "Cancel"});
            }
            this.getUIFormTextAreaInput(FIELD_SCRIPT_CONTENT).setValue((Object)scriptContent);
            this.getUIStringInput(FIELD_SCRIPT_NAME).setValue((Object)script.getName());
            this.getUIStringInput(FIELD_SCRIPT_NAME).setEditable(false);
            return;
        }
        if (!this.isAddNew_) {
            this.getUIFormTextAreaInput(FIELD_SCRIPT_CONTENT).setValue(null);
            return;
        }
        this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
        this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setRendered(false);
        this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(false);
        this.getUIStringInput(FIELD_SCRIPT_NAME).setEditable(true);
        this.getUIStringInput(FIELD_SCRIPT_NAME).setValue(null);
        this.getUIFormTextAreaInput(FIELD_SCRIPT_CONTENT).setValue(null);
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
            uiForm.reset();
            UIScriptManager uiManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
            if (uiForm.getId().equals(UIECMScripts.SCRIPTFORM_NAME)) {
                ((UIECMScripts)uiManager.getChild(UIECMScripts.class)).removeChildById("ECMScriptPopupWindow");
            } else {
                ((UICBScripts)uiManager.getChild(UICBScripts.class)).removeChildById("BCScriptPopupWindow");
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
            String sciptName = (String)uiForm.getUIStringInput(UIScriptForm.FIELD_SCRIPT_NAME).getValue();
            if (uiForm.isAddNew_) {
                uiForm.update(null, true);
            } else {
                UIScriptManager uiScriptManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
                UIScriptList uiScriptList = uiForm.getId().equals(UIECMScripts.SCRIPTFORM_NAME) ? (UIScriptList)uiScriptManager.findComponentById(UIECMScripts.SCRIPTLIST_NAME) : (UIScriptList)uiScriptManager.findComponentById(UICBScripts.SCRIPTLIST_NAME);
                try {
                    Node script = uiScriptList.getScriptNode(sciptName);
                    uiForm.update(script, false);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    String namePrefix = uiScriptList.getScriptCategory();
                    Object[] args = new Object[]{namePrefix};
                    UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIScriptForm.msg.PathNotFoundException", args, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIScriptManager.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
            String name = (String)uiForm.getUIStringInput(UIScriptForm.FIELD_SCRIPT_NAME).getValue();
            UIScriptList uiScript = null;
            UIScriptManager uiManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
            if (uiForm.getId().equals(UIECMScripts.SCRIPTFORM_NAME)) {
                uiScript = (UIScriptList)uiManager.findComponentById(UIECMScripts.SCRIPTLIST_NAME);
            } else if (uiForm.getId().equals(UICBScripts.SCRIPTFORM_NAME)) {
                uiScript = (UIScriptList)uiManager.findComponentById(UICBScripts.SCRIPTLIST_NAME);
            }
            Node node = uiScript.getScriptNode(name);
            String version = (String)uiForm.getUIFormSelectBox(UIScriptForm.FIELD_SELECT_VERSION).getValue();
            String path = node.getVersionHistory().getVersion(version).getPath();
            VersionNode versionNode = uiForm.getRootVersion(node).findVersionNode(path);
            Node frozenNode = versionNode.getNode("jcr:frozenNode");
            String scriptContent = frozenNode.getNode("jcr:content").getProperty("jcr:data").getString();
            uiForm.getUIFormTextAreaInput(UIScriptForm.FIELD_SCRIPT_CONTENT).setValue((Object)scriptContent);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIScriptManager.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestoreActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
            String name = (String)uiForm.getUIStringInput(UIScriptForm.FIELD_SCRIPT_NAME).getValue();
            UIScriptList uiScriptList = null;
            UIScriptManager uiManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
            if (uiForm.getId().equals(UIECMScripts.SCRIPTFORM_NAME)) {
                uiScriptList = (UIScriptList)uiManager.findComponentById(UIECMScripts.SCRIPTLIST_NAME);
            } else if (uiForm.getId().equals(UICBScripts.SCRIPTFORM_NAME)) {
                uiScriptList = (UIScriptList)uiManager.findComponentById(UICBScripts.SCRIPTLIST_NAME);
            }
            try {
                Node node = uiScriptList.getScriptNode(name);
                String vesion = (String)uiForm.getUIFormSelectBox(UIScriptForm.FIELD_SELECT_VERSION).getValue();
                String baseVesion = node.getBaseVersion().getName();
                if (!vesion.equals(baseVesion)) {
                    node.checkout();
                    node.restore(vesion, true);
                    uiScriptList.refresh(1);
                }
                if (uiForm.getId().equals(UIECMScripts.SCRIPTFORM_NAME)) {
                    ((UIECMScripts)uiManager.getChild(UIECMScripts.class)).removeChildById("ECMScriptPopupWindow");
                } else {
                    ((UICBScripts)uiManager.getChild(UICBScripts.class)).removeChildById("BCScriptPopupWindow");
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            String[] arrFilterChar;
            UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
            ScriptService scriptService = (ScriptService)uiForm.getApplicationComponent(ScriptService.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String name = ((String)uiForm.getUIStringInput(UIScriptForm.FIELD_SCRIPT_NAME).getValue()).trim();
            String content = (String)uiForm.getUIFormTextAreaInput(UIScriptForm.FIELD_SCRIPT_CONTENT).getValue();
            if (content == null) {
                content = "";
            }
            if (name == null || name.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIScriptForm.msg.name-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            for (String filterChar : arrFilterChar = new String[]{"&", "$", "@", ":", "]", "'", "[", "*", "%", "!", "\""}) {
                if (name.indexOf(filterChar) <= -1) continue;
                uiApp.addMessage(new ApplicationMessage("UIScriptForm.msg.fileName-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!name.contains(UIScriptForm.SCRIPT_FILE_TYPE)) {
                name = name + UIScriptForm.SCRIPT_FILE_TYPE;
            }
            UIScriptList curentList = null;
            UIScriptManager uiManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
            ArrayList<String> listScript = new ArrayList<String>();
            List<Object> scriptDatas = new ArrayList();
            String namePrefix = null;
            if (uiForm.getId().equals(UIECMScripts.SCRIPTFORM_NAME)) {
                curentList = (UIScriptList)uiManager.findComponentById(UIECMScripts.SCRIPTLIST_NAME);
                UIECMScripts uiEScripts = (UIECMScripts)uiManager.getChild(UIECMScripts.class);
                namePrefix = curentList.getScriptCategory();
                String subNamePrefix = namePrefix.substring(namePrefix.lastIndexOf("/") + 1, namePrefix.length());
                scriptDatas = uiEScripts.getECMScript(subNamePrefix);
            } else if (uiForm.getId().equals(UICBScripts.SCRIPTFORM_NAME)) {
                curentList = (UIScriptList)uiManager.findComponentById(UICBScripts.SCRIPTLIST_NAME);
                UICBScripts uiCBScripts = (UICBScripts)uiManager.getChild(UICBScripts.class);
                namePrefix = curentList.getScriptCategory();
                scriptDatas = uiCBScripts.getCBScript();
            }
            for (UIScriptList.ScriptData data : scriptDatas) {
                listScript.add(data.getName());
            }
            if (listScript.contains(name) && uiForm.isAddNew_) {
                Object[] args = new Object[]{name};
                uiApp.addMessage(new ApplicationMessage("UIScriptForm.msg.name-exist", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            boolean isEnableVersioning = uiForm.getUIFormCheckBoxInput(UIScriptForm.FIELD_ENABLE_VERSION).isChecked();
            if (uiForm.isAddNew_ || !isEnableVersioning) {
                try {
                    scriptService.addScript(namePrefix + "/" + name, content, WCMCoreUtils.getUserSessionProvider());
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UIECMAdminControlPanel.msg.access-denied", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            try {
                Node node = curentList.getScriptNode(name);
                if (!node.isNodeType("mix:versionable")) {
                    node.addMixin("mix:versionable");
                } else {
                    node.checkout();
                }
                scriptService.addScript(namePrefix + "/" + name, content, WCMCoreUtils.getUserSessionProvider());
                node.save();
                node.checkin();
            }
            catch (PathNotFoundException pathNotFoundException) {
                Object[] args = new Object[]{namePrefix};
                uiApp.addMessage(new ApplicationMessage("UIScriptForm.msg.PathNotFoundException", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiForm.reset();
            if (uiForm.getId().equals(UIECMScripts.SCRIPTFORM_NAME)) {
                ((UIECMScripts)uiManager.getChild(UIECMScripts.class)).removeChildById("ECMScriptPopupWindow");
            } else {
                ((UICBScripts)uiManager.getChild(UICBScripts.class)).removeChildById("BCScriptPopupWindow");
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)curentList);
            curentList.refresh(1);
            event.getRequestContext().addUIComponentToUpdateByAjax(curentList.getParent());
        }
    }
}

