/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionInfo.msg.confirm-delete-permission"), @EventConfig(listeners={EditActionListener.class})})
public class UIPermissionInfo
extends UIContainer {
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups", "read", "addNode", "setProperty", "remove"};
    private static String[] PERMISSION_ACTION = new String[]{"Edit", "Delete"};
    private NodeLocation currentNode = null;
    private int sizeOfListPermission = 0;

    public UIPermissionInfo() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, "PermissionInfo");
        this.addChild((UIComponent)uiGrid);
        uiGrid.getUIPageIterator().setId("PermissionInfoIterator");
        uiGrid.configure("usersOrGroups", PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    private String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner((Node)node);
    }

    public void updateGrid() throws Exception {
        ArrayList<PermissionBean> permBeans = new ArrayList<PermissionBean>();
        ExtendedNode node = (ExtendedNode)this.getCurrentNode();
        List permsList = node.getACL().getPermissionEntries();
        HashMap permsMap = new HashMap();
        for (AccessControlEntry accessControlEntry : permsList) {
            String currentIdentity = accessControlEntry.getIdentity();
            String currentPermission = accessControlEntry.getPermission();
            ArrayList<String> currentPermissionsList = (ArrayList<String>)permsMap.get(currentIdentity);
            if (!permsMap.containsKey(currentIdentity)) {
                permsMap.put(currentIdentity, null);
            }
            if (currentPermissionsList == null) {
                currentPermissionsList = new ArrayList<String>();
            }
            if (!currentPermissionsList.contains(currentPermission)) {
                currentPermissionsList.add(currentPermission);
            }
            permsMap.put(currentIdentity, currentPermissionsList);
        }
        Set keys = permsMap.keySet();
        Iterator keysIter = keys.iterator();
        String owner = IdentityConstants.SYSTEM;
        int iSystemOwner = 0;
        if (this.getExoOwner((Node)node) != null) {
            owner = this.getExoOwner((Node)node);
        }
        if (owner.equals(IdentityConstants.SYSTEM)) {
            iSystemOwner = -1;
        }
        PermissionBean permOwnerBean = new PermissionBean();
        if (!permsMap.containsKey(owner)) {
            permOwnerBean.setUsersOrGroups(owner);
            permOwnerBean.setRead(true);
            permOwnerBean.setAddNode(true);
            permOwnerBean.setSetProperty(true);
            permOwnerBean.setRemove(true);
            permBeans.add(permOwnerBean);
        }
        while (keysIter.hasNext()) {
            String userOrGroup = (String)keysIter.next();
            List permissions = (List)permsMap.get(userOrGroup);
            PermissionBean permBean = new PermissionBean();
            permBean.setUsersOrGroups(userOrGroup);
            for (String perm : permissions) {
                if ("read".equals(perm)) {
                    permBean.setRead(true);
                    continue;
                }
                if ("add_node".equals(perm)) {
                    permBean.setAddNode(true);
                    continue;
                }
                if ("set_property".equals(perm)) {
                    permBean.setSetProperty(true);
                    continue;
                }
                if (!"remove".equals(perm)) continue;
                permBean.setRemove(true);
            }
            permBeans.add(permBean);
        }
        this.sizeOfListPermission = permBeans.size() + iSystemOwner;
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        ListAccessImpl permList = new ListAccessImpl(PermissionBean.class, permBeans);
        LazyPageList dataPageList = new LazyPageList((ListAccess)permList, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)dataPageList);
    }

    private Session getSession() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String systemWorkspace = repositoryService.getCurrentRepository().getConfiguration().getSystemWorkspaceName();
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Session session = WCMCoreUtils.getSystemSessionProvider().getSession(systemWorkspace, manageableRepository);
        return session;
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)currentNode);
    }

    public int getSizeOfListPermission() {
        return this.sizeOfListPermission;
    }

    public void setSizeOfListPermission(int sizeOfListPermission) {
        this.sizeOfListPermission = sizeOfListPermission;
    }

    public class PermissionBean {
        private String usersOrGroups;
        private boolean read;
        private boolean addNode;
        private boolean setProperty;
        private boolean remove;

        public String getUsersOrGroups() {
            return this.usersOrGroups;
        }

        public void setUsersOrGroups(String s) {
            this.usersOrGroups = s;
        }

        public boolean isAddNode() {
            return this.addNode;
        }

        public void setAddNode(boolean b) {
            this.addNode = b;
        }

        public boolean isRead() {
            return this.read;
        }

        public void setRead(boolean b) {
            this.read = b;
        }

        public boolean isRemove() {
            return this.remove;
        }

        public void setRemove(boolean b) {
            this.remove = b;
        }

        public boolean isSetProperty() {
            return this.setProperty;
        }

        public void setSetProperty(boolean b) {
            this.setProperty = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIPermissionInfo> {
        public void execute(Event<UIPermissionInfo> event) throws Exception {
            UIPermissionInfo uicomp = (UIPermissionInfo)((Object)event.getSource());
            Node currentNode = uicomp.getCurrentNode();
            ExtendedNode node = (ExtendedNode)currentNode;
            String owner = IdentityConstants.SYSTEM;
            int iSystemOwner = 0;
            if (uicomp.getExoOwner((Node)node) != null) {
                owner = uicomp.getExoOwner((Node)node);
            }
            if (owner.equals(IdentityConstants.SYSTEM)) {
                iSystemOwner = -1;
            }
            String name = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            if (uicomp.getSizeOfListPermission() < 2 + iSystemOwner) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-remove", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String nodeOwner = Utils.getNodeOwner((Node)node);
            if (name.equals(nodeOwner)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-remove", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (PermissionUtil.canChangePermission((Node)node)) {
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                    node.setPermission(nodeOwner, PermissionType.ALL);
                    node.save();
                }
                try {
                    node.removePermission(name);
                    node.save();
                }
                catch (AccessDeniedException ace) {
                    uicomp.getSession().refresh(false);
                    uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.access-denied", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-tochange", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            Session session = uicomp.getSession();
            session.save();
            session.refresh(false);
            UIPopupContainer uiPopup = (UIPopupContainer)uicomp.getAncestorOfType(UIPopupContainer.class);
            if (!PermissionUtil.canRead((Node)node)) {
                uiPopup.deActivate();
            } else {
                uicomp.updateGrid();
                event.getRequestContext().addUIComponentToUpdateByAjax(uicomp.getParent());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIPermissionInfo> {
        public void execute(Event<UIPermissionInfo> event) throws Exception {
            UIPermissionInfo uicomp = (UIPermissionInfo)((Object)event.getSource());
            String name = event.getRequestContext().getRequestParameter("objectId");
            Node updateNode = uicomp.getCurrentNode();
            ExtendedNode node = (ExtendedNode)updateNode;
            UIPermissionForm uiForm = (UIPermissionForm)((UIPermissionManager)uicomp.getAncestorOfType(UIPermissionManager.class)).getChild(UIPermissionForm.class);
            uiForm.fillForm(name, node);
            uiForm.lockForm(name.equals(uicomp.getExoOwner((Node)node)));
        }
    }
}

