/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.javascript;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.picocontainer.Startable;

public class XJavascriptService
implements Startable {
    private static String SHARED_JS_QUERY = "select * from exo:jsFile where jcr:path like '{path}/%' and exo:active='true' and exo:sharedJS='true' and jcr:mixinTypes <> 'exo:restoreLocation' " + "order by exo:priority ASC".intern();
    private static String WEBCONTENT_JS_QUERY = "select * from exo:jsFile where jcr:path like '{path}/%' and exo:active='true' " + "order by exo:priority ASC".intern();
    private final String MODULE_NAME = "eXo.WCM.Live".intern();
    private final String PATH = "/javascript/eXo/{portalName}/live".intern();
    private JavascriptConfigService jsConfigService;
    private WCMConfigurationService configurationService;
    private WebSchemaConfigService schemaConfigService;
    private ServletContext sContext;
    private Log log = ExoLogger.getLogger((String)"wcm:XJavascriptService");

    public XJavascriptService() throws Exception {
        this.jsConfigService = WCMCoreUtils.getService(JavascriptConfigService.class);
        this.sContext = WCMCoreUtils.getService(ServletContext.class);
        this.schemaConfigService = WCMCoreUtils.getService(WebSchemaConfigService.class);
        this.configurationService = WCMCoreUtils.getService(WCMConfigurationService.class);
    }

    public String getActiveJavaScript(Node webcontent) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String jsQuery = StringUtils.replaceOnce((String)WEBCONTENT_JS_QUERY, (String)"{path}", (String)webcontent.getPath());
        NodeLocation webcontentLocation = NodeLocation.getNodeLocationByNode(webcontent);
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        Session session = null;
        session = webcontentLocation.getPath().startsWith("/jcr:system") ? repository.getSystemSession(repository.getConfiguration().getSystemWorkspaceName()) : repository.getSystemSession(webcontentLocation.getWorkspace());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(jsQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        while (iterator.hasNext()) {
            Node registeredJSFile = iterator.nextNode();
            buffer.append(this.getActivedJSData(registeredJSFile));
        }
        session.logout();
        return buffer.toString();
    }

    public void updatePortalJSOnModify(Node portalNode, Node jsFile) throws Exception {
        String repository = ((ManageableRepository)portalNode.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portalNode.getName())) {
            this.addSharedPortalJavascript(portalNode, jsFile, false);
        } else {
            this.addPortalJavascript(portalNode, jsFile, false);
        }
    }

    public void updatePortalJSOnRemove(Node portalNode, Node jsFile) throws Exception {
        String repository = ((ManageableRepository)portalNode.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portalNode.getName())) {
            this.addSharedPortalJavascript(portalNode, jsFile, false);
        } else {
            this.addPortalJavascript(portalNode, jsFile, false);
        }
    }

    private void addPortalJavascript(Node portalNode, Node jsFile, boolean isStartup) throws Exception {
        String javascriptPath = StringUtils.replaceOnce((String)this.PATH, (String)"{portalName}", (String)portalNode.getName());
        String jsData = this.mergeJSData(portalNode, jsFile, isStartup);
        if (this.jsConfigService.isModuleLoaded((CharSequence)this.MODULE_NAME)) {
            this.jsConfigService.removeExtendedJavascript(this.MODULE_NAME, javascriptPath, this.sContext);
        }
        this.jsConfigService.addExtendedJavascript(this.MODULE_NAME, javascriptPath, this.sContext, jsData);
    }

    private void addSharedPortalJavascript(Node portalNode, Node jsFile, boolean isStartup) throws Exception {
        String javascriptPath = StringUtils.replaceOnce((String)this.PATH, (String)"{portalName}", (String)portalNode.getName());
        String jsData = this.mergeJSData(portalNode, jsFile, isStartup);
        if (this.jsConfigService.isModuleLoaded((CharSequence)this.MODULE_NAME)) {
            this.jsConfigService.removeExtendedJavascript(this.MODULE_NAME, javascriptPath, this.sContext);
        }
        this.jsConfigService.addExtendedJavascript(this.MODULE_NAME, javascriptPath, this.sContext, jsData);
    }

    private String mergeJSData(Node portalNode, Node newJSFile, boolean isStartup) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Node jsFolder = this.schemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class).getJSFolder(portalNode);
        String statement = StringUtils.replaceOnce((String)SHARED_JS_QUERY, (String)"{path}", (String)jsFolder.getPath());
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        NodeLocation portalNodeLocation = NodeLocation.getNodeLocationByNode(portalNode);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(portalNodeLocation.getWorkspace(), repository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        QueryResult queryResult = null;
        Query query = queryManager.createQuery(statement, "sql");
        queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        if (isStartup) {
            while (iterator.hasNext()) {
                Node registeredJSFile = iterator.nextNode();
                buffer.append(this.getActivedJSData(registeredJSFile));
            }
        } else if (!iterator.hasNext()) {
            buffer.append(this.getActivedJSData(newJSFile));
        } else {
            boolean isApplied = false;
            while (iterator.hasNext()) {
                Node registeredJSFile = iterator.nextNode();
                if (newJSFile != null) {
                    if (!isApplied && newJSFile.getPath().equals(registeredJSFile.getPath())) {
                        buffer.append(this.getActivedJSData(newJSFile));
                        isApplied = true;
                        continue;
                    }
                    long newJSFilePriority = newJSFile.getProperty("exo:priority").getLong();
                    long registeredJSFilePriority = registeredJSFile.getProperty("exo:priority").getLong();
                    if (!isApplied && newJSFilePriority < registeredJSFilePriority) {
                        buffer.append(this.getActivedJSData(newJSFile));
                        isApplied = true;
                    }
                }
                buffer.append(this.getActivedJSData(registeredJSFile));
            }
            if (!isApplied) {
                buffer.append(this.getActivedJSData(newJSFile));
            }
        }
        sessionProvider.close();
        return buffer.toString();
    }

    private String getActivedJSData(Node jsFile) throws ValueFormatException, RepositoryException, PathNotFoundException {
        if (jsFile != null && !jsFile.isNodeType("exo:restoreLocation") && jsFile.hasNode("jcr:content") && jsFile.getNode("jcr:content").hasProperty("jcr:data") && jsFile.hasProperty("exo:active") && jsFile.getProperty("exo:active").getBoolean()) {
            return jsFile.getNode("jcr:content").getProperty("jcr:data").getString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
            Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
            this.addSharedPortalJavascript(sharedPortal, null, true);
            List<Node> livePortals = livePortalManagerService.getLivePortals(sessionProvider);
            for (Node portal : livePortals) {
                this.addPortalJavascript(portal, null, true);
            }
        }
        catch (PathNotFoundException e) {
            this.log.warn((Object)"Exception when merging inside Portal : WCM init is not completed.");
        }
        catch (Exception e) {
            this.log.error((Object)"Exception when start XJavascriptService");
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

