/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.TemplateConfig;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageViewPlugin
extends BaseComponentPlugin {
    private static String CB_PATH_TEMPLATE = "pathTemplate";
    private static String CB_QUERY_TEMPLATE = "queryTemplate";
    private static String CB_DETAIL_VIEW_TEMPLATE = "detailViewTemplate";
    private static String CB_SCRIPT_TEMPLATE = "scriptTemplate";
    private static String ECM_EXPLORER_TEMPLATE = "ecmExplorerTemplate";
    private InitParams params_;
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private ConfigurationManager cservice_;
    private boolean autoCreateInNewRepository_ = false;
    private String predefinedViewsLocation_ = "war:/conf/dms/artifacts";
    private DMSConfiguration dmsConfiguration_;
    private TemplateService templateService;
    private Set<String> configuredTemplate_;
    private Set<String> configuredViews_;

    public ManageViewPlugin(RepositoryService repositoryService, InitParams params, ConfigurationManager cservice, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration) throws Exception {
        ValueParam predefinedViewLocation;
        this.params_ = params;
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.cservice_ = cservice;
        ValueParam autoInitParam = params.getValueParam("autoCreateInNewRepository");
        if (autoInitParam != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(autoInitParam.getValue());
        }
        if ((predefinedViewLocation = params.getValueParam("predefinedViewsLocation")) != null) {
            this.predefinedViewsLocation_ = predefinedViewLocation.getValue();
        }
        this.dmsConfiguration_ = dmsConfiguration;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    public void init() throws Exception {
        if (this.autoCreateInNewRepository_) {
            this.importPredefineViews();
            return;
        }
    }

    @Deprecated
    public void init(String repository) throws Exception {
        if (!this.autoCreateInNewRepository_) {
            return;
        }
        this.importPredefineViews();
    }

    private void importPredefineViews() throws Exception {
        this.configuredTemplate_ = new HashSet<String>();
        this.configuredViews_ = new HashSet<String>();
        Iterator it = this.params_.getObjectParamIterator();
        String viewsPath = this.nodeHierarchyCreator_.getJcrPath("userViewsPath");
        String templatesPath = this.nodeHierarchyCreator_.getJcrPath("viewTemplatesPath");
        String warViewPath = this.predefinedViewsLocation_ + templatesPath.substring(templatesPath.lastIndexOf("exo:ecm") + 7);
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        Session session = manageableRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
        ViewConfig viewObject = null;
        TemplateConfig templateObject = null;
        Node viewHomeNode = (Node)session.getItem(viewsPath);
        while (it.hasNext()) {
            Object object = ((ObjectParameter)it.next()).getObject();
            if (object instanceof ViewConfig) {
                viewObject = (ViewConfig)object;
                String viewNodeName = viewObject.getName();
                this.configuredViews_.add(viewNodeName);
                if (viewHomeNode.hasNode(viewNodeName)) continue;
                Node viewNode = this.addView(viewHomeNode, viewNodeName, viewObject.getPermissions(), viewObject.getTemplate());
                for (ViewConfig.Tab tab : viewObject.getTabList()) {
                    this.addTab(viewNode, tab.getTabName(), tab.getButtons());
                }
                continue;
            }
            if (!(object instanceof TemplateConfig)) continue;
            templateObject = (TemplateConfig)object;
            this.addTemplate(templateObject, session, warViewPath);
            this.configuredTemplate_.add(templateObject.getName());
        }
        session.save();
        session.logout();
    }

    private Node addView(Node viewManager, String name, String permissions, String template) throws Exception {
        Node contentNode = viewManager.addNode(name, "exo:view");
        contentNode.setProperty("exo:accessPermissions", permissions);
        contentNode.setProperty("exo:template", template);
        viewManager.save();
        return contentNode;
    }

    private void addTab(Node view, String name, String buttons) throws Exception {
        Node tab = view.hasNode(name) ? view.getNode(name) : view.addNode(name, "exo:tab");
        tab.setProperty("exo:buttons", buttons);
        view.save();
    }

    private void addTemplate(TemplateConfig tempObject, Session session, String warViewPath) throws Exception {
        String type = tempObject.getTemplateType();
        String alias = "";
        if (type.equals(ECM_EXPLORER_TEMPLATE)) {
            alias = "ecmExplorerTemplates";
        } else if (type.equals(CB_PATH_TEMPLATE)) {
            alias = "cbPathTemplates";
        } else if (type.equals(CB_QUERY_TEMPLATE)) {
            alias = "cbQueryTemplates";
        } else if (type.equals(CB_SCRIPT_TEMPLATE)) {
            alias = "cbScriptTemplates";
        } else if (type.equals(CB_DETAIL_VIEW_TEMPLATE)) {
            alias = "cbDetaiViewTemplates";
        }
        String templateHomePath = this.nodeHierarchyCreator_.getJcrPath(alias);
        Node templateHomeNode = (Node)session.getItem(templateHomePath);
        String templateName = tempObject.getName();
        if (templateHomeNode.hasNode(templateName)) {
            return;
        }
        String warPath = warViewPath + tempObject.getWarPath();
        InputStream in = this.cservice_.getInputStream(warPath);
        this.templateService.createTemplate(templateHomeNode, templateName, in, new String[]{"*"});
    }

    public Set<String> getConfiguredTemplates() {
        return this.configuredTemplate_;
    }

    public Set<String> getConfiguredViews() {
        return this.configuredViews_;
    }
}

