/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.xcmis.search.content.Schema;
import org.xcmis.search.lucene.content.VirtualTableResolver;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.value.NameConverter;

public class SchemaTableResolver
implements VirtualTableResolver<Query> {
    private final NameConverter nameConverter;
    private final Schema schema;

    public SchemaTableResolver(NameConverter nameConverter, Schema schema) {
        this.nameConverter = nameConverter;
        this.schema = schema;
    }

    @Override
    public Query resolve(String tableName, boolean includeInheritedTables) {
        ArrayList<Term> terms = new ArrayList<Term>();
        BooleanQuery query = null;
        terms.add(new Term(FieldNames.TABLE_NAME, this.nameConverter.convertName(tableName)));
        if (includeInheritedTables) {
            Set<String> allTypes = this.getSubTypes(tableName);
            for (String descendantNt : allTypes) {
                terms.add(new Term(FieldNames.TABLE_NAME, this.nameConverter.convertName(descendantNt)));
            }
        }
        if (terms.size() == 0) {
            query = new BooleanQuery();
        } else if (terms.size() == 1) {
            query = new TermQuery((Term)terms.get(0));
        } else {
            BooleanQuery b = new BooleanQuery();
            for (Term element : terms) {
                b.add((Query)new TermQuery(element), BooleanClause.Occur.SHOULD);
            }
            query = b;
        }
        return query;
    }

    protected Set<String> getSubTypes(String tableName) {
        return Collections.emptySet();
    }
}

