/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.deployment;

import javax.jcr.Node;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public abstract class DeploymentPlugin
implements ComponentPlugin {
    protected InitParams initParams;
    private String name;
    private String desc;

    public DeploymentPlugin() {
    }

    public DeploymentPlugin(InitParams initParams) {
        this.initParams = initParams;
    }

    public abstract void deploy(SessionProvider var1) throws Exception;

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String s) {
        this.desc = s;
    }

    public boolean isOverride() {
        ValueParam overrideParam = this.initParams.getValueParam("override");
        return overrideParam != null && Boolean.parseBoolean(overrideParam.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deployed() {
        SessionProvider sessionProvider = null;
        try {
            boolean ret;
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = WCMCoreUtils.getRepository();
            Node serviceFolder = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository).getRootNode().getNode("exo:services");
            Node contentInitializerService = serviceFolder.hasNode("WCMContentInitializerService") ? serviceFolder.getNode("WCMContentInitializerService") : serviceFolder.addNode("WCMContentInitializerService", "nt:unstructured");
            ValueParam siteNameParam = this.initParams.getValueParam("siteName");
            boolean bl = ret = siteNameParam == null || contentInitializerService.hasNode(siteNameParam.getValue());
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public String getSiteName() {
        ValueParam siteName = this.initParams.getValueParam("siteName");
        return siteName == null ? null : siteName.getValue();
    }
}

