/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class DB2SingleDbJDBCConnection
extends SingleDbJDBCConnection {
    public DB2SingleDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_SVALUE V, JCR_SITEM P join (select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_SITEM I where I.CONTAINER_NAME=? AND I.I_CLASS=1 AND I.ID > ? order by I.ID FETCH FIRST $rowNb ROWS ONLY) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and V.PROPERTY_ID=P.ID order by J.ID";
        this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SVALUE V, JCR_SITEM P  join (select J.* from JCR_SITEM J where J.CONTAINER_NAME=? AND J.I_CLASS=1 and J.PARENT_ID=? AND J.N_ORDER_NUM  >= ? order by J.N_ORDER_NUM, J.ID FETCH FIRST $rowNb ROWS ONLY) I on P.PARENT_ID = I.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "VALUES NEXT VALUE FOR JCR_SITEM_SEQ";
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.FIND_NODES_AND_PROPERTIES = this.FIND_NODES_AND_PROPERTIES.replace("$rowNb", Integer.toString(limit));
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setString(1, this.containerName);
        this.findNodesAndProperties.setString(2, this.getInternalId(lastNodeId));
        this.findNodesAndProperties.setString(3, this.containerName);
        return this.findNodesAndProperties.executeQuery();
    }

    protected ResultSet findLastOrderNumberByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findLastOrderNumberByParentId == null) {
            this.findLastOrderNumberByParentId = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER_BY_PARENTID);
        }
        return this.findLastOrderNumberByParentId.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public int getLastOrderNumber(NodeData parent) throws RepositoryException {
        this.checkIfOpened();
        try {
            int n;
            ResultSet count = this.findLastOrderNumberByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            if (!count.next()) break block9;
            int n2 = count.getInt(1) - 1;
            Object var5_6 = null;
            try {
                count.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            {
                block9: {
                    return n2;
                }
                n = -1;
            }
            Object var5_7 = null;
            try {
                count.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return n;
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    count.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int toOrderNum) throws SQLException {
        if (this.findNodesByParentIdLazilyCQ == null) {
            int page = toOrderNum - fromOrderNum + 1;
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = this.FIND_NODES_BY_PARENTID_LAZILY_CQ.replace("$rowNb", Integer.toString(page));
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ);
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, this.containerName);
        this.findNodesByParentIdLazilyCQ.setString(2, parentCid);
        this.findNodesByParentIdLazilyCQ.setInt(3, fromOrderNum);
        this.findNodesByParentIdLazilyCQ.setString(4, this.containerName);
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteLockProperties() throws SQLException {
        SQLException e22;
        Statement removeItemsStatement;
        block11: {
            PreparedStatement removeValuesStatement = null;
            removeItemsStatement = null;
            try {
                removeValuesStatement = this.dbConnection.prepareStatement("DELETE FROM JCR_SVALUE WHERE PROPERTY_ID IN (SELECT ID FROM JCR_SITEM WHERE  I_CLASS = 2 AND CONTAINER_NAME = ? AND (NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner'))");
                removeValuesStatement.setString(1, this.containerName);
                removeItemsStatement = this.dbConnection.prepareStatement("DELETE FROM JCR_SITEM WHERE  I_CLASS = 2 AND CONTAINER_NAME = ? AND (NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner')");
                removeItemsStatement.setString(1, this.containerName);
                removeValuesStatement.executeUpdate();
                removeItemsStatement.executeUpdate();
                Object var4_3 = null;
                if (removeValuesStatement == null) break block11;
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var4_4 = null;
                if (removeValuesStatement != null) {
                    try {
                        removeValuesStatement.close();
                    }
                    catch (SQLException e22) {
                        LOG.error((Object)"Can't close statement", (Throwable)e22);
                    }
                }
                if (removeItemsStatement != null) {
                    try {
                        removeItemsStatement.close();
                    }
                    catch (SQLException e22) {
                        LOG.error((Object)"Can't close statement", (Throwable)e22);
                    }
                }
                throw throwable;
            }
            try {
                removeValuesStatement.close();
            }
            catch (SQLException e22) {
                LOG.error((Object)"Can't close statement", (Throwable)e22);
            }
        }
        if (removeItemsStatement != null) {
            try {
                removeItemsStatement.close();
            }
            catch (SQLException e22) {
                LOG.error((Object)"Can't close statement", (Throwable)e22);
            }
        }
    }
}

