/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.Depth;
import org.exoplatform.services.jcr.webdav.command.deltav.report.VersionTreeResponseEntity;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionedCollectionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedResource;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.ReportCommand");

    public Response report(Session session, String path, HierarchicalProperty body, Depth depth, String baseURI) {
        try {
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            String strUri = baseURI + node.getPath();
            URI uri = new URI(TextUtil.escape(strUri, '%', true));
            if (!ResourceUtil.isVersioned(node)) {
                return Response.status((int)412).build();
            }
            GenericResource resource = ResourceUtil.isFile(node) ? new VersionedFileResource(uri, node, nsContext) : new VersionedCollectionResource(uri, node, nsContext);
            Set<QName> properties = this.getProperties(body);
            VersionTreeResponseEntity response = new VersionTreeResponseEntity(nsContext, (VersionedResource)((Object)resource), properties);
            return Response.status((int)207).entity((Object)response).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    protected Set<QName> getProperties(HierarchicalProperty body) {
        HashSet<QName> properties = new HashSet<QName>();
        HierarchicalProperty prop = body.getChild(new QName("DAV:", "prop"));
        if (prop == null) {
            return properties;
        }
        for (int i = 0; i < prop.getChildren().size(); ++i) {
            HierarchicalProperty property = prop.getChild(i);
            properties.add(property.getName());
        }
        return properties;
    }
}

