/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDrivesBrowser.gtmpl", events={@EventConfig(listeners={SelectRepoActionListener.class}), @EventConfig(listeners={SelectDriveActionListener.class})})
@Deprecated
public class UIDrivesBrowser
extends UIContainer {
    public static final String FIELD_SELECTREPO = "selectRepo";
    private String repoName_;
    private RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);

    public UIDrivesBrowser() throws Exception {
        this.repoName_ = this.rService.getCurrentRepository().getConfiguration().getName();
    }

    public List<String> getRepositoryList() {
        ArrayList<String> repositories = new ArrayList<String>();
        RepositoryEntry re = null;
        try {
            re = this.rService.getCurrentRepository().getConfiguration();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        repositories.add(re.getName());
        return repositories;
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRepository() {
        return this.repoName_;
    }

    public void setRepository(String repoName) {
        this.repoName_ = repoName;
    }

    public List<DriveData> generalDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getMainDrives(userId, userRoles);
    }

    public List<DriveData> groupDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List groups = org.exoplatform.ecm.webui.utils.Utils.getGroups();
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getGroupDrives(userId, userRoles, groups);
    }

    public List<DriveData> personalDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getPersonalDrives(userId, userRoles);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectDriveActionListener
    extends EventListener<UIDrivesBrowser> {
        public void execute(Event<UIDrivesBrowser> event) throws Exception {
            UIDrivesBrowser uiDrive = (UIDrivesBrowser)((Object)event.getSource());
            String driveName = event.getRequestContext().getRequestParameter("objectId");
            RepositoryService rservice = (RepositoryService)uiDrive.getApplicationComponent(RepositoryService.class);
            ManageDriveService dservice = (ManageDriveService)uiDrive.getApplicationComponent(ManageDriveService.class);
            DriveData drive = dservice.getDriveByName(driveName);
            String userId = Util.getPortalRequestContext().getRemoteUser();
            UIApplication uiApp = (UIApplication)uiDrive.getAncestorOfType(UIApplication.class);
            ArrayList<String> viewList = new ArrayList<String>();
            for (String role : org.exoplatform.ecm.webui.utils.Utils.getMemberships()) {
                for (String viewName : drive.getViews().split(",")) {
                    if (viewList.contains(viewName.trim())) continue;
                    Node viewNode = ((ManageViewService)uiDrive.getApplicationComponent(ManageViewService.class)).getViewByName(viewName.trim(), WCMCoreUtils.getSystemSessionProvider());
                    String permiss = viewNode.getProperty("exo:accessPermissions").getString();
                    if (permiss.contains("${userId}")) {
                        permiss = permiss.replace("${userId}", userId);
                    }
                    String[] viewPermissions = permiss.split(",");
                    if (permiss.equals("*")) {
                        viewList.add(viewName.trim());
                    }
                    if (!drive.hasPermission(viewPermissions, role)) continue;
                    viewList.add(viewName.trim());
                }
            }
            if (viewList.isEmpty()) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.no-view-found", args));
                return;
            }
            String viewListStr = "";
            for (String viewName : viewList) {
                if (viewListStr.length() > 0) {
                    viewListStr = viewListStr + "," + viewName;
                    continue;
                }
                viewListStr = viewName;
            }
            drive.setViews(viewListStr);
            String homePath = drive.getHomePath();
            if (homePath.contains("${userId}")) {
                homePath = Utils.getPersonalDrivePath((String)homePath, (String)userId);
            }
            UIJCRExplorerPortlet uiParent = (UIJCRExplorerPortlet)uiDrive.getAncestorOfType(UIJCRExplorerPortlet.class);
            uiParent.setFlagSelect(true);
            UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)uiParent.getChild(UIJcrExplorerContainer.class);
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class);
            Preference pref = uiJCRExplorer.getPreference();
            pref.setShowSideBar(drive.getViewSideBar());
            pref.setShowNonDocumentType(drive.getViewNonDocument());
            pref.setShowPreferenceDocuments(drive.getViewPreferences());
            pref.setAllowCreateFoder(drive.getAllowCreateFolders());
            pref.setShowHiddenNode(drive.getShowHiddenNode());
            uiJCRExplorer.setDriveData(drive);
            uiJCRExplorer.setIsReferenceNode(false);
            SessionProvider provider = WCMCoreUtils.getUserSessionProvider();
            ManageableRepository repository = rservice.getCurrentRepository();
            try {
                Session session = provider.getSession(drive.getWorkspace(), repository);
                session.getItem(homePath);
            }
            catch (AccessDeniedException ace) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.access-denied", args, 1));
                return;
            }
            catch (NoSuchWorkspaceException nosuchWS) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.workspace-not-exist", args, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            uiJCRExplorer.clearNodeHistory(homePath);
            uiJCRExplorer.setRepositoryName(uiDrive.repoName_);
            uiJCRExplorer.setWorkspaceName(drive.getWorkspace());
            uiJCRExplorer.setRootPath(homePath);
            uiJCRExplorer.setSelectNode(drive.getWorkspace(), homePath);
            uiJCRExplorer.refreshExplorer();
            String selectedView = (String)viewList.get(0);
            UIControl uiControl = (UIControl)uiJCRExplorer.getChild(UIControl.class);
            UIActionBar uiActionbar = (UIActionBar)uiControl.getChild(UIActionBar.class);
            uiActionbar.setTabOptions(selectedView);
            UIAddressBar uiAddressBar = (UIAddressBar)uiControl.getChild(UIAddressBar.class);
            uiAddressBar.setViewList(viewList);
            uiAddressBar.setSelectedViewName(selectedView);
            explorerContainer.setRenderedChild(UIJCRExplorer.class);
            uiParent.setRenderedChild(UIJcrExplorerContainer.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectRepoActionListener
    extends EventListener<UIDrivesBrowser> {
        public void execute(Event<UIDrivesBrowser> event) throws Exception {
            String repoName = event.getRequestContext().getRequestParameter("objectId");
            UIDrivesBrowser uiDrivesBrowser = (UIDrivesBrowser)((Object)event.getSource());
            uiDrivesBrowser.setRepository(repoName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDrivesBrowser);
        }
    }
}

