/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.parser.Normalizer;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ParserBase {
    protected final JsTokenQueue tq;
    protected final MessageQueue mq;
    protected final boolean isQuasiliteral;
    private static final Pattern IDENTIFIER_OR_KEYWORD_RE;
    private static final Pattern QUASI_IDENTIFIER_OR_KEYWORD_RE;
    private static final Pattern UNICODE_ESCAPE;

    public ParserBase(JsTokenQueue tq, MessageQueue mq) {
        this(tq, mq, false);
    }

    public ParserBase(JsTokenQueue tq, MessageQueue mq, boolean isQuasiliteral) {
        this.tq = tq;
        this.mq = mq;
        this.isQuasiliteral = isQuasiliteral;
    }

    public JsTokenQueue getTokenQueue() {
        return this.tq;
    }

    public MessageQueue getMessageQueue() {
        return this.mq;
    }

    public String parseIdentifier(boolean allowReservedWords) throws ParseException {
        Token t = this.tq.peek();
        String s = t.text;
        switch ((JsTokenType)t.type) {
            case WORD: {
                if (this.isIdentifier(s)) break;
                throw new ParseException(new Message((MessageTypeInt)MessageType.INVALID_IDENTIFIER, this.tq.currentPosition(), MessagePart.Factory.valueOf(s)));
            }
            case KEYWORD: {
                if (allowReservedWords) break;
                this.mq.addMessage((MessageTypeInt)MessageType.RESERVED_WORD_USED_AS_IDENTIFIER, this.tq.currentPosition(), Keyword.fromString(s));
                break;
            }
            default: {
                throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, this.tq.currentPosition(), MessagePart.Factory.valueOf("an identifier"), MessagePart.Factory.valueOf(s)));
            }
        }
        this.tq.advance();
        return ParserBase.decodeIdentifier(s);
    }

    public static boolean isJavascriptIdentifier(String s) {
        return IDENTIFIER_OR_KEYWORD_RE.matcher(ParserBase.decodeIdentifier(s)).matches() && Normalizer.isNormalized(s);
    }

    public static boolean isQuasiIdentifier(String s) {
        return QUASI_IDENTIFIER_OR_KEYWORD_RE.matcher(ParserBase.decodeIdentifier(s)).matches() && Normalizer.isNormalized(s);
    }

    public boolean isIdentifier(String s) {
        return (this.isQuasiliteral ? QUASI_IDENTIFIER_OR_KEYWORD_RE : IDENTIFIER_OR_KEYWORD_RE).matcher(ParserBase.decodeIdentifier(s)).matches() && Normalizer.isNormalized(s);
    }

    public static String decodeIdentifier(String identifier) {
        if (identifier.indexOf(92) < 0) {
            return identifier;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = UNICODE_ESCAPE.matcher(identifier);
        while (m.find()) {
            m.appendReplacement(sb, "");
            sb.append((char)Integer.parseInt(m.group(1), 16));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static {
        String hexDigit = "[0-9a-fA-F]";
        String letter = "\\p{javaLetter}";
        String letterOrDigit = "\\p{javaLetterOrDigit}";
        String combinerOrConnector = "\\p{Mn}\\p{Mc}\\p{Pc}";
        String identifierStart = "[" + letter + "$_]";
        String identifierPart = "[" + letterOrDigit + combinerOrConnector + "$_]";
        String quasiliteralBegin = "@";
        String optQuasiliteralQuantifier = "[\\+\\*\\?]?";
        String identifierOrKeyword = identifierStart + identifierPart + "*";
        IDENTIFIER_OR_KEYWORD_RE = Pattern.compile("^" + identifierOrKeyword + "$");
        String quasiIdentifierOrKeyword = "(?:" + identifierOrKeyword + ")" + "|" + "(?:" + quasiliteralBegin + identifierOrKeyword + optQuasiliteralQuantifier + ")";
        QUASI_IDENTIFIER_OR_KEYWORD_RE = Pattern.compile("^" + quasiIdentifierOrKeyword + "$");
        UNICODE_ESCAPE = Pattern.compile("\\\\u(" + hexDigit + "{4})");
    }
}

