/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum TokenClassification {
    LINEBREAK,
    SPACE,
    STRING,
    REGEX,
    COMMENT,
    PUNCTUATION,
    OTHER;


    static TokenClassification classify(CharSequence text) {
        if ("".equals(text)) {
            return null;
        }
        char ch0 = text.charAt(0);
        if (ch0 == '\n' || ch0 == '\r') {
            return LINEBREAK;
        }
        if (ch0 == ' ') {
            return SPACE;
        }
        int n = text.length();
        if (n >= 2) {
            char ch1 = text.charAt(1);
            char chLast = text.charAt(n - 1);
            switch (ch0) {
                case '/': {
                    if (ch1 == '*') {
                        if (chLast != '/' || text.charAt(n - 2) != '*') {
                            throw new IllegalArgumentException();
                        }
                        return COMMENT;
                    }
                    if (ch1 == '/') {
                        if (chLast == '\\') {
                            throw new IllegalArgumentException();
                        }
                        return COMMENT;
                    }
                    if (n <= 2) break;
                    return REGEX;
                }
                case '+': 
                case '-': {
                    if (ch1 == '.') {
                        ch1 = n >= 3 ? text.charAt(2) : (char)'\u0000';
                    }
                }
                case '.': {
                    if (!Character.isLetterOrDigit(ch1)) break;
                    return OTHER;
                }
                case '\"': 
                case '\'': {
                    return STRING;
                }
            }
        }
        if (Character.isLetterOrDigit(ch0) || ch0 == '$' || ch0 == '_' || ch0 == '\\' && n >= 6 && 'u' == text.charAt(1)) {
            return OTHER;
        }
        return PUNCTUATION;
    }

    static boolean isNumber(String s) {
        int n = s.length();
        if (n == 0) {
            return false;
        }
        char ch = s.charAt(0);
        if (ch == '+' || ch == '-') {
            if (n == 1) {
                return false;
            }
            ch = s.charAt(1);
        }
        return ch >= '0' && ch <= '9';
    }

    static boolean isComment(String s) {
        if (s.length() < 2 || s.charAt(0) != '/') {
            return false;
        }
        switch (s.charAt(1)) {
            case '*': 
            case '/': {
                return true;
            }
        }
        return false;
    }

    static boolean isLineComment(String s) {
        return s.startsWith("//");
    }
}

