/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.Fact;
import com.google.caja.ancillary.opt.ParseTreeKB;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Literal;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Join;
import com.google.caja.util.Lists;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ParseTreeKBTest
extends CajaTestCase {
    List<Pair<Expression, Fact>> knowledge;
    ParseTreeKB kb;

    protected void setUp() throws Exception {
        super.setUp();
        this.knowledge = Lists.newArrayList();
        this.kb = new ParseTreeKB(){

            protected void putFact(Expression e, String digest, Fact f) {
                ParseTreeKBTest.this.knowledge.add(Pair.pair(e, f));
                super.putFact(e, digest, f);
            }
        };
        this.kb.finishInference();
        this.knowledge.clear();
    }

    public final void testTypeof1() throws Exception {
        this.addFact("typeof undefined", " 'undefined' ");
        this.assertFacts("(typeof undefined) IS 'undefined'");
        ParseTreeKBTest.assertEquals((String)"void 0", (String)ParseTreeKBTest.render(this.kb.getFact((Expression)this.jsExpr((CharProducer)this.fromString((String[])new String[]{"undefined"}))).value));
    }

    public final void testTypeof2() throws Exception {
        this.addFact("typeof window.JSON", " 'object' ");
        this.assertFacts("(typeof window.JSON) IS 'object'", "(window.JSON !== void 0) IS true", "(window.JSON === void 0) IS false", "(void 0 !== window.JSON) IS true", "(void 0 === window.JSON) IS false");
    }

    public final void testTypeof3() throws Exception {
        this.addFact("typeof window.JSON", " 'function' ");
        this.assertFacts("(typeof window.JSON) IS 'function'", "(window) LIKE true", "(window.JSON) LIKE true", "(window.JSON !== void 0) IS true", "(window.JSON === void 0) IS false", "(void 0 !== window.JSON) IS true", "(void 0 === window.JSON) IS false");
    }

    public final void testTypeof4() throws Exception {
        this.addFact("typeof window.JSON === 'object'", "true");
        this.assertFacts("(typeof window.JSON === 'object') IS true", "(typeof window.JSON == 'object') IS true", "('object' === typeof window.JSON) IS true", "('object' == typeof window.JSON) IS true", "(typeof window.JSON !== 'object') IS false", "(typeof window.JSON != 'object') IS false", "('object' !== typeof window.JSON) IS false", "('object' != typeof window.JSON) IS false", "(typeof window.JSON) IS 'object'", "(window.JSON !== void 0) IS true", "(window.JSON === void 0) IS false", "(void 0 !== window.JSON) IS true", "(void 0 === window.JSON) IS false");
    }

    public final void testTypeof5() throws Exception {
        this.addFact("typeof addEventListener", "'undefined'");
        this.addFact("!!this.window && window === this", "true");
        this.kb.finishInference();
        this.assertFacts("(window) LIKE this", "(! !this.window && window === this) IS true", "(! !this.window) IS true", "(!this.window) IS false", "(this.window) LIKE true", "(typeof addEventListener) IS 'undefined'", "(typeof this.addEventListener) IS 'undefined'", "(typeof window.addEventListener) IS 'undefined'", "(addEventListener) IS void 0", "(this.addEventListener) IS void 0", "(window.addEventListener) IS void 0", "(this != window) IS false", "(this !== window) IS false", "(this == window) IS true", "(this === window) IS true", "(window != this) IS false", "(window !== this) IS false", "(window == this) IS true", "(window === this) IS true", "(window.undefined) IS void 0");
    }

    public final void testNot1() throws Exception {
        this.addFact("!w", "true");
        this.addFact("!x", "false");
        this.addFuzzyFact("y", false);
        this.addFuzzyFact("z", true);
        this.assertFacts("(!w) IS true", "(!x) IS false", "(w) LIKE false", "(x) LIKE true", "(y) LIKE false", "(z) LIKE true");
    }

    public final void testNot2() throws Exception {
        this.addFuzzyFact("!(x || y)", true);
        this.assertFacts("(! (x || y)) IS true", "(x || y) LIKE false", "(x) LIKE false", "(y) LIKE false");
    }

    public final void testComparisons1() throws Exception {
        this.addFact("version < 5", "true");
        this.assertFacts("(version < 5) IS true", "(5 > version) IS true", "(version <= 5) IS true", "(5 >= version) IS true", "(version !== 5) IS true", "(version === 5) IS false", "(5 !== version) IS true", "(5 === version) IS false");
    }

    public final void testComparisons2() throws Exception {
        this.addFact("v >= 0", "false");
        this.assertFacts("(v >= 0) IS false", "(0 <= v) IS false", "(v !== 0) IS true", "(0 !== v) IS true", "(v === 0) IS false", "(0 === v) IS false");
    }

    public final void testComparisons3() throws Exception {
        this.addFact("version > ''", "false");
        this.assertFacts("(version > '') IS false", "('' < version) IS false");
    }

    public final void testComparisons4() throws Exception {
        this.addFact("v >= '7'", "true");
        this.assertFacts("(v >= '7') IS true", "('7' <= v) IS true");
    }

    public final void testComparisons5() throws Exception {
        this.addFact("len > 5", "true");
        this.assertFacts("(len > 5) IS true", "(5 < len) IS true", "(len >= 5) IS true", "(5 <= len) IS true", "(len !== 5) IS true", "(len === 5) IS false", "(5 !== len) IS true", "(5 === len) IS false");
    }

    public final void testInstanceof() throws Exception {
        this.addFact("a instanceof Foo", "true");
        this.addFact("b instanceof Bar", "false");
        this.assertFacts("(a instanceof Foo) IS true", "(b instanceof Bar) IS false", "(a) LIKE true", "(typeof Foo) IS 'function'", "(typeof Bar) IS 'function'", "(Foo) LIKE true", "(Bar) LIKE true", "(Foo !== void 0) IS true", "(Foo === void 0) IS false", "(void 0 !== Foo) IS true", "(void 0 === Foo) IS false", "(Bar !== void 0) IS true", "(Bar === void 0) IS false", "(void 0 !== Bar) IS true", "(void 0 === Bar) IS false");
    }

    public final void testEquivalence() throws Exception {
        this.addFact("a == null", "true");
        this.addFact("b == 3", "false");
        this.assertFacts("(a == null) IS true", "(null == a) IS true", "(a != null) IS false", "(null != a) IS false", "(b == 3) IS false", "(3 == b) IS false", "(b != 3) IS true", "(3 != b) IS true");
    }

    public final void testEquality() throws Exception {
        this.addFact("a === null", "true");
        this.addFact("b === 3", "false");
        this.assertFacts("(a === null) IS true", "(null === a) IS true", "(a == null) IS true", "(null == a) IS true", "(a !== null) IS false", "(null !== a) IS false", "(a != null) IS false", "(null != a) IS false", "(a) IS null", "(b === 3) IS false", "(3 === b) IS false", "(b !== 3) IS true", "(3 !== b) IS true");
    }

    public final void testAnd1() throws Exception {
        this.addFuzzyFact("a && b", true);
        this.addFuzzyFact("c && !d", false);
        this.assertFacts("(a) LIKE true", "(b) LIKE true", "(a && b) LIKE true", "(c && !d) LIKE false");
    }

    public final void testAnd2() throws Exception {
        this.addFact("a && b", "true");
        this.addFact("c && !d", "false");
        this.assertFacts("(a) LIKE true", "(b) IS true", "(a && b) IS true", "(c && !d) IS false");
    }

    public final void testDemorgans() throws Exception {
        this.addFuzzyFact("!(!a && !b)", false);
        this.assertFacts("(! (!a && !b)) IS false", "(!a && !b) IS true", "(!a) IS true", "(!b) IS true", "(a) LIKE false", "(b) LIKE false");
    }

    public final void testOperandSwitching1() throws Exception {
        this.addFact("a * b === 3", "true");
        this.assertFacts("(a * b) IS 3", "(b * a) IS 3", "(a * b === 3) IS true", "(a * b !== 3) IS false", "(a * b == 3) IS true", "(a * b != 3) IS false", "(3 === a * b) IS true", "(3 !== a * b) IS false", "(3 == a * b) IS true", "(3 != a * b) IS false");
    }

    public final void testNoOperandSwitching1() throws Exception {
        this.addFact("a + b === +x", "true");
        this.assertFacts("(a + b === +x) IS true", "(a + b !== +x) IS false", "(a + b == +x) IS true", "(a + b != +x) IS false", "(+x === a + b) IS true", "(+x !== a + b) IS false", "(+x == a + b) IS true", "(+x != a + b) IS false", "(typeof (a + b)) IS 'number'", "(a + b === void 0) IS false", "(a + b !== void 0) IS true", "(void 0 === a + b) IS false", "(void 0 !== a + b) IS true");
    }

    public final void testGlobalObject() throws Exception {
        this.addFact("this === global", "true");
        this.addFact("!global", "false");
        this.addFact("typeof addEventListener", "'function'");
        this.assertFacts(true, "(this != global) IS false", "(this !== global) IS false", "(this == global) IS true", "(this === global) IS true", "(global != this) IS false", "(global !== this) IS false", "(global == this) IS true", "(global === this) IS true", "(!global) IS false", "(global) LIKE this", "(global.undefined) IS void 0", "(typeof addEventListener) IS 'function'", "(addEventListener !== void 0) IS true", "(addEventListener === void 0) IS false", "(void 0 !== addEventListener) IS true", "(void 0 === addEventListener) IS false", "(addEventListener) LIKE true", "(typeof global.addEventListener) IS 'function'", "(global.addEventListener !== void 0) IS true", "(global.addEventListener === void 0) IS false", "(void 0 !== global.addEventListener) IS true", "(void 0 === global.addEventListener) IS false", "(global.addEventListener) LIKE true", "(typeof this.addEventListener) IS 'function'", "(this.addEventListener !== void 0) IS true", "(this.addEventListener === void 0) IS false", "(void 0 !== this.addEventListener) IS true", "(void 0 === this.addEventListener) IS false", "(this.addEventListener) LIKE true");
    }

    public final void testSpecialFloatingValues() throws Exception {
        this.addFact("NaN === NaN", "false");
        this.addFact("Infinity === 1/0", "true");
        this.addFact("NZERO", "-0");
        this.assertFacts("((1/0) === Infinity) IS true", "((1/0) !== Infinity) IS false", "((1/0) == Infinity) IS true", "((1/0) != Infinity) IS false", "(Infinity === (1/0)) IS true", "(Infinity !== (1/0)) IS false", "(Infinity == (1/0)) IS true", "(Infinity != (1/0)) IS false", "(Infinity) IS (1/0)", "(NZERO) IS (-0)", "(NaN !== NaN) IS true", "(NaN === NaN) IS false", "(NaN) IS (0/0)");
        ParseTreeKBTest.assertEquals((String)"{\n  alert((0/0), (1/0), (-1/0), (-1/0), (-0));\n}", (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("alert(NaN, Infinity, -Infinity, 1/NZERO, NZERO);")), this.mq)));
        this.assertNoErrors();
    }

    public final void testGlobalExistence() throws Exception {
        this.addFact("window === this", "true");
        this.addFact("!!window.addEventListener", "true");
        this.addFact("!window.attachEvent", "true");
        this.assertFacts(true, "(! !window.addEventListener) IS true", "(!window.addEventListener) IS false", "(!window.attachEvent) IS true", "(window.attachEvent) LIKE false", "(this != window) IS false", "(this !== window) IS false", "(this == window) IS true", "(this === window) IS true", "(window != this) IS false", "(window !== this) IS false", "(window == this) IS true", "(window === this) IS true", "(window.addEventListener) LIKE true", "(addEventListener) LIKE true", "(window.undefined) IS void 0", "(window) LIKE this");
        this.assertNoErrors();
    }

    public final void testReplacement() throws Exception {
        this.addFact("typeof JSON", "'undefined'");
        this.addFact("this === window", "'undefined'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("var oldJSON = void 0;JSON = { parse: null, stringify: null };"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("var oldJSON = window.JSON;window.JSON = { parse: null, stringify: null };")), this.mq)));
    }

    public final void testOptimizeOutSimpleConditional() throws Exception {
        this.addFact("typeof window.JSON", "'object'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("foo(); ; bar()"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("foo();if (typeof window.JSON === 'undefined') {  baz();}bar();")), this.mq)));
    }

    public final void testOptimizeOutMiddleConditional() throws Exception {
        this.addFact("typeof window.JSON", "'object'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("foo();if (typeof window.jsonParse) {  foo2();} else {  backup();}bar()"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("foo();if (typeof window.jsonParse) {  foo2();} else if (typeof window.JSON === 'undefined') {  baz();} else {  backup();}bar();")), this.mq)));
    }

    public final void testOptimizeOutTail() throws Exception {
        this.addFact("typeof window.JSON", "'object'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("foo();if (typeof window.jsonParse) {  foo2();} else {  baz();}bar()"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("foo();if (typeof window.jsonParse) {  foo2();} else if (typeof window.JSON === 'object') {  baz();} else {  backup();}bar();")), this.mq)));
    }

    public final void testOptimizeOutTailPreservingSideEffect() throws Exception {
        this.addFact("typeof window.JSON", "'object'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("foo();if (typeof window.jsonParse) {  foo2();} else {  foo();  baz();}bar()"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("foo();if (typeof window.jsonParse) {  foo2();} else if (foo() || typeof window.JSON === 'object') {  baz();} else {  backup();}bar();")), this.mq)));
    }

    public final void testOptimizeOutMiddlePreservingSideEffect() throws Exception {
        this.addFact("typeof window.JSON", "'undefined'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("foo();if (typeof window.jsonParse) {  foo2();} else {  foo();  backup();}bar()"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("foo();if (typeof window.jsonParse) {  foo2();} else if (foo() && typeof window.JSON === 'object') {  baz();} else {  backup();}bar();")), this.mq)));
    }

    public final void testLogicalOperatorsFuzzy1() throws Exception {
        this.addFact("foo", "0");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("var a = bar;var b = 0;if (bar) { baz(); };"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("var a = foo || bar;var b = foo && bar;if (foo || bar) { baz(); }if (foo && bar) { boo(); }")), this.mq)));
    }

    public final void testLogicalOperatorsFuzzy2() throws Exception {
        this.addFact("!foo", "true");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("var a = foo || bar;var b = foo && bar;if (bar) { baz(); };"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("var a = foo || bar;var b = foo && bar;if (foo || bar) { baz(); }if (foo && bar) { boo(); }")), this.mq)));
    }

    public final void testLogicalOperatorsFuzzy3() throws Exception {
        this.addFact("foo", "true");
        this.addFuzzyFact("baz", true);
        this.addFuzzyFact("boo", false);
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("{ bar(); }"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("if (foo ? baz : boo) { bar(); }")), this.mq)));
    }

    public final void testFoldingPreservesSideEffects() throws Exception {
        this.addFact("x", "false");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("foo();return bar(), baz();"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("if (void foo()) { boo(); }return (bar() && x) || baz()")), this.mq)));
    }

    public final void testPropertyNamesNotOptimized() throws Exception {
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("[void 0, window.undefined]"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("[undefined, window.undefined]")), this.mq)));
        this.kb.addFact(this.jsExpr(this.fromString("window.undefined")), Fact.UNDEFINED);
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("[void 0, void 0]"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("[undefined, window.undefined]")), this.mq)));
    }

    public final void testMemberAccess() throws Exception {
        this.addFact("navigator.userAgent", "\"Foo\\/Bar [Baz Compatible 1234] v5678\"");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("9"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("navigator.userAgent.indexOf('Baz')")), this.mq)));
    }

    public final void testLocalVariableReferences1() throws Exception {
        this.addFact("ZERO", "0");
        this.addFact("ONE", "1");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("[0, 1, (function (ONE) { return [0, ONE]; })]"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("[ZERO, ONE, (function (ONE) { return [ZERO, ONE]; })]")), this.mq)));
    }

    public final void testLocalVariableReferences2() throws Exception {
        this.addFact("ZERO", "0");
        this.addFact("ONE", "1");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("[0, 1, (function () {   try { throw 1; } catch (ONE) { return [0, ONE]; } })]"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("[ZERO, ONE, (function () {   try { throw ONE; } catch (ONE) { return [ZERO, ONE]; } })]")), this.mq)));
    }

    public final void testInlining1() throws Exception {
        this.addFact("/MSIE/.test(navigator.userAgent)", "true");
        this.addFuzzyFact("window.opera", false);
        this.addFact("/Firefox/.test(navigator.appName || '')", "false");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("function listen(n, t, fn) {  { n.attachEvent(t, fn); }}"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("function listen(n, t, fn) {  var isIE = /MSIE/.test(navigator.userAgent)      && !window.opera;  var isFF = /Firefox/.test(navigator.appName || '');  if (isIE) {    n.attachEvent(t, fn);  } else if (isFF) {    n.addEventListener(t, fn);  } else { throw new Error('forgot opera :('); }}")), this.mq)));
    }

    public final void testInlining2() throws Exception {
        this.addFact("/MSIE/.test(navigator.userAgent)", "false");
        this.addFuzzyFact("window.opera", false);
        this.addFact("/Firefox/.test(navigator.appName || '')", "true");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("function listen(n, t, fn) {  { n.addEventListener(t, fn); }}"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("function listen(n, t, fn) {  var isIE = /MSIE/.test(navigator.userAgent)      && !window.opera;  var isFF = /Firefox/.test(navigator.appName || '');  if (isIE) {    n.attachEvent(t, fn);  } else if (isFF) {    n.addEventListener(t, fn);  } else { throw new Error('forgot opera :('); }}")), this.mq)));
    }

    public final void testInlining3() throws Exception {
        this.addFact("/MSIE/.test(navigator.userAgent)", "true");
        this.addFact("window.opera", "true");
        this.addFact("/Firefox/.test(navigator.appName || '')", "false");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("function listen(n, t, fn) {  { throw new Error('forgot opera :('); }}"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("function listen(n, t, fn) {  var isIE = /MSIE/.test(navigator.userAgent)      && !window.opera;  var isFF = /Firefox/.test(navigator.appName || '');  if (isIE) {    n.attachEvent(t, fn);  } else if (isFF) {    n.addEventListener(t, fn);  } else { throw new Error('forgot opera :('); }}")), this.mq)));
    }

    public final void testTypeofKnowledge() throws Exception {
        this.addFact("typeof Date.prototype.toISOString", "'function'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString(";"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("if (Date.prototype.toISOString === void 0) {  Date.prototype.toISOString = Date.prototype.toJSON;}")), this.mq)));
    }

    public final void testHookOptimization() throws Exception {
        this.addFact("typeof Date.now", "'function'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("t = Date.now();"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("t = Date.now ? Date.now() : (new Date).getTime()")), this.mq)));
    }

    public final void testGlobalFolding1() throws Exception {
        this.addFact("typeof Date.now", "'function'");
        this.addFact("window === this", "'function'");
        this.checkGlobalFolding();
    }

    public final void testGlobalFolding2() throws Exception {
        this.addFact("typeof window.Date.now", "'function'");
        this.addFact("window === this", "'function'");
        this.checkGlobalFolding();
    }

    private void checkGlobalFolding() throws Exception {
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("function borken() {  return this.Date.now ? this.Date.now() : +(new this.Date);}function borken2(window) {  return window.Date.now      ? window.Date.now() : +(new window.Date);}function ok() {  return Date.now();}var ok2 = Date.now();var ok3 = Date.now();"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("function borken() {  return this.Date.now ? this.Date.now() : +(new this.Date);}function borken2(window) {  return window.Date.now      ? window.Date.now() : +(new window.Date);}function ok() {  return window.Date.now      ? window.Date.now() : +(new window.Date);}var ok2 = window.Date.now    ? window.Date.now() : +(new window.Date);var ok3 = this.Date.now    ? this.Date.now() : +(new this.Date);")), this.mq)));
        this.assertNoErrors();
    }

    public final void testOptimizeOutGlobals1() throws Exception {
        this.addFact("window === this", "'function'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("function al(t, listener) {  addEventListener(t, listener);}"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("function al(t, listener) {  window.addEventListener(t, listener);}")), this.mq)));
        this.assertNoErrors();
    }

    public final void testOptimizeOutGlobals2() throws Exception {
        this.addFact("window === this", "'function'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("function al(window, t, listener) {  window.addEventListener(t, listener);}"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("function al(window, t, listener) {  window.addEventListener(t, listener);}")), this.mq)));
        this.assertNoErrors();
    }

    public final void testOptimizeOutGlobals3() throws Exception {
        this.addFact("window === this", "'function'");
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("function al(t, addEventListener) {  window.addEventListener(t, addEventListener);}"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("function al(t, addEventListener) {  window.addEventListener(t, addEventListener);}")), this.mq)));
        this.assertNoErrors();
    }

    public final void testComparisonsToSpecials() throws Exception {
        this.addFact("!x", "true");
        this.addFact("!!y", "true");
        this.addFact("NaN", "0/0");
        ParseTreeKBTest.assertEquals((String)Join.join((CharSequence)",", "alert([x==null", "x===null", "x!=null", "x!==null", "x==void 0", "x===void 0", "x!=void 0", "x!==void 0", "x!=''", "x!==''", "x!=0", "x!==0", "x!=1", "true", "x!=(0/0)", "x!==(0/0)", "x!=false", "x!==false", "false", "false", "true", "true", "false", "false", "true", "true", "y!=''", "true", "y!=0", "true", "y!=1", "y!==1", "y!=(0/0)", "true", "y!=false", "true])"), (String)ParseTreeKBTest.renderMin(this.kb.optimize(this.js(this.fromString("alert([\n    x == null,      x === null,\n    x != null,      x !== null,\n    x == undefined, x === undefined,\n    x != undefined, x !== undefined,\n    x != '',        x !== '',\n    x != 0,         x !== 0,\n    x != 1,         x !== 1,\n    x != NaN,       x !== NaN,\n    x != false,     x !== false,\n    y == null,      y === null,\n    y != null,      y !== null,\n    y == undefined, y === undefined,\n    y != undefined, y !== undefined,\n    y != '',        y !== '',\n    y != 0,         y !== 0,\n    y != 1,         y !== 1,\n    y != NaN,       y !== NaN,\n    y != false,     y !== false\n    ])")), this.mq)));
        this.assertNoErrors();
    }

    public final void testFolding() throws Exception {
        ParseTreeKBTest.assertEquals((String)ParseTreeKBTest.render(this.js(this.fromString("x = 2;"))), (String)ParseTreeKBTest.render(this.kb.optimize(this.js(this.fromString("x = 1 + 1;")), this.mq)));
    }

    private void addFact(String expr, String value) throws ParseException {
        this.kb.addFact(this.jsExpr(this.fromString(expr)), Fact.is((Literal)this.jsExpr(this.fromString(value)).fold(false)));
    }

    private void addFuzzyFact(String expr, boolean truthy) throws ParseException {
        this.kb.addFact(this.jsExpr(this.fromString(expr)), truthy ? Fact.TRUTHY : Fact.FALSEY);
    }

    private void assertFacts(String ... expected) {
        this.assertFacts(false, expected);
    }

    private void assertFacts(boolean finish, String ... expected) {
        List<String> expectedKnowledge = Arrays.asList(expected);
        List<String> actualKnowledge = Lists.newArrayList();
        if (finish) {
            this.kb.finishInference();
        }
        for (Pair<Expression, Fact> k : this.knowledge) {
            actualKnowledge.add("(" + ParseTreeKBTest.render((ParseTreeNode)k.a) + ") " + (Object)((Object)((Fact)k.b).type) + " " + ParseTreeKBTest.render(((Fact)k.b).value));
        }
        Collections.sort(actualKnowledge);
        Collections.sort(expectedKnowledge);
        MoreAsserts.assertListsEqual(expectedKnowledge, actualKnowledge);
    }

    private static String renderMin(Block js) {
        StringBuilder sb = new StringBuilder();
        JsMinimalPrinter p = new JsMinimalPrinter(new Concatenator(sb));
        p.setLineLengthLimit(1000);
        js.renderBody(new RenderContext(p));
        p.noMoreTokens();
        return sb.toString();
    }
}

