/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pc.ExoPortletState;
import org.exoplatform.portal.pc.ExoPortletStateType;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.exoplatform.portal.pom.spi.wsrp.WSRPPortletStateType;
import org.exoplatform.portal.webui.application.GadgetUtil;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelAdapter<S, C extends Serializable> {
    private static final ModelAdapter<Portlet, ExoPortletState> PORTLET = new ModelAdapter<Portlet, ExoPortletState>(){

        @Override
        public StatefulPortletContext<ExoPortletState> getPortletContext(ExoContainer container, String applicationId, ApplicationState<Portlet> applicationState) throws Exception {
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            Portlet preferences = (Portlet)dataStorage.load(applicationState, ApplicationType.PORTLET);
            PortletContext producerOfferedPortletContext = this.getProducerOfferedPortletContext(applicationId);
            ExoPortletState map = new ExoPortletState(producerOfferedPortletContext.getId());
            if (preferences != null) {
                for (Preference pref : preferences) {
                    map.getState().put(pref.getName(), pref.getValues());
                }
            }
            return StatefulPortletContext.create((String)"local._dumbvalue", (PortletStateType)ExoPortletStateType.getInstance(), (Serializable)map);
        }

        @Override
        public ApplicationState<Portlet> update(ExoContainer container, ExoPortletState updateState, ApplicationState<Portlet> applicationState) throws Exception {
            PortletBuilder builder = new PortletBuilder();
            for (Map.Entry entry : updateState.getState().entrySet()) {
                builder.add((String)entry.getKey(), (List)entry.getValue());
            }
            if (applicationState instanceof TransientApplicationState) {
                TransientApplicationState transientState = (TransientApplicationState)applicationState;
                transientState.setContentState((Object)builder.build());
                return transientState;
            }
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            return dataStorage.save(applicationState, (Object)builder.build());
        }

        @Override
        public PortletContext getProducerOfferedPortletContext(String applicationState) {
            int indexOfSeparator = applicationState.lastIndexOf("/");
            String appName = applicationState.substring(0, indexOfSeparator);
            String portletName = applicationState.substring(indexOfSeparator + 1);
            return PortletContext.createPortletContext((String)("local./" + appName + "." + portletName));
        }

        @Override
        public Portlet getState(ExoContainer container, ApplicationState<Portlet> applicationState) throws Exception {
            if (applicationState instanceof TransientApplicationState) {
                TransientApplicationState transientState = (TransientApplicationState)applicationState;
                Portlet pref = (Portlet)transientState.getContentState();
                if (pref == null) {
                    pref = new Portlet();
                }
                return pref;
            }
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            Portlet pref = (Portlet)dataStorage.load(applicationState, ApplicationType.PORTLET);
            if (pref == null) {
                pref = new Portlet();
            }
            return pref;
        }

        @Override
        public ExoPortletState getStateFromModifiedContext(PortletContext originalPortletContext, PortletContext modifiedPortletContext) {
            StatefulPortletContext statefulContext;
            if (modifiedPortletContext != null && modifiedPortletContext instanceof StatefulPortletContext && (statefulContext = (StatefulPortletContext)modifiedPortletContext).getState() instanceof ExoPortletState) {
                return (ExoPortletState)statefulContext.getState();
            }
            return null;
        }

        @Override
        public ExoPortletState getstateFromClonedContext(PortletContext originalPortletContext, PortletContext clonedPortletContext) {
            StatefulPortletContext statefulContext;
            if (clonedPortletContext != null && clonedPortletContext instanceof StatefulPortletContext && (statefulContext = (StatefulPortletContext)clonedPortletContext).getState() instanceof ExoPortletState) {
                return (ExoPortletState)statefulContext.getState();
            }
            return null;
        }
    };
    private static final ModelAdapter<org.exoplatform.portal.pom.spi.gadget.Gadget, ExoPortletState> GADGET = new ModelAdapter<org.exoplatform.portal.pom.spi.gadget.Gadget, ExoPortletState>(){
        private final String WRAPPER_ID = "local./dashboard.GadgetPortlet";
        private final PortletContext WRAPPER_CONTEXT = PortletContext.createPortletContext((String)"local./dashboard.GadgetPortlet");

        @Override
        public StatefulPortletContext<ExoPortletState> getPortletContext(ExoContainer container, String applicationId, ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> applicationState) throws Exception {
            GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
            Gadget model = gadgetService.getGadget(applicationId);
            String url = GadgetUtil.reproduceUrl(model.getUrl(), model.isLocal());
            ExoPortletState prefs = new ExoPortletState("local./dashboard.GadgetPortlet");
            prefs.getState().put("url", Arrays.asList(url));
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            org.exoplatform.portal.pom.spi.gadget.Gadget gadget = (org.exoplatform.portal.pom.spi.gadget.Gadget)dataStorage.load(applicationState, ApplicationType.GADGET);
            if (gadget != null && gadget.getUserPref() != null) {
                prefs.getState().put("userPref", Collections.singletonList(gadget.getUserPref()));
            }
            return StatefulPortletContext.create((String)"local._dumbvalue", (PortletStateType)ExoPortletStateType.getInstance(), (Serializable)prefs);
        }

        @Override
        public ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> update(ExoContainer container, ExoPortletState updateState, ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> gadgetApplicationState) throws Exception {
            String userPref = null;
            for (Map.Entry entry : updateState.getState().entrySet()) {
                if (!((String)entry.getKey()).equals("userPref") || ((List)entry.getValue()).size() <= 0) continue;
                userPref = (String)((List)entry.getValue()).get(0);
            }
            if (gadgetApplicationState instanceof TransientApplicationState) {
                throw new UnsupportedOperationException("todo");
            }
            if (userPref != null) {
                org.exoplatform.portal.pom.spi.gadget.Gadget gadget = new org.exoplatform.portal.pom.spi.gadget.Gadget();
                gadget.addUserPref(userPref);
                DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
                dataStorage.save(gadgetApplicationState, (Object)gadget);
            }
            return gadgetApplicationState;
        }

        @Override
        public PortletContext getProducerOfferedPortletContext(String applicationState) {
            return this.WRAPPER_CONTEXT;
        }

        @Override
        public Portlet getState(ExoContainer container, ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> applicationState) throws Exception {
            return null;
        }

        @Override
        public ExoPortletState getStateFromModifiedContext(PortletContext originalPortletContext, PortletContext modifiedPortletContext) {
            StatefulPortletContext statefulContext;
            if (modifiedPortletContext != null && modifiedPortletContext instanceof StatefulPortletContext && (statefulContext = (StatefulPortletContext)modifiedPortletContext).getState() instanceof ExoPortletState) {
                return (ExoPortletState)statefulContext.getState();
            }
            return null;
        }

        @Override
        public ExoPortletState getstateFromClonedContext(PortletContext originalPortletContext, PortletContext clonedPortletContext) {
            StatefulPortletContext statefulContext;
            if (clonedPortletContext != null && clonedPortletContext instanceof StatefulPortletContext && (statefulContext = (StatefulPortletContext)clonedPortletContext).getState() instanceof ExoPortletState) {
                return (ExoPortletState)statefulContext.getState();
            }
            return null;
        }
    };
    private static final ModelAdapter<WSRP, WSRP> WSRP = new ModelAdapter<WSRP, WSRP>(){

        @Override
        public Portlet getState(ExoContainer container, ApplicationState<WSRP> state) throws Exception {
            return null;
        }

        @Override
        public PortletContext getProducerOfferedPortletContext(String applicationId) {
            return PortletContext.createPortletContext((String)applicationId);
        }

        @Override
        public StatefulPortletContext<WSRP> getPortletContext(ExoContainer container, String applicationId, ApplicationState<WSRP> state) throws Exception {
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            WSRP wsrp = (WSRP)dataStorage.load(state, ApplicationType.WSRP_PORTLET);
            if (wsrp == null) {
                wsrp = new WSRP();
                wsrp.setPortletId(applicationId);
                if (!(state instanceof TransientApplicationState)) {
                    dataStorage.save(state, (Object)wsrp);
                }
            }
            return StatefulPortletContext.create((String)wsrp.getPortletId(), (PortletStateType)WSRPPortletStateType.instance, (Serializable)wsrp);
        }

        @Override
        public ApplicationState<WSRP> update(ExoContainer container, WSRP updateState, ApplicationState<WSRP> state) throws Exception {
            if (state instanceof TransientApplicationState) {
                TransientApplicationState transientState = (TransientApplicationState)state;
                transientState.setContentState((Object)updateState);
                return transientState;
            }
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            return dataStorage.save(state, (Object)updateState);
        }

        @Override
        public WSRP getStateFromModifiedContext(PortletContext originalPortletContext, PortletContext modifiedPortletContext) {
            Serializable modifiedState;
            Serializable originalState;
            WSRP wsrp = new WSRP();
            wsrp.setPortletId(modifiedPortletContext.getId());
            if (originalPortletContext instanceof StatefulPortletContext && (originalState = ((StatefulPortletContext)originalPortletContext).getState()) instanceof WSRP) {
                wsrp.setCloned(((WSRP)originalState).isCloned());
            }
            if (modifiedPortletContext instanceof StatefulPortletContext && (modifiedState = ((StatefulPortletContext)modifiedPortletContext).getState()) instanceof byte[]) {
                wsrp.setState((byte[])modifiedState);
            }
            return wsrp;
        }

        @Override
        public WSRP getstateFromClonedContext(PortletContext originalPortletContext, PortletContext clonedPortletContext) {
            WSRP wsrp = new WSRP();
            wsrp.setPortletId(clonedPortletContext.getId());
            wsrp.setCloned(true);
            if (clonedPortletContext instanceof StatefulPortletContext) {
                StatefulPortletContext statefulPortletContext = (StatefulPortletContext)clonedPortletContext;
                wsrp.setState((byte[])statefulPortletContext.getState());
            }
            return wsrp;
        }
    };

    public static <S, C extends Serializable, I> ModelAdapter<S, C> getAdapter(ApplicationType<S> type) {
        if (type == ApplicationType.PORTLET) {
            ModelAdapter<Portlet, ExoPortletState> adapter = PORTLET;
            return adapter;
        }
        if (type == ApplicationType.GADGET) {
            ModelAdapter<org.exoplatform.portal.pom.spi.gadget.Gadget, ExoPortletState> adapter = GADGET;
            return adapter;
        }
        if (type == ApplicationType.WSRP_PORTLET) {
            ModelAdapter<WSRP, WSRP> adapter = WSRP;
            return adapter;
        }
        throw new AssertionError();
    }

    public abstract PortletContext getProducerOfferedPortletContext(String var1);

    public abstract StatefulPortletContext<C> getPortletContext(ExoContainer var1, String var2, ApplicationState<S> var3) throws Exception;

    public abstract ApplicationState<S> update(ExoContainer var1, C var2, ApplicationState<S> var3) throws Exception;

    public abstract Portlet getState(ExoContainer var1, ApplicationState<S> var2) throws Exception;

    public abstract C getStateFromModifiedContext(PortletContext var1, PortletContext var2);

    public abstract C getstateFromClonedContext(PortletContext var1, PortletContext var2);
}

