/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api.visit;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.VisitorStrategy;
import org.reflext.api.visit.HierarchyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HierarchyVisitorStrategy<V extends HierarchyVisitor<V>>
implements VisitorStrategy<V, HierarchyVisitorStrategy<V>> {
    @Override
    public final void visit(TypeInfo type, V visitor) {
        if (type instanceof ClassTypeInfo) {
            ClassTypeInfo classType = (ClassTypeInfo)type;
            if (this.accept(classType)) {
                if (visitor.enter(classType)) {
                    TypeInfo superType = classType.getSuperType();
                    if (superType != null) {
                        this.visit(superType, visitor);
                    }
                    for (TypeInfo implementedInterface : classType.getInterfaces()) {
                        this.visit(implementedInterface, visitor);
                    }
                    visitor.leave(classType);
                }
                this.leave(classType);
            }
        } else if (type instanceof ParameterizedTypeInfo) {
            this.visit(((ParameterizedTypeInfo)type).getRawType(), visitor);
        }
    }

    protected boolean accept(ClassTypeInfo type) {
        return true;
    }

    protected void leave(ClassTypeInfo type) {
    }
}

