/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.ReadOnlyThroughChanges;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListenerFilter;
import org.exoplatform.services.jcr.dataflow.persistent.MandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedItemData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.AbstractPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ReadOnlyWorkspaceException;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManagerListener;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspacePersistentDataManager
implements PersistentDataManager {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspacePersistentDataManager");
    protected final WorkspaceDataContainer dataContainer;
    protected final WorkspaceDataContainer systemDataContainer;
    protected final List<ItemsPersistenceListener> listeners;
    protected final List<MandatoryItemsPersistenceListener> mandatoryListeners;
    protected final List<ItemsPersistenceListenerFilter> liestenerFilters;
    protected boolean readOnly = false;
    private final TransactionableResourceManager txResourceManager;

    protected WorkspacePersistentDataManager(WorkspaceDataContainer dataContainer, SystemDataContainerHolder systemDataContainerHolder) {
        this(dataContainer, systemDataContainerHolder, null);
    }

    public WorkspacePersistentDataManager(WorkspaceDataContainer dataContainer, SystemDataContainerHolder systemDataContainerHolder, TransactionableResourceManager txResourceManager) {
        this.dataContainer = dataContainer;
        this.systemDataContainer = systemDataContainerHolder.getContainer();
        this.listeners = new ArrayList<ItemsPersistenceListener>();
        this.mandatoryListeners = new ArrayList<MandatoryItemsPersistenceListener>();
        this.liestenerFilters = new ArrayList<ItemsPersistenceListenerFilter>();
        this.txResourceManager = txResourceManager;
    }

    public void save(ChangesLogWrapper logWrapper) throws RepositoryException {
        ItemStateChangesLog changesLog = logWrapper.getChangesLog();
        if (this.readOnly && !(changesLog instanceof ReadOnlyThroughChanges)) {
            throw new ReadOnlyWorkspaceException("Workspace container '" + this.dataContainer.getName() + "' is read-only.");
        }
        ChangesLogPersister persister = new ChangesLogPersister();
        boolean failed = true;
        ConnectionMode mode = this.getMode();
        try {
            ItemStateChangesLog persistedLog;
            if (changesLog instanceof PlainChangesLogImpl) {
                persistedLog = persister.save((PlainChangesLogImpl)changesLog);
            } else if (changesLog instanceof TransactionChangesLog) {
                TransactionChangesLog orig = (TransactionChangesLog)changesLog;
                TransactionChangesLog persisted = new TransactionChangesLog();
                persisted.setSystemId(orig.getSystemId());
                ChangesLogIterator iter = orig.getLogIterator();
                while (iter.hasNextLog()) {
                    persisted.addLog(persister.save(iter.nextLog()));
                }
                persistedLog = persisted;
            } else {
                throw new RepositoryException("Unsupported changes log class " + changesLog.getClass());
            }
            logWrapper.setLog(persistedLog);
            this.notifySaveItems(persistedLog, true);
            this.onCommit(persister, mode);
            failed = false;
        }
        catch (IOException e) {
            throw new RepositoryException("Save error", (Throwable)e);
        }
        finally {
            persister.clear();
            if (failed) {
                this.onRollback(persister, mode);
            }
        }
    }

    private ConnectionMode getMode() {
        if (this.txResourceManager != null && this.txResourceManager.isGlobalTxActive()) {
            return ConnectionMode.PARTIALLY_MANAGED;
        }
        return ConnectionMode.NORMAL;
    }

    private void onRollback(ChangesLogPersister persister, ConnectionMode mode) throws RepositoryException {
        if (mode == ConnectionMode.NORMAL || mode == ConnectionMode.PARTIALLY_MANAGED) {
            persister.rollback();
        }
    }

    private void onCommit(final ChangesLogPersister persister, ConnectionMode mode) throws RepositoryException {
        if (mode == ConnectionMode.NORMAL) {
            persister.commit();
        } else if (mode == ConnectionMode.PARTIALLY_MANAGED) {
            this.txResourceManager.addListener(new TransactionableResourceManagerListener(){

                public void onCommit(boolean onePhase) throws Exception {
                    persister.commit();
                }

                public void onAfterCompletion(int status) throws Exception {
                }

                public void onAbort() throws Exception {
                    persister.rollback();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ItemData itemData = con.getItemData(identifier);
            return itemData;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<PropertyData> allRefs = con.getReferencesData(identifier);
            ArrayList<PropertyData> refProps = new ArrayList<PropertyData>();
            for (int i = 0; i < allRefs.size(); ++i) {
                PropertyData ref = allRefs.get(i);
                if (skipVersionStorage) {
                    if (ref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) continue;
                    refProps.add(ref);
                    continue;
                }
                refProps.add(ref);
            }
            ArrayList<PropertyData> arrayList = refProps;
            return arrayList;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<NodeData> list = con.getChildNodesData(nodeData);
            return list;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getChildNodesDataByPage(NodeData nodeData, int fromOrderNum, int limit, List<NodeData> childNodes) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            boolean bl = con.getChildNodesDataByPage(nodeData, fromOrderNum, limit, childNodes);
            return bl;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData, List<QPathEntryFilter> patternFilters) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<NodeData> list = con.getChildNodesData(nodeData, patternFilters);
            return list;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastOrderNumber(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            int n = con.getLastOrderNumber(nodeData);
            return n;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            int n = con.getChildNodesCount(parent);
            return n;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<PropertyData> list = con.getChildPropertiesData(nodeData);
            return list;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData, List<QPathEntryFilter> itemDataFilters) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<PropertyData> list = con.getChildPropertiesData(nodeData, itemDataFilters);
            return list;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<PropertyData> list = con.listChildPropertiesData(nodeData);
            return list;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSameNameSibling(NodeData node, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException {
        if (node.getQPath().getIndex() > 1) {
            QPathEntry[] path = node.getQPath().getEntries();
            QPathEntry[] siblingPath = new QPathEntry[path.length];
            int li = path.length - 1;
            System.arraycopy(path, 0, siblingPath, 0, li);
            siblingPath[li] = new QPathEntry(path[li], path[li].getIndex() - 1);
            if (addedNodes.contains(new QPath(siblingPath))) {
                return;
            }
            if (this.dataContainer.isCheckSNSNewConnection()) {
                WorkspaceStorageConnection acon = this.dataContainer.openConnection();
                try {
                    this.checkPersistedSNS(node, acon);
                }
                finally {
                    acon.close();
                }
            } else {
                this.checkPersistedSNS(node, con);
            }
        }
    }

    private void checkPersistedSNS(NodeData node, WorkspaceStorageConnection acon) throws RepositoryException {
        QPathEntry myName;
        NodeData parent = (NodeData)acon.getItemData(node.getParentIdentifier());
        ItemData sibling = acon.getItemData(parent, new QPathEntry((myName = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1]).getNamespace(), myName.getName(), myName.getIndex() - 1), ItemType.NODE);
        if (sibling == null || !sibling.isNode()) {
            throw new InvalidItemStateException("Node can't be saved " + node.getQPath().getAsString() + ". No same-name sibling exists with index " + (myName.getIndex() - 1) + ".");
        }
    }

    protected void doDelete(ItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.delete((NodeData)item);
        } else {
            con.delete((PropertyData)item);
        }
    }

    protected void doUpdate(ItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.update((NodeData)item);
        } else {
            con.update((PropertyData)item);
        }
    }

    protected void doAdd(ItemData item, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            NodeData node = (NodeData)item;
            this.checkSameNameSibling(node, con, addedNodes);
            addedNodes.add(node.getQPath());
            con.add(node);
        } else {
            con.add((PropertyData)item);
        }
    }

    protected void doRename(ItemData item, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException, InvalidItemStateException {
        NodeData node = (NodeData)item;
        this.checkSameNameSibling(node, con, addedNodes);
        addedNodes.add(node.getQPath());
        con.rename(node);
    }

    public Calendar getCurrentTime() {
        return this.dataContainer.getCurrentTime();
    }

    @Override
    public void addItemPersistenceListener(ItemsPersistenceListener listener) {
        if (listener instanceof MandatoryItemsPersistenceListener) {
            this.mandatoryListeners.add((MandatoryItemsPersistenceListener)listener);
        } else {
            this.listeners.add(listener);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Workspace '" + this.dataContainer.getName() + "' listener registered: " + listener));
        }
    }

    @Override
    public void removeItemPersistenceListener(ItemsPersistenceListener listener) {
        if (listener instanceof MandatoryItemsPersistenceListener) {
            this.mandatoryListeners.remove(listener);
        } else {
            this.listeners.remove(listener);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Workspace '" + this.dataContainer.getName() + "' listener unregistered: " + listener));
        }
    }

    @Override
    public void addItemPersistenceListenerFilter(ItemsPersistenceListenerFilter filter) {
        this.liestenerFilters.add(filter);
    }

    @Override
    public void removeItemPersistenceListenerFilter(ItemsPersistenceListenerFilter filter) {
        this.liestenerFilters.remove(filter);
    }

    protected boolean isListenerAccepted(ItemsPersistenceListener listener) {
        for (ItemsPersistenceListenerFilter f : this.liestenerFilters) {
            if (f.accept(listener)) continue;
            return false;
        }
        return true;
    }

    protected void notifySaveItems(ItemStateChangesLog changesLog, boolean isListenerTXAware) {
        for (MandatoryItemsPersistenceListener mlistener : this.mandatoryListeners) {
            if (mlistener.isTXAware() != isListenerTXAware) continue;
            mlistener.onSaveItems(changesLog);
        }
        for (ItemsPersistenceListener listener : this.listeners) {
            if (listener.isTXAware() != isListenerTXAware || !this.isListenerAccepted(listener)) continue;
            listener.onSaveItems(changesLog);
        }
    }

    private boolean isSystemDescendant(QPath path) {
        return path.isDescendantOf(Constants.JCR_SYSTEM_PATH) || path.equals(Constants.JCR_SYSTEM_PATH);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        return this.getItemData(parentData, name, ItemType.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ItemData itemData = con.getItemData(parentData, name, itemType);
            return itemData;
        }
        finally {
            con.close();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean status) {
        this.readOnly = status;
    }

    class ChangesLogPersister {
        private final Set<QPath> addedNodes = new HashSet<QPath>();
        private WorkspaceStorageConnection thisConnection = null;
        private WorkspaceStorageConnection systemConnection = null;

        ChangesLogPersister() {
        }

        protected void commit() throws IllegalStateException, RepositoryException {
            if (this.thisConnection != null) {
                this.thisConnection.commit();
            }
            if (this.systemConnection != null && !this.systemConnection.equals(this.thisConnection)) {
                this.systemConnection.commit();
            }
        }

        protected void clear() {
            this.addedNodes.clear();
        }

        protected void rollback() throws IllegalStateException, RepositoryException {
            if (this.thisConnection != null && this.thisConnection.isOpened()) {
                this.thisConnection.rollback();
            }
            if (this.systemConnection != null && !this.systemConnection.equals(this.thisConnection) && this.systemConnection.isOpened()) {
                this.systemConnection.rollback();
            }
        }

        protected WorkspaceStorageConnection getSystemConnection() throws RepositoryException {
            WorkspaceStorageConnection workspaceStorageConnection;
            if (this.systemConnection == null) {
                WorkspaceStorageConnection workspaceStorageConnection2 = WorkspacePersistentDataManager.this.systemDataContainer != WorkspacePersistentDataManager.this.dataContainer ? (WorkspacePersistentDataManager.this.systemDataContainer.equals(WorkspacePersistentDataManager.this.dataContainer) && this.thisConnection != null ? WorkspacePersistentDataManager.this.systemDataContainer.reuseConnection(this.thisConnection) : WorkspacePersistentDataManager.this.systemDataContainer.openConnection(false)) : (this.thisConnection == null ? (this.thisConnection = WorkspacePersistentDataManager.this.dataContainer.openConnection(false)) : this.thisConnection);
                workspaceStorageConnection = this.systemConnection = workspaceStorageConnection2;
            } else {
                workspaceStorageConnection = this.systemConnection;
            }
            return workspaceStorageConnection;
        }

        protected WorkspaceStorageConnection getThisConnection() throws RepositoryException {
            WorkspaceStorageConnection workspaceStorageConnection;
            if (this.thisConnection == null) {
                WorkspaceStorageConnection workspaceStorageConnection2 = WorkspacePersistentDataManager.this.systemDataContainer != WorkspacePersistentDataManager.this.dataContainer ? (WorkspacePersistentDataManager.this.dataContainer.equals(WorkspacePersistentDataManager.this.systemDataContainer) && this.systemConnection != null ? WorkspacePersistentDataManager.this.dataContainer.reuseConnection(this.systemConnection) : WorkspacePersistentDataManager.this.dataContainer.openConnection(false)) : (this.systemConnection == null ? (this.systemConnection = WorkspacePersistentDataManager.this.dataContainer.openConnection(false)) : this.systemConnection);
                workspaceStorageConnection = this.thisConnection = workspaceStorageConnection2;
            } else {
                workspaceStorageConnection = this.thisConnection;
            }
            return workspaceStorageConnection;
        }

        protected PlainChangesLogImpl save(PlainChangesLog changesLog) throws InvalidItemStateException, RepositoryException, IOException {
            PlainChangesLogImpl newLog = PlainChangesLogImpl.createCopy(new ArrayList<ItemState>(), changesLog);
            for (ItemState prevState : changesLog.getAllStates()) {
                ItemData data;
                ItemData prevData;
                ItemData newData;
                if (prevState.getData() instanceof PersistedItemData) {
                    newData = prevState.getData();
                } else if (prevState.isNode()) {
                    prevData = (NodeData)prevState.getData();
                    newData = new PersistedNodeData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getOrderNumber(), prevData.getPrimaryTypeName(), prevData.getMixinTypeNames(), prevData.getACL());
                } else {
                    prevData = (PropertyData)prevState.getData();
                    if (prevData.getValues() != null) {
                        ArrayList<ValueData> values = new ArrayList<ValueData>();
                        for (int i = 0; i < prevData.getValues().size(); ++i) {
                            ValueData vd = prevData.getValues().get(i);
                            if (vd instanceof TransientValueData) {
                                AbstractPersistedValueData pvd;
                                TransientValueData tvd = (TransientValueData)vd;
                                if (vd.isByteArray()) {
                                    pvd = new ByteArrayPersistedValueData(i, vd.getAsByteArray());
                                    values.add(pvd);
                                } else {
                                    File destFile = null;
                                    pvd = tvd.getSpoolFile() != null ? new StreamPersistedValueData(i, tvd.getSpoolFile(), destFile) : new StreamPersistedValueData(i, tvd.getOriginalStream(), destFile);
                                    values.add(pvd);
                                }
                                tvd.delegate(pvd);
                                continue;
                            }
                            values.add(vd);
                        }
                        newData = new PersistedPropertyData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getType(), prevData.isMultiValued(), values);
                    } else {
                        newData = new PersistedPropertyData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getType(), prevData.isMultiValued(), null);
                    }
                }
                ItemState itemState = new ItemState(newData, prevState.getState(), prevState.isEventFire(), prevState.getAncestorToSave(), prevState.isInternallyCreated(), prevState.isPersisted(), prevState.getOldPath());
                newLog.add(itemState);
                if (!itemState.isPersisted()) continue;
                long start = 0L;
                if (LOG.isDebugEnabled()) {
                    start = System.currentTimeMillis();
                }
                WorkspaceStorageConnection conn = WorkspacePersistentDataManager.this.isSystemDescendant((data = itemState.getData()).getQPath()) ? this.getSystemConnection() : this.getThisConnection();
                if (itemState.isAdded()) {
                    WorkspacePersistentDataManager.this.doAdd(data, conn, this.addedNodes);
                } else if (itemState.isUpdated()) {
                    WorkspacePersistentDataManager.this.doUpdate(data, conn);
                } else if (itemState.isDeleted()) {
                    WorkspacePersistentDataManager.this.doDelete(data, conn);
                } else if (itemState.isRenamed()) {
                    WorkspacePersistentDataManager.this.doRename(data, conn, this.addedNodes);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(ItemState.nameFromValue(itemState.getState()) + " " + (System.currentTimeMillis() - start) + "ms, " + data.getQPath().getAsString()));
            }
            return newLog;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnectionMode {
        NORMAL,
        PARTIALLY_MANAGED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChangesLogWrapper
    implements ItemStateChangesLog {
        private ItemStateChangesLog log;

        ChangesLogWrapper(ItemStateChangesLog log) {
            this.log = log;
        }

        protected void setLog(ItemStateChangesLog log) {
            this.log = log;
        }

        protected ItemStateChangesLog getChangesLog() {
            return this.log;
        }

        @Override
        public List<ItemState> getAllStates() {
            return this.log.getAllStates();
        }

        @Override
        public int getSize() {
            return this.log.getSize();
        }

        @Override
        public String dump() {
            return this.log.dump();
        }
    }
}

