/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.ExtensionFactory;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.ParserFactory;
import org.apache.abdera.util.Constants;
import org.apache.abdera.writer.StreamWriter;
import org.apache.abdera.writer.Writer;
import org.apache.abdera.writer.WriterFactory;
import org.apache.abdera.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceUtil
implements Constants {
    ServiceUtil() {
    }

    public static Object newInstance(String id, String _default, Abdera abdera) {
        return ServiceUtil.locate(id, _default, abdera);
    }

    public static Object newInstance(String id, String _default, Abdera abdera, Object ... args) {
        return ServiceUtil.locate(id, _default, abdera, args);
    }

    public static XPath newXPathInstance(Abdera abdera) {
        return (XPath)ServiceUtil.newInstance("org.apache.abdera.xpath.XPath", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.xpath.XPath", "org.apache.abdera.parser.stax.FOMXPath"), abdera);
    }

    public static Parser newParserInstance(Abdera abdera) {
        return (Parser)ServiceUtil.newInstance("org.apache.abdera.parser.Parser", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.parser.Parser", "org.apache.abdera.parser.stax.FOMParser"), abdera);
    }

    public static Factory newFactoryInstance(Abdera abdera) {
        return (Factory)ServiceUtil.newInstance("org.apache.abdera.factory.Factory", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.factory.Factory", "org.apache.abdera.parser.stax.FOMFactory"), abdera);
    }

    public static ParserFactory newParserFactoryInstance(Abdera abdera) {
        return (ParserFactory)ServiceUtil.newInstance("org.apache.abdera.parser.ParserFactory", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.parser.ParserFactory", "org.apache.abdera.parser.stax.FOMParserFactory"), abdera);
    }

    public static WriterFactory newWriterFactoryInstance(Abdera abdera) {
        return (WriterFactory)ServiceUtil.newInstance("org.apache.abdera.writer.WriterFactory", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.writer.WriterFactory", "org.apache.abdera.parser.stax.FOMWriterFactory"), abdera);
    }

    public static Writer newWriterInstance(Abdera abdera) {
        return (Writer)ServiceUtil.newInstance("org.apache.abdera.writer.Writer", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.writer.Writer", "org.apache.abdera.parser.stax.FOMWriter"), abdera);
    }

    public static StreamWriter newStreamWriterInstance(Abdera abdera) {
        return (StreamWriter)ServiceUtil.newInstance("org.apache.abdera.writer.StreamWriter", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.writer.StreamWriter", "org.apache.abdera.parser.stax.StaxStreamWriter"), abdera);
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Object locate(String id, String _default, Abdera abdera) {
        Object object = ServiceUtil.locate(id, abdera);
        if (object == null && _default != null) {
            object = ServiceUtil.locateInstance(ServiceUtil.getClassLoader(), _default, abdera);
        }
        return object;
    }

    public static Object locate(String id, String _default, Abdera abdera, Object ... args) {
        Object object = ServiceUtil.locate(id, abdera);
        if (object == null && _default != null) {
            object = ServiceUtil.locateInstance(ServiceUtil.getClassLoader(), _default, abdera, args);
        }
        return object;
    }

    public static Object locate(String id, Abdera abdera) {
        Object service = ServiceUtil.checkAbderaConfiguration(id, abdera);
        return service != null ? service : ServiceUtil.checkMetaInfServices(id, abdera);
    }

    private static Object _create(Class _class, Abdera abdera) {
        if (_class == null) {
            return null;
        }
        try {
            if (abdera != null) {
                Constructor c = _class.getConstructor(Abdera.class);
                return c.newInstance(abdera);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return _class.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object _create(Class _class, Abdera abdera, Object ... args) {
        Class[] types = null;
        Object[] values = null;
        if (_class == null) {
            return null;
        }
        try {
            if (abdera != null) {
                types = new Class[args.length + 1];
                values = new Object[args.length + 1];
                types[0] = Abdera.class;
                values[0] = abdera;
                for (int n = 0; n < args.length; ++n) {
                    types[n + 1] = args[n].getClass();
                    values[n + 1] = args[n];
                }
                Constructor c = _class.getConstructor(types);
                return c.newInstance(values);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            types = new Class[args.length];
            for (int n = 0; n < args.length; ++n) {
                types[n] = args[n].getClass();
            }
            return _class.getConstructor(types).newInstance(args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object locateInstance(ClassLoader loader, String id, Abdera abdera) {
        return ServiceUtil.locateInstance(loader, id, abdera, false);
    }

    public static Object locateInstance(ClassLoader loader, String id, Abdera abdera, boolean classesonly) {
        try {
            Class<?> _class = loader.loadClass(id);
            return classesonly ? _class : ServiceUtil._create(_class, abdera);
        }
        catch (Exception e) {
            try {
                Class<?> _class = ClassLoader.getSystemClassLoader().loadClass(id);
                return classesonly ? _class : ServiceUtil._create(_class, abdera);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static Object locateInstance(ClassLoader loader, String id, Abdera abdera, Object ... args) {
        try {
            Class<?> _class = loader.loadClass(id);
            return ServiceUtil._create(_class, abdera, args);
        }
        catch (Exception e) {
            try {
                Class<?> _class = ClassLoader.getSystemClassLoader().loadClass(id);
                return ServiceUtil._create(_class, abdera, args);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static InputStream locateStream(ClassLoader loader, String id) {
        InputStream in = loader.getResourceAsStream(id);
        return in != null ? in : ClassLoader.getSystemResourceAsStream(id);
    }

    public static Enumeration<URL> locateResources(ClassLoader loader, String id) {
        try {
            return loader.getResources(id);
        }
        catch (Exception e) {
            try {
                return ClassLoader.getSystemResources(id);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static Object checkAbderaConfiguration(String id, Abdera abdera) {
        String s = abdera.getConfiguration().getConfigurationOption(id);
        return s != null ? ServiceUtil.locateInstance(ServiceUtil.getClassLoader(), id, abdera) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object checkMetaInfServices(String id, Abdera abdera) {
        Object object = null;
        String sid = "META-INF/services/" + id;
        ClassLoader loader = ServiceUtil.getClassLoader();
        BufferedReader buf = null;
        try {
            String line;
            InputStream is = ServiceUtil.locateStream(loader, sid);
            if (is != null && (line = (buf = new BufferedReader(new InputStreamReader(is))).readLine()) != null) {
                String s = line.split("#", 2)[0].trim();
                object = ServiceUtil.locateInstance(loader, s, abdera);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (IOException ioe) {}
            }
        }
        return object;
    }

    protected static synchronized List<ExtensionFactory> loadExtensionFactories() {
        List<ExtensionFactory> factories = ServiceUtil._loadimpls("META-INF/services/org.apache.abdera.factory.ExtensionFactory");
        return factories;
    }

    public static synchronized <T> List<T> loadimpls(String sid) {
        return ServiceUtil.loadimpls(sid, false);
    }

    public static synchronized <T> List<T> loadimpls(String sid, boolean classesonly) {
        return ServiceUtil._loadimpls(sid, classesonly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> List<T> _loadimpls(String sid, boolean classesonly) {
        List<Object> impls = Collections.synchronizedList(new ArrayList());
        ClassLoader loader = ServiceUtil.getClassLoader();
        try {
            Enumeration<URL> e = ServiceUtil.locateResources(loader, sid);
            while (e.hasMoreElements()) {
                BufferedReader buf = null;
                try {
                    String line;
                    URL url = e.nextElement();
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    buf = new BufferedReader(new InputStreamReader(is));
                    while ((line = buf.readLine()) != null) {
                        Object impl;
                        String s = line.split("#", 2)[0].trim();
                        if ("".equals(s) || (impl = ServiceUtil.locateInstance(loader, s, null)) == null) continue;
                        impls.add(impl);
                    }
                }
                catch (Exception ex) {}
                continue;
                finally {
                    if (buf == null) continue;
                    try {
                        buf.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return impls;
    }

    protected static <T> List<T> _loadimpls(String sid) {
        return ServiceUtil._loadimpls(sid, false);
    }
}

