/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.params;

import java.util.Collection;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.ClientConnectionManagerFactory;
import org.apache.http.params.HttpAbstractParamBean;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ClientParamBean
extends HttpAbstractParamBean {
    public ClientParamBean(HttpParams params) {
        super(params);
    }

    public void setConnectionManagerFactoryClassName(String factory) {
        this.params.setParameter("http.connection-manager.factory-class-name", (Object)factory);
    }

    @Deprecated
    public void setConnectionManagerFactory(ClientConnectionManagerFactory factory) {
        this.params.setParameter("http.connection-manager.factory-object", (Object)factory);
    }

    public void setHandleRedirects(boolean handle) {
        this.params.setBooleanParameter("http.protocol.handle-redirects", handle);
    }

    public void setRejectRelativeRedirect(boolean reject) {
        this.params.setBooleanParameter("http.protocol.reject-relative-redirect", reject);
    }

    public void setMaxRedirects(int maxRedirects) {
        this.params.setIntParameter("http.protocol.max-redirects", maxRedirects);
    }

    public void setAllowCircularRedirects(boolean allow) {
        this.params.setBooleanParameter("http.protocol.allow-circular-redirects", allow);
    }

    public void setHandleAuthentication(boolean handle) {
        this.params.setBooleanParameter("http.protocol.handle-authentication", handle);
    }

    public void setCookiePolicy(String policy) {
        this.params.setParameter("http.protocol.cookie-policy", (Object)policy);
    }

    public void setVirtualHost(HttpHost host) {
        this.params.setParameter("http.virtual-host", (Object)host);
    }

    public void setDefaultHeaders(Collection<Header> headers) {
        this.params.setParameter("http.default-headers", headers);
    }

    public void setDefaultHost(HttpHost host) {
        this.params.setParameter("http.default-host", (Object)host);
    }
}

