/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={EmptyTrashActionListener.class}, confirm="EmptyTrashManageComponent.msg.confirm-delete")})
public class EmptyTrashManageComponent
extends UIAbstractManagerComponent {
    private static final Log LOG = ExoLogger.getLogger(EmptyTrashManageComponent.class);
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsTrashHomeNodeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void emptyTrashManage(Event<? extends UIComponent> event, UIJCRExplorer uiExplorer) throws Exception {
        Node trashHomeNode = EmptyTrashManageComponent.getTrashHomeNode(uiExplorer);
        NodeIterator nodeIter = trashHomeNode.getNodes();
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        if (nodeIter.getSize() == 0L) {
            return;
        }
        String currentUser = uiExplorer.getSession().getUserID();
        boolean error = false;
        while (nodeIter.hasNext()) {
            try {
                Node node = nodeIter.nextNode();
                if (!node.hasProperty("exo:lastModifier") || !currentUser.equals(node.getProperty("exo:lastModifier").getString())) continue;
                EmptyTrashManageComponent.deleteNode(node, uiExplorer, event);
            }
            catch (Exception ex) {
                error = true;
            }
        }
        if (error) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.error-when-emptying-trash", null, 1));
        }
    }

    private static void deleteNode(Node nodeToDelete, UIJCRExplorer uiExplorer, Event<? extends UIComponent> event) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String trashWorkspace = portletPref.getValue("trashWorkspace", "");
        String nodePath = nodeToDelete.getPath();
        Session session = uiExplorer.getSessionByWorkspace(trashWorkspace);
        Node node = uiExplorer.getNodeByPath(nodePath, session, false);
        session = node.getSession();
        trashWorkspace = session.getWorkspace().getName();
        node = uiExplorer.getNodeByPath(nodePath, session, false);
        TaxonomyService taxonomyService = (TaxonomyService)uiExplorer.getApplicationComponent(TaxonomyService.class);
        List listTaxonomyTrees = taxonomyService.getAllTaxonomyTrees();
        List listExistedTaxonomy = taxonomyService.getAllCategories(node);
        block0: for (Node existedTaxonomy : listExistedTaxonomy) {
            for (Node taxonomyTrees : listTaxonomyTrees) {
                if (!existedTaxonomy.getPath().contains(taxonomyTrees.getPath())) continue;
                taxonomyService.removeCategory(node, taxonomyTrees.getName(), existedTaxonomy.getPath().substring(taxonomyTrees.getPath().length()));
                continue block0;
            }
        }
        uiExplorer.addLockToken(node);
        Node parentNode = node.getParent();
        uiExplorer.addLockToken(parentNode);
        if (node.isNodeType("rma:record")) {
            EmptyTrashManageComponent.removeMixins(node);
        }
        ActionServiceContainer actionService = (ActionServiceContainer)uiExplorer.getApplicationComponent(ActionServiceContainer.class);
        actionService.removeAction(node, uiExplorer.getRepositoryName());
        ThumbnailService thumbnailService = (ThumbnailService)uiExplorer.getApplicationComponent(ThumbnailService.class);
        thumbnailService.processRemoveThumbnail(node);
        TrashService trashService = (TrashService)uiExplorer.getApplicationComponent(TrashService.class);
        trashService.removeRelations(node, uiExplorer.getSystemProvider());
        node.remove();
        session.save();
        uiExplorer.updateAjax(event);
    }

    private static void removeMixins(Node node) throws Exception {
        NodeType[] mixins;
        for (NodeType nodeType : mixins = node.getMixinNodeTypes()) {
            node.removeMixin(nodeType.getName());
        }
    }

    private static Node getTrashHomeNode(UIJCRExplorer uiExplorer) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String trashHomeNodePath = portletPref.getValue("trashHomeNodePath", "");
        String trashWorkspace = portletPref.getValue("trashWorkspace", "");
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)myContainer.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Session trashSession = uiExplorer.getSessionProvider().getSession(trashWorkspace, manageableRepository);
        return (Node)trashSession.getItem(trashHomeNodePath);
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmptyTrashActionListener
    extends UIWorkingAreaActionListener<EmptyTrashManageComponent> {
        public void processEvent(Event<EmptyTrashManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((EmptyTrashManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            EmptyTrashManageComponent.emptyTrashManage(event, uiExplorer);
        }
    }
}

