/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import javax.jcr.Node;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostEditContentEventListener
extends Listener<CmsService, Node> {
    private static final Log log = ExoLogger.getLogger(PostEditContentEventListener.class);
    private WCMPublicationService publicationService;
    public static final String POST_EDIT_CONTENT_EVENT = "PostEditContentEventListener.event.postEditContent";

    public PostEditContentEventListener(WCMPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    public void onEvent(Event<CmsService, Node> event) throws Exception {
        Node currentNode = (Node)event.getData();
        if (currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:template") || currentNode.isNodeType("exo:jsFile") || currentNode.isNodeType("exo:action")) {
            if (currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:jsFile")) {
                ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
                listenerService.broadcast(POST_EDIT_CONTENT_EVENT, (Object)cmsService, (Object)currentNode);
            }
            return;
        }
        String siteName = "";
        String remoteUser = "";
        try {
            siteName = Util.getPortalRequestContext().getPortalOwner();
            remoteUser = Util.getPortalRequestContext().getRemoteUser();
        }
        catch (NullPointerException npe) {
            ConversationState conversationState = ConversationState.getCurrent();
            if (conversationState == null) {
                return;
            }
            siteName = conversationState.getAttribute("siteName").toString();
            remoteUser = currentNode.getSession().getUserID();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(currentNode.getPath() + "::" + siteName + "::" + remoteUser));
        }
        String currentState = "";
        String newState = "";
        if (currentNode.hasProperty("publication:currentState")) {
            currentState = currentNode.getProperty("publication:currentState").getString();
        }
        this.publicationService.updateLifecyleOnChangeContent(currentNode, siteName, remoteUser);
        if (currentNode.hasProperty("publication:currentState")) {
            newState = currentNode.getProperty("publication:currentState").getString();
        }
        if (currentState.equalsIgnoreCase(newState)) {
            ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
            CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
            listenerService.broadcast(POST_EDIT_CONTENT_EVENT, (Object)cmsService, (Object)currentNode);
        }
    }
}

