/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.content.UIContentSearchForm;
import org.exoplatform.wcm.webui.selector.content.UIContentSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIContentNodeTypeSelector
extends UIForm {
    public static final String WEB_CONTENT_NODETYPE_POPUP = "WebContentNodeTypePopup";

    public void init() throws Exception {
        this.getChildren().clear();
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List nodeTypes = tempService.getAllDocumentNodeTypes();
        UIFormCheckBoxInput uiCheckBox = null;
        for (String nodeType : nodeTypes) {
            uiCheckBox = new UIFormCheckBoxInput(nodeType, nodeType, (Object)"");
            if (this.propertiesSelected(nodeType)) {
                uiCheckBox.setChecked(true);
            } else {
                uiCheckBox.setChecked(false);
            }
            this.addUIFormInput((UIFormInput)uiCheckBox);
        }
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return res.getString("UIContentNodeTypeSelector.label." + id);
        }
        catch (MissingResourceException ex) {
            return id + " ";
        }
    }

    private boolean propertiesSelected(String name) {
        UIPopupWindow popupWindow = (UIPopupWindow)Utils.getPopupContainer((UIContainer)this).getChildById("CorrectContentSelectorPopupWindow");
        UIContentSelector contentSelector = (UIContentSelector)popupWindow.getUIComponent();
        UIContentSearchForm contentSearchForm = (UIContentSearchForm)contentSelector.getChild(UIContentSearchForm.class);
        String typeValues = (String)contentSearchForm.getUIStringInput("docType").getValue();
        if (typeValues == null) {
            return false;
        }
        if (typeValues.indexOf(",") > -1) {
            String[] values;
            for (String value : values = typeValues.split(",")) {
                if (!value.equals(name)) continue;
                return true;
            }
        } else if (typeValues.equals(name)) {
            return true;
        }
        return false;
    }

    private void setNodeTypes(List<String> selectedNodeTypes, UIContentSearchForm uiWCSearchForm) {
        StringBuffer strNodeTypes = new StringBuffer();
        for (int i = 0; i < selectedNodeTypes.size(); ++i) {
            if (strNodeTypes.length() == 0) {
                strNodeTypes = new StringBuffer(selectedNodeTypes.get(i));
                continue;
            }
            strNodeTypes.append(",").append(selectedNodeTypes.get(i));
        }
        uiWCSearchForm.getUIStringInput("docType").setValue((Object)strNodeTypes.toString());
    }

    private void makeSelectedNode(String nodeTypesValue, List<String> selectedNodeTypes, List<UIFormCheckBoxInput> listCheckbox) throws Exception {
        if (nodeTypesValue != null && nodeTypesValue.length() > 0) {
            String[] array = nodeTypesValue.split(",");
            for (int i = 0; i < array.length; ++i) {
                selectedNodeTypes.add(array[i].trim());
            }
        }
        for (int i = 0; i < listCheckbox.size(); ++i) {
            if (listCheckbox.get(i).isChecked()) {
                if (selectedNodeTypes.contains(listCheckbox.get(i).getName())) continue;
                selectedNodeTypes.add(listCheckbox.get(i).getName());
                continue;
            }
            if (selectedNodeTypes.contains(listCheckbox.get(i))) {
                selectedNodeTypes.remove(listCheckbox.get(i).getName());
                continue;
            }
            selectedNodeTypes.remove(listCheckbox.get(i).getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIContentNodeTypeSelector> {
        public void execute(Event<UIContentNodeTypeSelector> event) throws Exception {
            UIContentNodeTypeSelector contentNodetypeSelector = (UIContentNodeTypeSelector)((Object)event.getSource());
            UIPopupWindow popupWindow = (UIPopupWindow)Utils.getPopupContainer((UIContainer)contentNodetypeSelector).getChildById("CorrectContentSelectorPopupWindow");
            UIContentSelector contentSelector = (UIContentSelector)popupWindow.getUIComponent();
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)contentSelector.getChild(UIContentSearchForm.class);
            Utils.closePopupWindow((UIContainer)contentNodetypeSelector, UIContentNodeTypeSelector.WEB_CONTENT_NODETYPE_POPUP);
            contentSelector.setSelectedTab(contentSearchForm.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIContentNodeTypeSelector> {
        public void execute(Event<UIContentNodeTypeSelector> event) throws Exception {
            UIContentNodeTypeSelector contentNodetypeSelector = (UIContentNodeTypeSelector)((Object)event.getSource());
            UIPopupWindow popupWindow = (UIPopupWindow)Utils.getPopupContainer((UIContainer)contentNodetypeSelector).getChildById("CorrectContentSelectorPopupWindow");
            UIContentSelector contentSelector = (UIContentSelector)popupWindow.getUIComponent();
            ArrayList selectedNodeTypes = new ArrayList();
            ArrayList listCheckbox = new ArrayList();
            contentNodetypeSelector.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)contentSelector.getChild(UIContentSearchForm.class);
            String nodeTypesValue = (String)contentSearchForm.getUIStringInput("docType").getValue();
            contentNodetypeSelector.makeSelectedNode(nodeTypesValue, selectedNodeTypes, listCheckbox);
            contentNodetypeSelector.setNodeTypes(selectedNodeTypes, contentSearchForm);
            Utils.closePopupWindow((UIContainer)contentNodetypeSelector, UIContentNodeTypeSelector.WEB_CONTENT_NODETYPE_POPUP);
            contentSelector.setSelectedTab(contentSearchForm.getId());
        }
    }
}

