/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.quasiliteral.InnocentCodeRewriter;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.util.Charsets;
import com.google.caja.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Innocent {
    public static void main(String[] jsFilePaths) throws IOException {
        boolean passed = true;
        for (int i = 0; i < jsFilePaths.length; ++i) {
            String jsFilePath = jsFilePaths[i];
            Pair<InputSource, File> input = Innocent.checkInput(jsFilePath);
            passed = passed && Innocent.transfInnocent(input, new PrintWriter(System.out), new PrintWriter(System.err));
        }
        System.exit(passed ? 0 : -1);
    }

    private static Pair<InputSource, File> checkInput(String jsFile) throws IOException {
        File f = new File(jsFile);
        if (!f.canRead()) {
            throw new IOException("Cannot read " + jsFile);
        }
        InputSource is = new InputSource(f.getAbsoluteFile().toURI());
        Pair<InputSource, File> input = Pair.pair(is, f);
        return input;
    }

    public static boolean transfInnocent(Pair<InputSource, File> input, Writer out, PrintWriter err) throws IOException {
        MessageContext mc = new MessageContext();
        mc.addInputSource((InputSource)input.a);
        EchoingMessageQueue errs = new EchoingMessageQueue(err, mc, false);
        CharProducer cp = CharProducer.Factory.create((Reader)new InputStreamReader((InputStream)new FileInputStream((File)input.b), Charsets.UTF_8.name()), (InputSource)input.a);
        JsLexer lexer = new JsLexer(cp);
        JsTokenQueue tq = new JsTokenQueue(lexer, (InputSource)input.a);
        Parser p = new Parser(tq, errs);
        String output = "";
        try {
            Block start = p.parse();
            tq.expectEmpty();
            InnocentCodeRewriter icr = new InnocentCodeRewriter(errs, false);
            output = Rewriter.render(icr.expand(start));
            out.append(output);
        }
        catch (ParseException ex) {
            ex.toMessageQueue(errs);
        }
        out.flush();
        MessageLevel maxMessageLevel = MessageLevel.values()[0];
        for (Message msg : errs.getMessages()) {
            if (msg.getMessageLevel().compareTo(maxMessageLevel) < 0) continue;
            maxMessageLevel = msg.getMessageLevel();
        }
        return maxMessageLevel.compareTo(MessageLevel.ERROR) < 0;
    }
}

