/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UIViewRelationList.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIViewRelationList
extends UIContainer {
    public List<Node> getRelations() throws Exception {
        String[] wsNames;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ArrayList<Node> relations = new ArrayList<Node>();
        Value[] vals = null;
        try {
            vals = uiExplorer.getCurrentNode().getProperty("exo:relation").getValues();
        }
        catch (Exception e) {
            return relations;
        }
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        for (String wsName : wsNames = repository.getWorkspaceNames()) {
            Session session = WCMCoreUtils.getUserSessionProvider().getSession(wsName, repository);
            for (Value val : vals) {
                String uuid = val.getString();
                try {
                    Node node = session.getNodeByUUID(uuid);
                    if (Utils.isInTrash((Node)node)) continue;
                    relations.add(node);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return relations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getReferences() throws Exception {
        ArrayList<Node> refNodes = new ArrayList<Node>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node currentNode = uiJCRExplorer.getCurrentNode();
        try {
            String uuid = currentNode.getUUID();
            ManageableRepository repository = repositoryService.getCurrentRepository();
            Session session = null;
            for (String workspace : repository.getWorkspaceNames()) {
                session = repository.getSystemSession(workspace);
                try {
                    Node lookupNode = session.getNodeByUUID(uuid);
                    PropertyIterator iter = lookupNode.getReferences();
                    if (iter == null) continue;
                    while (iter.hasNext()) {
                        Node refNode = iter.nextProperty().getParent();
                        if (Utils.isInTrash((Node)refNode) || refNode.isNodeType("exo:auditHistory")) continue;
                        refNodes.add(refNode);
                    }
                }
                catch (Exception e) {
                }
                finally {
                    session.logout();
                }
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            // empty catch block
        }
        return refNodes;
    }

    public List<Node> getLanguages() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node node = uiExplorer.getCurrentNode();
        ArrayList<Node> relations = new ArrayList<Node>();
        MultiLanguageService langService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        List langs = langService.getSupportedLanguages(node);
        for (String lang : langs) {
            Node lnode = langService.getLanguage(node, lang);
            if (lnode == null || !lnode.hasProperty("exo:language")) continue;
            relations.add(lnode);
        }
        return relations;
    }

    public boolean isPreferenceNode(Node node) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isPreferenceNode(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIViewRelationList> {
        public void execute(Event<UIViewRelationList> event) throws Exception {
            UIViewRelationList uicomp = (UIViewRelationList)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Session session = uiExplorer.getSessionByWorkspace(workspaceName);
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            try {
                session.getItem(uri);
            }
            catch (ItemNotFoundException nu) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            uiExplorer.setSelectNode(workspaceName, uri);
            uiExplorer.updateAjax(event);
        }
    }
}

