/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginContext;
import org.apache.catalina.Realm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPrincipal
implements Principal {
    protected String name = null;
    protected String password = null;
    protected Realm realm = null;
    protected String[] roles = new String[0];
    protected Principal userPrincipal = null;
    protected LoginContext loginContext = null;

    public GenericPrincipal(Realm realm, String name, String password) {
        this(realm, name, password, null);
    }

    public GenericPrincipal(Realm realm, String name, String password, List<String> roles) {
        this(realm, name, password, roles, null);
    }

    public GenericPrincipal(Realm realm, String name, String password, List<String> roles, Principal userPrincipal) {
        this(realm, name, password, roles, userPrincipal, null);
    }

    public GenericPrincipal(Realm realm, String name, String password, List<String> roles, Principal userPrincipal, LoginContext loginContext) {
        this.realm = realm;
        this.name = name;
        this.password = password;
        this.userPrincipal = userPrincipal;
        if (roles != null) {
            this.roles = new String[roles.size()];
            this.roles = roles.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
        this.loginContext = loginContext;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Realm getRealm() {
        return this.realm;
    }

    void setRealm(Realm realm) {
        this.realm = realm;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        return this;
    }

    void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public boolean hasRole(String role) {
        if ("*".equals(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, role) >= 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("GenericPrincipal[");
        sb.append(this.name);
        sb.append("(");
        for (int i = 0; i < this.roles.length; ++i) {
            sb.append(this.roles[i]).append(",");
        }
        sb.append(")]");
        return sb.toString();
    }

    public void logout() throws Exception {
        if (this.loginContext != null) {
            this.loginContext.logout();
        }
    }
}

