/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpbf.model;

import java.io.IOException;
import org.apache.poi.hpbf.model.HPBFPart;
import org.apache.poi.hpbf.model.qcbits.QCBit;
import org.apache.poi.hpbf.model.qcbits.QCPLCBit;
import org.apache.poi.hpbf.model.qcbits.QCTextBit;
import org.apache.poi.hpbf.model.qcbits.UnknownQCBit;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.util.LittleEndian;

public final class QuillContents
extends HPBFPart {
    private static final String[] PATH = new String[]{"Quill", "QuillSub", "CONTENTS"};
    private QCBit[] bits;

    public QuillContents(DirectoryNode baseDir) throws IOException {
        super(baseDir, PATH);
        String f8 = new String(this.data, 0, 8);
        if (!f8.equals("CHNKINK ")) {
            throw new IllegalArgumentException("Expecting 'CHNKINK ' but was '" + f8 + "'");
        }
        this.bits = new QCBit[20];
        for (int i = 0; i < 20; ++i) {
            int offset = 32 + i * 24;
            if (this.data[offset] != 24 || this.data[offset + 1] != 0) continue;
            String thingType = new String(this.data, offset + 2, 4);
            int optA = LittleEndian.getUShort((byte[])this.data, (int)(offset + 6));
            int optB = LittleEndian.getUShort((byte[])this.data, (int)(offset + 8));
            int optC = LittleEndian.getUShort((byte[])this.data, (int)(offset + 10));
            String bitType = new String(this.data, offset + 12, 4);
            int from = (int)LittleEndian.getUInt((byte[])this.data, (int)(offset + 16));
            int len = (int)LittleEndian.getUInt((byte[])this.data, (int)(offset + 20));
            byte[] bitData = new byte[len];
            System.arraycopy(this.data, from, bitData, 0, len);
            this.bits[i] = bitType.equals("TEXT") ? new QCTextBit(thingType, bitType, bitData) : (bitType.equals("PLC ") ? QCPLCBit.createQCPLCBit(thingType, bitType, bitData) : new UnknownQCBit(thingType, bitType, bitData));
            this.bits[i].setOptA(optA);
            this.bits[i].setOptB(optB);
            this.bits[i].setOptC(optC);
            this.bits[i].setDataOffset(from);
        }
    }

    public QCBit[] getBits() {
        return this.bits;
    }

    protected void generateData() {
        throw new IllegalStateException("Not done yet!");
    }
}

