/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTable;
import org.jgroups.blocks.ConnectionTableNIO;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class ConnectionTableTest
extends TestCase {
    private BasicConnectionTable ct1;
    private BasicConnectionTable ct2;
    static String bind_addr_str = null;
    static InetAddress bind_addr = null;
    static byte[] data = new byte[]{98, 101, 108, 97};
    Address addr1;
    Address addr2;
    int port_range = 3;
    static final int PORT1 = 7521;
    static final int PORT2 = 8931;

    public ConnectionTableTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.addr1 = new IpAddress(bind_addr, 7521);
        this.addr2 = new IpAddress(bind_addr, 8931);
    }

    protected void tearDown() throws Exception {
        if (this.ct2 != null) {
            this.ct2.stop();
            this.ct2 = null;
        }
        if (this.ct1 != null) {
            this.ct1.stop();
            this.ct1 = null;
        }
        super.tearDown();
    }

    public void testConcurrentConnect() throws Exception {
        CyclicBarrier barrier = new CyclicBarrier(3);
        this.ct1 = new ConnectionTable(bind_addr, 7521);
        this.ct1.start();
        this.ct2 = new ConnectionTable(bind_addr, 8931);
        this.ct2.start();
        BasicConnectionTable.Receiver dummy = new BasicConnectionTable.Receiver(){

            @Override
            public void receive(Address sender, byte[] data, int offset, int length) {
            }
        };
        this.ct1.setReceiver(dummy);
        this.ct2.setReceiver(dummy);
        Sender sender1 = new Sender((ConnectionTable)this.ct1, barrier, this.addr2, 0L);
        Sender sender2 = new Sender((ConnectionTable)this.ct2, barrier, this.addr1, 0L);
        sender1.start();
        sender2.start();
        Util.sleep(100L);
        System.out.println("ct1: " + this.ct1 + "ct2: " + this.ct2);
        int num_conns = this.ct1.getNumConnections();
        ConnectionTableTest.assertEquals((int)0, (int)num_conns);
        num_conns = this.ct2.getNumConnections();
        ConnectionTableTest.assertEquals((int)0, (int)num_conns);
        barrier.await(10000L, TimeUnit.MILLISECONDS);
        sender1.join();
        sender2.join();
        System.out.println("ct1: " + this.ct1 + "\nct2: " + this.ct2);
        num_conns = this.ct1.getNumConnections();
        ConnectionTableTest.assertEquals((int)1, (int)num_conns);
        num_conns = this.ct2.getNumConnections();
        ConnectionTableTest.assertEquals((int)1, (int)num_conns);
        Util.sleep(500L);
        System.out.println("ct1: " + this.ct1 + "\nct2: " + this.ct2);
        num_conns = this.ct1.getNumConnections();
        ConnectionTableTest.assertEquals((int)1, (int)num_conns);
        num_conns = this.ct2.getNumConnections();
        ConnectionTableTest.assertEquals((int)1, (int)num_conns);
        BasicConnectionTable.Connection connection = this.ct1.getConnection(this.addr2);
        ConnectionTableTest.assertFalse((String)"valid connection to peer", (boolean)connection.isSocketClosed());
        connection = this.ct2.getConnection(this.addr1);
        ConnectionTableTest.assertFalse((String)"valid connection to peer", (boolean)connection.isSocketClosed());
    }

    public void testBlockingQueue() {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Thread taker = new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("taking an element from the queue");
                    queue.take();
                    System.out.println("clear");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        taker.start();
        Util.sleep(500L);
        queue.clear();
        Util.interruptAndWaitToDie(taker);
        ConnectionTableTest.assertFalse((String)("taker: " + taker), (boolean)taker.isAlive());
    }

    public void testStopConnectionTableNoSendQueues() throws Exception {
        this.ct1 = new ConnectionTable(new DummyReceiver(), bind_addr, null, 7521, 7521 + this.port_range, 60000L, 120000L);
        this.ct1.setUseSendQueues(false);
        this.ct1.start();
        this.ct2 = new ConnectionTable(new DummyReceiver(), bind_addr, null, 8931, 8931 + this.port_range, 60000L, 120000L);
        this.ct2.setUseSendQueues(false);
        this.ct2.start();
        this._testStop(this.ct1, this.ct2);
    }

    public void testStopConnectionTableWithSendQueues() throws Exception {
        this.ct1 = new ConnectionTable(new DummyReceiver(), bind_addr, null, 7521, 7521 + this.port_range, 60000L, 120000L);
        this.ct1.start();
        this.ct2 = new ConnectionTable(new DummyReceiver(), bind_addr, null, 8931, 8931 + this.port_range, 60000L, 120000L);
        this.ct2.start();
        this._testStop(this.ct1, this.ct2);
    }

    public void testStopConnectionTableNIONoSendQueues() throws Exception {
        this.ct1 = new ConnectionTableNIO(new DummyReceiver(), bind_addr, null, 7521, 7521 + this.port_range, 60000L, 120000L, false);
        this.ct1.setUseSendQueues(false);
        this.ct2 = new ConnectionTableNIO(new DummyReceiver(), bind_addr, null, 8931, 8931 + this.port_range, 60000L, 120000L, false);
        this.ct2.setUseSendQueues(false);
        this.ct1.start();
        this.ct2.start();
        this._testStop(this.ct1, this.ct2);
    }

    public void testStopConnectionTableNIOWithSendQueues() throws Exception {
        this.ct1 = new ConnectionTableNIO(new DummyReceiver(), bind_addr, null, 7521, 7521 + this.port_range, 60000L, 120000L, false);
        this.ct2 = new ConnectionTableNIO(new DummyReceiver(), bind_addr, null, 8931, 8931 + this.port_range, 60000L, 120000L, false);
        this.ct1.start();
        this.ct2.start();
        this._testStop(this.ct1, this.ct2);
    }

    private void _testStop(BasicConnectionTable table1, BasicConnectionTable table2) throws Exception {
        table1.send(this.addr1, data, 0, data.length);
        ConnectionTableTest.assertEquals((int)0, (int)table1.getNumConnections());
        table1.send(this.addr2, data, 0, data.length);
        table2.send(this.addr2, data, 0, data.length);
        table2.send(this.addr1, data, 0, data.length);
        System.out.println("table1:\n" + table1 + "\ntable2:\n" + table2);
        ConnectionTableTest.assertEquals((int)1, (int)table1.getNumConnections());
        ConnectionTableTest.assertEquals((int)1, (int)table2.getNumConnections());
        table2.stop();
        table1.stop();
        ConnectionTableTest.assertEquals((int)0, (int)table1.getNumConnections());
        ConnectionTableTest.assertEquals((int)0, (int)table2.getNumConnections());
    }

    public static Test suite() {
        return new TestSuite(ConnectionTableTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ConnectionTableTest.suite());
    }

    static {
        try {
            bind_addr_str = System.getProperty("jgroups.bind_addr", "127.0.0.1");
            bind_addr = InetAddress.getByName(bind_addr_str);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    static class DummyReceiverNIO
    implements BasicConnectionTable.Receiver {
        DummyReceiverNIO() {
        }

        @Override
        public void receive(Address sender, byte[] data, int offset, int length) {
            System.out.println("-- received " + length + " bytes from " + sender);
        }
    }

    static class DummyReceiver
    implements BasicConnectionTable.Receiver {
        DummyReceiver() {
        }

        @Override
        public void receive(Address sender, byte[] data, int offset, int length) {
            System.out.println("-- received " + length + " bytes from " + sender);
        }
    }

    private static class Sender
    extends Thread {
        final ConnectionTable conn_table;
        final CyclicBarrier barrier;
        final Address dest;
        final long sleep_time;

        public Sender(ConnectionTable conn_table, CyclicBarrier barrier, Address dest, long sleep_time) {
            this.conn_table = conn_table;
            this.barrier = barrier;
            this.dest = dest;
            this.sleep_time = sleep_time;
        }

        @Override
        public void run() {
            try {
                this.barrier.await(10000L, TimeUnit.MILLISECONDS);
                if (this.sleep_time > 0L) {
                    Util.sleep(this.sleep_time);
                }
                this.conn_table.send(this.dest, data, 0, data.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

