/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.Linter;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.js.Block;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Lists;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Sets;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinterTest
extends CajaTestCase {
    public final void testProvides() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var x;"))).make()), "LINT: testProvides:1+1 - 6: Undocumented global x");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var x = 1;"))).withProvides("x").make()), new String[0]);
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var x = 1;"))).withProvides("x", "y").make()), "ERROR: testProvides: @provides y not provided");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var x = 1;\nvar y;\nif (Math.random()) { y = 1; }"))).withProvides("x", "y").make()), "ERROR: testProvides: @provides y not provided");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("for (var i;;) {}"))).make()), "LINT: testProvides:1+6 - 11: Undocumented global i");
    }

    public final void testMultiplyProvidedSymbols() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var foo = 0, bar = 1;", new InputSource(URI.create("test:///f1"))))).withProvides("foo", "bar").make(), new LintJobMaker(this.js(this.fromString("var bar = 2, baz = 4;", new InputSource(URI.create("test:///f2"))))).withProvides("bar", "baz").make()), "ERROR: f2: Another input, f1, already @provides bar");
    }

    public final void testRequires() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("x();"))).make()), "ERROR: testRequires:1+1 - 2: Symbol x has not been defined");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("x();"))).withRequires("x").make()), new String[0]);
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("x();"))).withRequires("x", "y").make()), "ERROR: testRequires: @requires y not used");
    }

    public final void testOverrides() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("Object = Array;\n"))).make()), "ERROR: testOverrides:1+1 - 7: Invalid assignment to Object");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("Date.now = function () { return (new Date).getTime(); };\n"))).make()), "ERROR: testOverrides:1+1 - 5: Invalid assignment to Date.now");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("Date.now = function () { return (new Date).getTime(); };\n"))).withOverrides("Date").make()), new String[0]);
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var Date;\n"))).withOverrides("Date").make()), new String[0]);
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var data = {}; data[Date] = new Date();\n"))).withProvides("data").make()), new String[0]);
    }

    public final void testFunctionScopes() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("function p(b, c) {\n  var d;\n  d = r * a - b + c * r;\n  return d;}"))).withProvides("p").withRequires("r").make()), "ERROR: testFunctionScopes:3+11 - 12: Symbol a has not been defined");
    }

    public final void testRedefinition() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("(function () { var a = 1; var a = 2; })();"))).make()), "ERROR: testRedefinition:1+27 - 36: a originally defined at testRedefinition:1+16 - 25");
    }

    public final void testCatchBlocks() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("try {\n  throw caution();\n} catch (e) {\n  if (e.to === THE_WIND) {\n    panic(e);\n  }\n}"))).withRequires("caution", "THE_WIND").make()), "ERROR: testCatchBlocks:5+5 - 10: Symbol panic has not been defined");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("try {\n  throw new Error();\n} catch (e) {\n  // swallow exception\n}"))).withProvides("e").make()), "ERROR: testCatchBlocks: @provides e not provided");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var e;\ntry {\n  throw new Error();\n} catch (e) {\n  // swallow exception\n}"))).make()), "LINT: testCatchBlocks:1+1 - 6: Undocumented global e", "WARNING: testCatchBlocks:4+10 - 11: Declaration of e masks declaration at testCatchBlocks:1+1 - 6");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("try {\n  throw new Error();\n} catch (e) {\n  var f = e.stack;\n  print(f);\n}"))).withRequires("print").make()), "LINT: testCatchBlocks:4+3 - 18: Undocumented global f");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("function g(e, f) {\n  try {\n    f();\n  } catch (e) {\n    panic();\n  }\n  return e;\n}"))).withProvides("g").make()), "WARNING: testCatchBlocks:4+12 - 13: Declaration of e masks declaration at testCatchBlocks:1+12 - 13", "ERROR: testCatchBlocks:5+5 - 10: Symbol panic has not been defined");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("function g(e, f) {\n  try {\n    f();\n  } catch (e) {\n    var e = f(false);\n    return e + 1;\n  }\n  return e;\n}"))).withProvides("g").make()), "WARNING: testCatchBlocks:4+12 - 13: Declaration of e masks declaration at testCatchBlocks:1+12 - 13", "ERROR: testCatchBlocks:5+5 - 21: e originally defined at testCatchBlocks:1+12 - 13");
    }

    public final void testLoops() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("(function () {\n  for (var i = 0; i < 10; ++i) { f(i); }\n  for (var i = 10; --i >= 0;) { f(i); }\n})();"))).withRequires("f").make()), new String[0]);
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("(function () {\n  for (var i = 0; i < 10; ++i) {\n    for (var i = 10; --i >= 0;) { f(i); }\n  }\n})();"))).withRequires("f").make()), "ERROR: testLoops:3+10 - 20: Declaration of i masks declaration at testLoops:2+8 - 17");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("(function () {\n  for (var i = 0; i < 10; ++i) { f(i); }\n  return i;})();"))).withRequires("f").make()), "ERROR: testLoops:3+10 - 11: Usage of i declared at testLoops:2+8 - 17 is out of block scope.");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("(function (i) {\n  return function (arr) {\n    var sum = 0;\n    for (var i = arr.length; --i >= 0;) {\n      sum += arr[i];\n    }\n    return sum / i;\n  };\n})(4);"))).make()), "ERROR: testLoops:7+18 - 19: Usage of i declared at testLoops:4+10 - 28 is out of block scope.");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("(function () {\n  var k;\n  for (k in o);\n})();"))).make()), "ERROR: testLoops:3+13 - 14: Symbol o has not been defined");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("for (var k in o);"))).make()), "ERROR: testLoops:1+15 - 16: Symbol o has not been defined", "LINT: testLoops:1+6 - 11: Undocumented global k");
    }

    public final void testIgnoredValue() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var c; f;  \n+n;  \na.b;  \nf && g();  f && g;  f() && g;  \na = b, c = d;  \na = b;  \nm += n;  \nf();  \nnew Array;  \nnew Array();  \nfor (a = b, c = d; !a; ++a, --m, ++c) f;  \n++c;  \nwhile (1) { 1; }\n({ x: 32 });\n"))).withRequires("b", "d", "f", "g", "n").withOverrides("a", "m").withProvides("c").make()), "WARNING: testIgnoredValue:1+8 - 9: Operation has no effect", "WARNING: testIgnoredValue:2+1 - 3: Operation has no effect", "WARNING: testIgnoredValue:3+1 - 4: Operation has no effect", "WARNING: testIgnoredValue:4+12 - 18: Operation has no effect", "WARNING: testIgnoredValue:4+21 - 29: Operation has no effect", "WARNING: testIgnoredValue:5+1 - 13: Operation has no effect", "WARNING: testIgnoredValue:9+1 - 10: Operation has no effect", "WARNING: testIgnoredValue:10+1 - 12: Operation has no effect", "WARNING: testIgnoredValue:11+39 - 40: Operation has no effect", "WARNING: testIgnoredValue:13+13 - 14: Operation has no effect", "WARNING: testIgnoredValue:14+1 - 12: Operation has no effect");
    }

    public final void testDeadCode() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("(function () {\n  return\n      foo();\n})();"))).withRequires("foo").make()), "WARNING: testDeadCode:3+7 - 12: Code is not reachable");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("with (o) {\n  foo();\n}\n"))).withRequires("o", "foo").make()), new String[0]);
    }

    public final void testLiveness() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var a;\nif (Math.random()) {\n  a = new Error();\n}\nthrow a;\n"))).withProvides("a").make()), "WARNING: testLiveness:5+7 - 8: Symbol a may be used before being initialized", "ERROR: testLiveness: @provides a not provided", "WARNING: testLiveness:5+1 - 8: Uncaught exception thrown during initialization");
    }

    public final void testLabels() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("foo: for (;;) { foo: for (;;); }"))).make()), "ERROR: testLabels:1+17 - 31: Label foo nested inside testLabels:1+1 - 33");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("foo: for (;;); foo: for (;;);"))).make()), new String[0]);
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("for (;;) { for (;;); }"))).make()), new String[0]);
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("foo: for (;;) { bar: for (;;); }"))).make()), new String[0]);
    }

    public final void testMisplacedExits() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("return;"))).make()), "ERROR: testMisplacedExits:1+1 - 7: Return does not appear inside a function");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("foo: for (;;) { break bar; }"))).make()), "ERROR: testMisplacedExits:1+17 - 26: Unmatched break or continue to label bar");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("switch (Math.random()) { case 0: continue; }"))).make()), "ERROR: testMisplacedExits:1+34 - 42: Unmatched break or continue to label <default>");
    }

    public final void testIEQuirksScoping() throws Exception {
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var myObject = {\n    foo: function foo() {}\n};\n"))).withProvides("myObject").make()), "LINT: testIEQuirksScoping:2+10 - 27: Undocumented global foo");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var myObject = (function () {\n  return {\n      foo: function foo() {}\n  };\n})();"))).withProvides("myObject").make()), new String[0]);
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var myObject = (function () {\n  var foo = {\n      foo: function foo() {}\n  };\n  return foo;\n})();"))).withProvides("myObject").make()), "ERROR: testIEQuirksScoping:3+12 - 29: foo originally defined at testIEQuirksScoping:2+3 - 4+4");
        this.runLinterTest(this.jobs(new LintJobMaker(this.js(this.fromString("var myObject = (function () {\n  var foo;\n  do \n    foo = {\n        foo: function foo() {}\n    };\n  while (false);\n  return foo;\n})();"))).withProvides("myObject").make()), "ERROR: testIEQuirksScoping:5+14 - 31: foo originally defined at testIEQuirksScoping:2+3 - 10");
    }

    private void runLinterTest(List<Linter.LintJob> inputs, String ... messages) {
        SimpleMessageQueue mq = new SimpleMessageQueue();
        Linter.lint(inputs, new Linter.Environment(Sets.<String>newHashSet()), mq);
        List<String> actualMessageStrs = Lists.newArrayList();
        for (Message msg : mq.getMessages()) {
            actualMessageStrs.add(msg.getMessageLevel().name() + ": " + msg.format(this.mc));
        }
        List<String> goldenMessageStrs = Lists.newArrayList(messages);
        Collections.sort(actualMessageStrs);
        Collections.sort(goldenMessageStrs);
        MoreAsserts.assertListsEqual(goldenMessageStrs, actualMessageStrs);
    }

    private List<Linter.LintJob> jobs(Linter.LintJob ... jobs) {
        return Arrays.asList(jobs);
    }

    static final class LintJobMaker {
        private Block node;
        private Set<String> provides = Sets.newLinkedHashSet();
        private Set<String> requires = Sets.newLinkedHashSet();
        private Set<String> overrides = Sets.newLinkedHashSet();

        LintJobMaker(Block node) {
            this.node = node;
        }

        LintJobMaker withProvides(String ... idents) {
            this.provides.addAll(Arrays.asList(idents));
            return this;
        }

        LintJobMaker withRequires(String ... idents) {
            this.requires.addAll(Arrays.asList(idents));
            return this;
        }

        LintJobMaker withOverrides(String ... idents) {
            this.overrides.addAll(Arrays.asList(idents));
            return this;
        }

        Linter.LintJob make() {
            return new Linter.LintJob(this.node.getFilePosition().source(), this.requires, this.provides, this.overrides, this.node);
        }
    }
}

