/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.initializer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.ext.initializer.NoMemberToSendException;
import org.exoplatform.services.jcr.ext.initializer.RemoteTransport;
import org.exoplatform.services.jcr.ext.initializer.RemoteWorkspaceInitializationException;
import org.exoplatform.services.jcr.ext.initializer.impl.InitializationErrorPacket;
import org.exoplatform.services.jcr.ext.initializer.impl.RemoteHttpClient;
import org.exoplatform.services.jcr.ext.initializer.impl.RemoteReceiver;
import org.exoplatform.services.jcr.ext.initializer.impl.RemoteTransmitter;
import org.exoplatform.services.jcr.ext.replication.ReplicationException;
import org.exoplatform.services.jcr.ext.replication.storage.InvalidChecksumException;
import org.exoplatform.services.jcr.ext.replication.transport.AbstractPacket;
import org.exoplatform.services.jcr.ext.replication.transport.ChannelManager;

public class RemoteTransportImpl
implements RemoteTransport {
    private static final int BUFFER_SIZE = 20480;
    private final ChannelManager channelManager;
    private final RemoteTransmitter remoteTransmitter;
    private final RemoteReceiver remoteReceiver;
    private final File tempDir;
    private final String sourceUrl;
    private CountDownLatch latch = new CountDownLatch(1);

    public RemoteTransportImpl(ChannelManager channelManager, File tempDir, String sourceUrl) {
        this.channelManager = channelManager;
        this.tempDir = tempDir;
        this.sourceUrl = sourceUrl;
        this.remoteTransmitter = new RemoteTransmitter(this.channelManager);
        this.remoteReceiver = new RemoteReceiver(this.tempDir, this.latch);
        this.channelManager.addPacketListener(this.remoteReceiver);
        this.channelManager.addStateListener(this.remoteReceiver);
    }

    public void close() throws RemoteWorkspaceInitializationException {
        this.channelManager.disconnect();
    }

    public File getWorkspaceData(String repositoryName, String workspaceName, String id) throws RemoteWorkspaceInitializationException {
        RemoteHttpClient client = new RemoteHttpClient(this.sourceUrl);
        String result = client.execute(repositoryName, workspaceName, id);
        if (result.startsWith("FAIL")) {
            throw new RemoteWorkspaceInitializationException("Can not getting the remote workspace data : " + result);
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RemoteWorkspaceInitializationException("The interapted : " + e.getMessage(), e);
        }
        if (this.remoteReceiver.getException() != null) {
            throw new RemoteWorkspaceInitializationException("Can not getting the remote workspace data : " + this.remoteReceiver.getException().getMessage(), this.remoteReceiver.getException());
        }
        try {
            this.remoteReceiver.getContext().getChangesFile().validate();
        }
        catch (InvalidChecksumException e) {
            new RemoteWorkspaceInitializationException("Can not getting the remote workspace data : " + e.getMessage(), e);
        }
        String filePath = this.remoteReceiver.getContext().getChangesFile().toString();
        return new File(filePath);
    }

    public void init() throws RemoteWorkspaceInitializationException {
        try {
            this.channelManager.connect();
        }
        catch (ReplicationException e) {
            throw new RemoteWorkspaceInitializationException("Can not  initialize the transport : " + e.getMessage(), e);
        }
    }

    public void sendWorkspaceData(File workspaceData) throws RemoteWorkspaceInitializationException, NoMemberToSendException {
        if (!PrivilegedFileHelper.exists(workspaceData)) {
            throw new RemoteWorkspaceInitializationException("The file with workspace data not exists.");
        }
        try {
            byte[] crc = this.getCheckSum(workspaceData);
            try {
                if (this.channelManager.getOtherMembers().size() == 0) {
                    throw new NoMemberToSendException("No member to sent, member list : " + this.channelManager.getOtherMembers().size());
                }
                this.remoteTransmitter.sendChangesLogFile(this.channelManager.getOtherMembers().get(0), workspaceData, crc);
            }
            catch (IOException e) {
                throw new RemoteWorkspaceInitializationException("Can not send the workspace data file : " + e.getMessage(), e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RemoteWorkspaceInitializationException("Can not calculate the checksum for workspace data file : " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RemoteWorkspaceInitializationException("Can not calculate the checksum for workspace data file : " + e.getMessage(), e);
        }
    }

    public void sendError(String message) throws RemoteWorkspaceInitializationException, NoMemberToSendException {
        try {
            InitializationErrorPacket packet = new InitializationErrorPacket(101, message);
            this.channelManager.sendPacket((AbstractPacket)packet, this.channelManager.getOtherMembers().get(0));
        }
        catch (IOException e) {
            throw new RemoteWorkspaceInitializationException("Cannot send export data " + e.getMessage(), e);
        }
    }

    private byte[] getCheckSum(File f) throws NoSuchAlgorithmException, IOException {
        long length;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        FileInputStream in = PrivilegedFileHelper.fileInputStream(f);
        byte[] buff = new byte[20480];
        for (length = PrivilegedFileHelper.length(f); length >= 20480L; length -= 20480L) {
            ((InputStream)in).read(buff);
            digest.update(buff);
        }
        if (length > 0L) {
            buff = new byte[(int)length];
            ((InputStream)in).read(buff);
            digest.update(buff);
        }
        return digest.digest();
    }
}

