/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.classify.impl;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.services.jcr.ext.classify.NodeClassifyPlugin;

public class TypeClassifyPlugin
extends NodeClassifyPlugin {
    public void classifyChildrenNode(Node parent) throws Exception {
        Session session = parent.getSession();
        NodeIterator nodeIterator = parent.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            NodeType typeOfChild = child.getPrimaryNodeType();
            String typeName = typeOfChild.getName();
            Node classifiedNode = null;
            try {
                classifiedNode = parent.getNode(typeName);
            }
            catch (PathNotFoundException e) {
                classifiedNode = parent.addNode(typeName);
                session.save();
            }
            String srcPath = child.getPath();
            String destPath = classifiedNode.getPath() + "/" + child.getName();
            session.move(srcPath, destPath);
        }
        session.save();
    }
}

